/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.jmx.shaded.org.eclipse.jetty.server.handler;

import io.prometheus.jmx.shaded.javax.servlet.ServletException;
import io.prometheus.jmx.shaded.javax.servlet.http.HttpServletRequest;
import io.prometheus.jmx.shaded.javax.servlet.http.HttpServletResponse;
import io.prometheus.jmx.shaded.org.eclipse.jetty.server.Handler;
import io.prometheus.jmx.shaded.org.eclipse.jetty.server.Request;
import io.prometheus.jmx.shaded.org.eclipse.jetty.server.Server;
import io.prometheus.jmx.shaded.org.eclipse.jetty.server.handler.AbstractHandlerContainer;
import io.prometheus.jmx.shaded.org.eclipse.jetty.util.LazyList;
import io.prometheus.jmx.shaded.org.eclipse.jetty.util.MultiException;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;

public class HandlerCollection
extends AbstractHandlerContainer {
    private final boolean _mutableWhenRunning;
    private volatile Handler[] _handlers;
    private boolean _parallelStart = false;

    public HandlerCollection() {
        this._mutableWhenRunning = false;
    }

    public HandlerCollection(boolean mutableWhenRunning) {
        this._mutableWhenRunning = mutableWhenRunning;
    }

    @Override
    public Handler[] getHandlers() {
        return this._handlers;
    }

    public void setHandlers(Handler[] handlers) {
        int i;
        if (!this._mutableWhenRunning && this.isStarted()) {
            throw new IllegalStateException("STARTED");
        }
        Object[] old_handlers = this._handlers == null ? null : (Handler[])this._handlers.clone();
        this._handlers = handlers;
        Server server = this.getServer();
        MultiException mex = new MultiException();
        for (i = 0; handlers != null && i < handlers.length; ++i) {
            if (handlers[i].getServer() == server) continue;
            handlers[i].setServer(server);
        }
        if (this.getServer() != null) {
            this.getServer().getContainer().update((Object)this, old_handlers, handlers, "handler");
        }
        for (i = 0; old_handlers != null && i < old_handlers.length; ++i) {
            if (old_handlers[i] == null) continue;
            try {
                if (!old_handlers[i].isStarted()) continue;
                old_handlers[i].stop();
                continue;
            }
            catch (Throwable e) {
                mex.add(e);
            }
        }
        mex.ifExceptionThrowRuntime();
    }

    public boolean isParallelStart() {
        return this._parallelStart;
    }

    public void setParallelStart(boolean parallelStart) {
        this._parallelStart = parallelStart;
    }

    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (this._handlers != null && this.isStarted()) {
            MultiException mex = null;
            for (int i = 0; i < this._handlers.length; ++i) {
                try {
                    this._handlers[i].handle(target, baseRequest, request, response);
                    continue;
                }
                catch (IOException e) {
                    throw e;
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    if (mex == null) {
                        mex = new MultiException();
                    }
                    mex.add(e);
                }
            }
            if (mex != null) {
                if (mex.size() == 1) {
                    throw new ServletException(mex.getThrowable(0));
                }
                throw new ServletException(mex);
            }
        }
    }

    @Override
    protected void doStart() throws Exception {
        final MultiException mex = new MultiException();
        if (this._handlers != null) {
            if (this._parallelStart) {
                final CountDownLatch latch = new CountDownLatch(this._handlers.length);
                final ClassLoader loader = Thread.currentThread().getContextClassLoader();
                int i = 0;
                while (i < this._handlers.length) {
                    final int h = i++;
                    this.getServer().getThreadPool().dispatch(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            ClassLoader orig = Thread.currentThread().getContextClassLoader();
                            try {
                                Thread.currentThread().setContextClassLoader(loader);
                                HandlerCollection.this._handlers[h].start();
                            }
                            catch (Throwable e) {
                                mex.add(e);
                            }
                            finally {
                                Thread.currentThread().setContextClassLoader(orig);
                                latch.countDown();
                            }
                        }
                    });
                }
                latch.await();
            } else {
                for (int i = 0; i < this._handlers.length; ++i) {
                    try {
                        this._handlers[i].start();
                        continue;
                    }
                    catch (Throwable e) {
                        mex.add(e);
                    }
                }
            }
        }
        super.doStart();
        mex.ifExceptionThrow();
    }

    @Override
    protected void doStop() throws Exception {
        MultiException mex = new MultiException();
        try {
            super.doStop();
        }
        catch (Throwable e) {
            mex.add(e);
        }
        if (this._handlers != null) {
            int i = this._handlers.length;
            while (i-- > 0) {
                try {
                    this._handlers[i].stop();
                }
                catch (Throwable e) {
                    mex.add(e);
                }
            }
        }
        mex.ifExceptionThrow();
    }

    @Override
    public void setServer(Server server) {
        if (this.isStarted()) {
            throw new IllegalStateException("STARTED");
        }
        Server old_server = this.getServer();
        super.setServer(server);
        Handler[] h = this.getHandlers();
        for (int i = 0; h != null && i < h.length; ++i) {
            h[i].setServer(server);
        }
        if (server != null && server != old_server) {
            server.getContainer().update((Object)this, null, this._handlers, "handler");
        }
    }

    public void addHandler(Handler handler) {
        this.setHandlers(LazyList.addToArray(this.getHandlers(), handler, Handler.class));
    }

    public void removeHandler(Handler handler) {
        Handler[] handlers = this.getHandlers();
        if (handlers != null && handlers.length > 0) {
            this.setHandlers(LazyList.removeFromArray(handlers, handler));
        }
    }

    protected Object expandChildren(Object list, Class byClass) {
        Handler[] handlers = this.getHandlers();
        for (int i = 0; handlers != null && i < handlers.length; ++i) {
            list = this.expandHandler(handlers[i], list, byClass);
        }
        return list;
    }

    @Override
    public void destroy() {
        if (!this.isStopped()) {
            throw new IllegalStateException("!STOPPED");
        }
        Handler[] children = this.getChildHandlers();
        this.setHandlers(null);
        for (Handler child : children) {
            child.destroy();
        }
        super.destroy();
    }
}

