/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.jmx.shaded.io.prometheus.jmx;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.ObjectName;

class JmxMBeanPropertyCache {
    private static final Pattern PROPERTY_PATTERN = Pattern.compile("([^,=:\\*\\?]+)=(\"(?:[^\\\\\"]|\\\\\\\\|\\\\n|\\\\\"|\\\\\\?|\\\\\\*)*\"|[^,=:\"]*)");
    private final Map<ObjectName, LinkedHashMap<String, String>> keyPropertiesPerBean = new ConcurrentHashMap<ObjectName, LinkedHashMap<String, String>>();

    Map<ObjectName, LinkedHashMap<String, String>> getKeyPropertiesPerBean() {
        return this.keyPropertiesPerBean;
    }

    public LinkedHashMap<String, String> getKeyPropertyList(ObjectName mbeanName) {
        LinkedHashMap<String, String> keyProperties = this.keyPropertiesPerBean.get(mbeanName);
        if (keyProperties == null) {
            keyProperties = new LinkedHashMap();
            String properties = mbeanName.getKeyPropertyListString();
            Matcher match = PROPERTY_PATTERN.matcher(properties);
            while (match.lookingAt()) {
                keyProperties.put(match.group(1), match.group(2));
                properties = properties.substring(match.end());
                if (properties.startsWith(",")) {
                    properties = properties.substring(1);
                }
                match.reset(properties);
            }
            this.keyPropertiesPerBean.put(mbeanName, keyProperties);
        }
        return keyProperties;
    }

    public void onlyKeepMBeans(Set<ObjectName> latestBeans) {
        for (ObjectName prevName : this.keyPropertiesPerBean.keySet()) {
            if (latestBeans.contains(prevName)) continue;
            this.keyPropertiesPerBean.remove(prevName);
        }
    }
}

