/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.jmx.common.util;

public class Precondition {
    private Precondition() {
    }

    public static void notNull(Object object) {
        Precondition.notNull(object, "object is null");
    }

    public static void notNull(Object object, String message) {
        if (object == null) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void notNullOrEmpty(String string) {
        Precondition.notNullOrEmpty(string, String.format("string [%s] is null or empty", string));
    }

    public static void notNullOrEmpty(String string, String message) {
        if (string == null || string.trim().isEmpty()) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void isGreaterThanOrEqualTo(int value, int minimumValue) {
        Precondition.isGreaterThanOrEqualTo(value, minimumValue, String.format("value [%s] is less than minimum value [%s]", value, minimumValue));
    }

    public static void isGreaterThanOrEqualTo(int value, int minimumValue, String message) {
        if (value < minimumValue) {
            throw new IllegalArgumentException(message);
        }
    }
}

