/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.jmx.shaded.io.prometheus.client.hotspot;

import io.prometheus.jmx.shaded.io.prometheus.client.Collector;
import io.prometheus.jmx.shaded.io.prometheus.client.CounterMetricFamily;
import io.prometheus.jmx.shaded.io.prometheus.client.GaugeMetricFamily;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.List;

public class ThreadExports
extends Collector {
    private final ThreadMXBean threadBean;

    public ThreadExports() {
        this(ManagementFactory.getThreadMXBean());
    }

    public ThreadExports(ThreadMXBean threadBean) {
        this.threadBean = threadBean;
    }

    void addThreadMetrics(List<Collector.MetricFamilySamples> sampleFamilies) {
        sampleFamilies.add(new GaugeMetricFamily("jvm_threads_current", "Current thread count of a JVM", this.threadBean.getThreadCount()));
        sampleFamilies.add(new GaugeMetricFamily("jvm_threads_daemon", "Daemon thread count of a JVM", this.threadBean.getDaemonThreadCount()));
        sampleFamilies.add(new GaugeMetricFamily("jvm_threads_peak", "Peak thread count of a JVM", this.threadBean.getPeakThreadCount()));
        sampleFamilies.add(new CounterMetricFamily("jvm_threads_started_total", "Started thread count of a JVM", this.threadBean.getTotalStartedThreadCount()));
        sampleFamilies.add(new GaugeMetricFamily("jvm_threads_deadlocked", "Cycles of JVM-threads that are in deadlock waiting to acquire object monitors or ownable synchronizers", ThreadExports.nullSafeArrayLength(this.threadBean.findDeadlockedThreads())));
        sampleFamilies.add(new GaugeMetricFamily("jvm_threads_deadlocked_monitor", "Cycles of JVM-threads that are in deadlock waiting to acquire object monitors", ThreadExports.nullSafeArrayLength(this.threadBean.findMonitorDeadlockedThreads())));
    }

    private static double nullSafeArrayLength(long[] array) {
        return null == array ? 0.0 : (double)array.length;
    }

    @Override
    public List<Collector.MetricFamilySamples> collect() {
        ArrayList<Collector.MetricFamilySamples> mfs = new ArrayList<Collector.MetricFamilySamples>();
        this.addThreadMetrics(mfs);
        return mfs;
    }
}

