/*
 * Decompiled with CFR 0.152.
 */
package reactor.blockhound.integration;

import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import reactor.blockhound.BlockHound;
import reactor.blockhound.integration.BlockHoundIntegration;
import reactor.blockhound.integration.util.TaskWrappingScheduledExecutorService;
import reactor.core.scheduler.NonBlocking;
import reactor.core.scheduler.Schedulers;

public class ReactorIntegration
implements BlockHoundIntegration {
    @Override
    public void applyTo(BlockHound.Builder builder) {
        try {
            Class.forName("reactor.core.publisher.Flux");
        }
        catch (ClassNotFoundException ignored) {
            return;
        }
        try {
            Class.forName("reactor.core.CorePublisher");
            return;
        }
        catch (ClassNotFoundException ignored) {
            builder.allowBlockingCallsInside(ScheduledThreadPoolExecutor.class.getName(), "scheduleAtFixedRate");
            builder.allowBlockingCallsInside(ScheduledThreadPoolExecutor.class.getName() + "$DelayedWorkQueue", "take");
            builder.nonBlockingThreadPredicate(current -> current.or(NonBlocking.class::isInstance));
            for (String className : new String[]{"Flux", "Mono", "ParallelFlux"}) {
                builder.disallowBlockingCallsInside("reactor.core.publisher." + className, "subscribe");
                builder.disallowBlockingCallsInside("reactor.core.publisher." + className, "onNext");
                builder.disallowBlockingCallsInside("reactor.core.publisher." + className, "onError");
                builder.disallowBlockingCallsInside("reactor.core.publisher." + className, "onComplete");
            }
            try {
                Schedulers.addExecutorServiceDecorator((String)"BlockHound", (scheduler, scheduledExecutorService) -> new TaskWrappingScheduledExecutorService((ScheduledExecutorService)scheduledExecutorService){

                    @Override
                    protected Runnable wrap(Runnable runnable) {
                        return new Wrapper(runnable);
                    }

                    @Override
                    protected <V> Callable<V> wrap(Callable<V> callable) {
                        return new Wrapper<V>(callable);
                    }
                });
                builder.disallowBlockingCallsInside(Wrapper.class.getName(), "call");
            }
            catch (NoSuchMethodError e) {
                builder.disallowBlockingCallsInside("reactor.core.scheduler.SchedulerTask", "call");
                builder.disallowBlockingCallsInside("reactor.core.scheduler.WorkerTask", "call");
                builder.disallowBlockingCallsInside("reactor.core.scheduler.PeriodicWorkerTask", "call");
                builder.disallowBlockingCallsInside("reactor.core.scheduler.InstantPeriodicWorkerTask", "call");
            }
            return;
        }
    }

    static class Wrapper<V>
    implements Runnable,
    Callable<V> {
        Runnable runnable;
        Callable<V> callable;

        public Wrapper(Runnable runnable) {
            this.runnable = runnable;
        }

        public Wrapper(Callable<V> callable) {
            this.callable = callable;
        }

        @Override
        public void run() {
            this.runnable.run();
        }

        @Override
        public V call() throws Exception {
            return this.callable.call();
        }
    }
}

