/*
 * Decompiled with CFR 0.152.
 */
package reactor.blockhound;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.Instrumentation;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import reactor.blockhound.BlockHound;

class InstrumentationUtils {
    InstrumentationUtils() {
    }

    static void injectBootstrapClasses(Instrumentation instrumentation, String ... classNames) throws IOException {
        File tempJarFile = File.createTempFile("BlockHound", ".jar");
        tempJarFile.deleteOnExit();
        ClassLoader classLoader = BlockHound.class.getClassLoader();
        try (ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(tempJarFile));){
            for (String className : classNames) {
                int n;
                String classFile = className.replace(".", "/") + ".class";
                InputStream inputStream = classLoader.getResourceAsStream(classFile);
                ZipEntry e = new ZipEntry(classFile);
                zipOutputStream.putNextEntry(e);
                byte[] buf = new byte[4096];
                while ((n = inputStream.read(buf)) > 0) {
                    zipOutputStream.write(buf, 0, n);
                }
                zipOutputStream.closeEntry();
            }
        }
        instrumentation.appendToBootstrapClassLoaderSearch(new JarFile(tempJarFile));
    }
}

