/*
 * Decompiled with CFR 0.152.
 */
package reactor.blockhound;

import java.lang.instrument.Instrumentation;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import reactor.blockhound.AllowancesByteBuddyTransformer;
import reactor.blockhound.BlockHoundRuntime;
import reactor.blockhound.BlockingCallsByteBuddyTransformer;
import reactor.blockhound.BlockingMethod;
import reactor.blockhound.InstrumentationUtils;
import reactor.blockhound.NativeWrappingClassFileTransformer;
import reactor.blockhound.integration.BlockHoundIntegration;
import reactor.shaded.net.bytebuddy.agent.ByteBuddyAgent;
import reactor.shaded.net.bytebuddy.agent.builder.AgentBuilder;
import reactor.shaded.net.bytebuddy.asm.Advice;
import reactor.shaded.net.bytebuddy.dynamic.ClassFileLocator;
import reactor.shaded.net.bytebuddy.matcher.ElementMatchers;
import reactor.shaded.net.bytebuddy.pool.TypePool;

public class BlockHound {
    static final String PREFIX = "$$BlockHound$$_";
    private static final AtomicBoolean INITIALIZED = new AtomicBoolean(false);

    public static Builder builder() {
        return new Builder();
    }

    public static void install(BlockHoundIntegration ... integrations) {
        Builder builder = BlockHound.builder();
        ServiceLoader<BlockHoundIntegration> serviceLoader = ServiceLoader.load(BlockHoundIntegration.class);
        Stream.concat(StreamSupport.stream(serviceLoader.spliterator(), false), Stream.of(integrations)).sorted().forEach(builder::with);
        builder.install();
    }

    public static class Builder {
        private final Map<String, Map<String, Set<String>>> blockingMethods = new HashMap<String, Map<String, Set<String>>>(){
            {
                this.put("java/lang/Thread", new HashMap<String, Set<String>>(){
                    {
                        this.put("sleep", Collections.singleton("(J)V"));
                        this.put("yield", Collections.singleton("()V"));
                        this.put("onSpinWait", Collections.singleton("()V"));
                    }
                });
                this.put("java/lang/Object", new HashMap<String, Set<String>>(){
                    {
                        this.put("wait", Collections.singleton("(J)V"));
                    }
                });
                this.put("java/io/RandomAccessFile", new HashMap<String, Set<String>>(){
                    {
                        this.put("read0", Collections.singleton("()I"));
                        this.put("readBytes", Collections.singleton("([BII)I"));
                        this.put("write0", Collections.singleton("(I)V"));
                        this.put("writeBytes", Collections.singleton("([BII)V"));
                    }
                });
                this.put("java/net/Socket", new HashMap<String, Set<String>>(){
                    {
                        this.put("connect", Collections.singleton("(Ljava/net/SocketAddress;)V"));
                    }
                });
                this.put("java/net/DatagramSocket", new HashMap<String, Set<String>>(){
                    {
                        this.put("connect", Collections.singleton("(Ljava/net/InetAddress;I)V"));
                    }
                });
                this.put("java/net/PlainDatagramSocketImpl", new HashMap<String, Set<String>>(){
                    {
                        this.put("connect0", Collections.singleton("(Ljava/net/InetAddress;I)V"));
                        this.put("peekData", Collections.singleton("(Ljava/net/DatagramPacket;)I"));
                        this.put("send", Collections.singleton("(Ljava/net/DatagramPacket;)V"));
                    }
                });
                this.put("java/net/PlainSocketImpl", new HashMap<String, Set<String>>(){
                    {
                        this.put("socketAccept", Collections.singleton("(Ljava/net/SocketImpl;)V"));
                    }
                });
                this.put("java/net/SocketInputStream", new HashMap<String, Set<String>>(){
                    {
                        this.put("socketRead0", Collections.singleton("(Ljava/io/FileDescriptor;[BIII)I"));
                    }
                });
                this.put("java/net/SocketOutputStream", new HashMap<String, Set<String>>(){
                    {
                        this.put("socketWrite0", Collections.singleton("(Ljava/io/FileDescriptor;[BII)V"));
                    }
                });
                this.put("java/io/FileInputStream", new HashMap<String, Set<String>>(){
                    {
                        this.put("read0", Collections.singleton("()I"));
                        this.put("readBytes", Collections.singleton("([BII)I"));
                    }
                });
                this.put("java/io/FileOutputStream", new HashMap<String, Set<String>>(){
                    {
                        this.put("write", Collections.singleton("(IZ)V"));
                        this.put("writeBytes", Collections.singleton("([BIIZ)V"));
                    }
                });
                try {
                    Class.forName("java.lang.StackWalker");
                    this.put("jdk/internal/misc/Unsafe", new HashMap<String, Set<String>>(){
                        {
                            this.put("park", Collections.singleton("(ZJ)V"));
                        }
                    });
                    this.put("java/lang/ProcessImpl", new HashMap<String, Set<String>>(){
                        {
                            this.put("forkAndExec", Collections.singleton("(I[B[B[BI[BI[B[IZ)I"));
                        }
                    });
                }
                catch (ClassNotFoundException __) {
                    this.put("sun/misc/Unsafe", new HashMap<String, Set<String>>(){
                        {
                            this.put("park", Collections.singleton("(ZJ)V"));
                        }
                    });
                    this.put("java/lang/UNIXProcess", new HashMap<String, Set<String>>(){
                        {
                            this.put("forkAndExec", Collections.singleton("(I[B[B[BI[BI[B[IZ)I"));
                        }
                    });
                }
            }
        };
        private final Map<String, Map<String, Boolean>> allowances = new HashMap<String, Map<String, Boolean>>(){
            {
                this.put(ClassLoader.class.getName(), new HashMap<String, Boolean>(){
                    {
                        this.put("loadClass", true);
                    }
                });
                this.put(Throwable.class.getName(), new HashMap<String, Boolean>(){
                    {
                        this.put("printStackTrace", true);
                    }
                });
                this.put(ConcurrentHashMap.class.getName(), new HashMap<String, Boolean>(){
                    {
                        this.put("initTable", true);
                    }
                });
                this.put(Advice.class.getName(), new HashMap<String, Boolean>(){
                    {
                        this.put("to", true);
                    }
                });
            }
        };
        private Consumer<BlockingMethod> onBlockingMethod = method -> {
            throw new Error(String.format("Blocking call! %s", method));
        };
        private Predicate<Thread> threadPredicate = t -> false;

        public Builder markAsBlocking(Class clazz, String methodName, String signature) {
            return this.markAsBlocking(clazz.getName(), methodName, signature);
        }

        public Builder markAsBlocking(String className, String methodName, String signature) {
            this.blockingMethods.computeIfAbsent(className.replace(".", "/"), __ -> new HashMap()).computeIfAbsent(methodName, __ -> new HashSet()).add(signature);
            return this;
        }

        public Builder allowBlockingCallsInside(String className, String methodName) {
            this.allowances.computeIfAbsent(className, __ -> new HashMap()).put(methodName, true);
            return this;
        }

        public Builder disallowBlockingCallsInside(String className, String methodName) {
            this.allowances.computeIfAbsent(className, __ -> new HashMap()).put(methodName, false);
            return this;
        }

        public Builder blockingMethodCallback(Consumer<BlockingMethod> consumer) {
            this.onBlockingMethod = consumer;
            return this;
        }

        public Builder nonBlockingThreadPredicate(Function<Predicate<Thread>, Predicate<Thread>> predicate) {
            this.threadPredicate = predicate.apply(this.threadPredicate);
            return this;
        }

        public Builder with(BlockHoundIntegration integration) {
            integration.applyTo(this);
            return this;
        }

        Builder() {
        }

        public void install() {
            try {
                if (!INITIALIZED.compareAndSet(false, true)) {
                    return;
                }
                Instrumentation instrumentation = ByteBuddyAgent.install();
                InstrumentationUtils.injectBootstrapClasses(instrumentation, NativeWrappingClassFileTransformer.BLOCK_HOUND_RUNTIME_TYPE.getInternalName());
                BlockHoundRuntime.blockingMethodConsumer = args -> {
                    String className = (String)args[0];
                    String methodName = (String)args[1];
                    int modifiers = (Integer)args[2];
                    this.onBlockingMethod.accept(new BlockingMethod(className, methodName, modifiers));
                };
                this.threadPredicate.test(Thread.currentThread());
                BlockHoundRuntime.threadPredicate = this.threadPredicate;
                this.instrument(instrumentation);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }

        private void instrument(Instrumentation instrumentation) {
            NativeWrappingClassFileTransformer transformer = new NativeWrappingClassFileTransformer(this.blockingMethods);
            instrumentation.addTransformer(transformer, true);
            instrumentation.setNativeMethodPrefix(transformer, BlockHound.PREFIX);
            new AgentBuilder.Default().with(AgentBuilder.RedefinitionStrategy.RETRANSFORMATION).with(new AgentBuilder.RedefinitionStrategy.DiscoveryStrategy.Explicit((Class[])Stream.of(instrumentation.getAllLoadedClasses()).filter(it -> it.getName() != null).filter(it -> {
                if (this.allowances.containsKey(it.getName())) {
                    return true;
                }
                String internalClassName = it.getName().replace(".", "/");
                return this.blockingMethods.containsKey(internalClassName);
            }).toArray(Class[]::new))).with(AgentBuilder.TypeStrategy.Default.DECORATE).with(AgentBuilder.InitializationStrategy.NoOp.INSTANCE).with(AgentBuilder.DescriptionStrategy.Default.POOL_FIRST).with((ClassFileLocator classFileLocator, ClassLoader classLoader) -> new TypePool.Default(new TypePool.CacheProvider.Simple(), classFileLocator, TypePool.Default.ReaderMode.FAST)).with(AgentBuilder.Listener.StreamWriting.toSystemError().withErrorsOnly()).ignore(ElementMatchers.none()).type(it -> this.blockingMethods.containsKey(it.getInternalName())).transform(new BlockingCallsByteBuddyTransformer(this.blockingMethods)).asTerminalTransformation().type(it -> this.allowances.containsKey(it.getName())).transform(new AllowancesByteBuddyTransformer(this.allowances)).asTerminalTransformation().installOn(instrumentation);
        }
    }
}

