/*
 * Decompiled with CFR 0.152.
 */
package reactor.spring.messaging;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.reactivestreams.Processor;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.SubscribableChannel;
import org.springframework.util.ObjectUtils;
import reactor.core.processor.RingBufferProcessor;
import reactor.fn.Consumer;
import reactor.rx.Streams;
import reactor.rx.action.Control;

public class ReactorSubscribableChannel
implements BeanNameAware,
MessageChannel,
SubscribableChannel {
    private final Map<MessageHandler, Control> messageHandlerConsumers = new ConcurrentHashMap<MessageHandler, Control>();
    private final Processor<Message<?>, Message<?>> processor;
    private String beanName = String.format("%s@%s", this.getClass().getSimpleName(), ObjectUtils.getIdentityHexString((Object)this));

    public ReactorSubscribableChannel() {
        this(false);
    }

    public ReactorSubscribableChannel(boolean singleThreadedProducer) {
        this.processor = singleThreadedProducer ? RingBufferProcessor.create() : RingBufferProcessor.share();
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public boolean subscribe(final MessageHandler handler) {
        Consumer consumer = new Consumer<Message<?>>(){

            public void accept(Message<?> ev) {
                handler.handleMessage(ev);
            }
        };
        Control c = Streams.wrap(this.processor).consume(consumer);
        this.messageHandlerConsumers.put(handler, c);
        return true;
    }

    public boolean unsubscribe(MessageHandler handler) {
        Control control = this.messageHandlerConsumers.remove(handler);
        if (null == control) {
            return false;
        }
        control.cancel();
        return true;
    }

    public boolean send(Message<?> message) {
        return this.send(message, 0L);
    }

    public boolean send(Message<?> message, long timeout) {
        this.processor.onNext(message);
        return true;
    }
}

