/*
 * Decompiled with CFR 0.152.
 */
package reactor.test.util;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.regex.Matcher;
import reactor.util.Logger;
import reactor.util.annotation.Nullable;

public class TestLogger
implements Logger {
    private final ByteArrayOutputStream errContent;
    private final ByteArrayOutputStream logContent = new ByteArrayOutputStream();
    private final PrintStream err;
    private final PrintStream log = new PrintStream(this.logContent);
    private final boolean logCurrentThreadName;

    public TestLogger() {
        this.errContent = new ByteArrayOutputStream();
        this.err = new PrintStream(this.errContent);
        this.logCurrentThreadName = true;
    }

    public TestLogger(boolean logCurrentThreadName) {
        this.errContent = new ByteArrayOutputStream();
        this.err = new PrintStream(this.errContent);
        this.logCurrentThreadName = logCurrentThreadName;
    }

    public String getName() {
        return "TestLogger";
    }

    public String getErrContent() {
        return this.errContent.toString();
    }

    public String getOutContent() {
        return this.logContent.toString();
    }

    public void reset() {
        this.errContent.reset();
        this.logContent.reset();
    }

    @Nullable
    private String format(@Nullable String from, Object ... arguments) {
        if (from != null) {
            String computed = from;
            if (arguments != null && arguments.length != 0) {
                for (Object argument : arguments) {
                    computed = computed.replaceFirst("\\{\\}", Matcher.quoteReplacement(argument.toString()));
                }
            }
            return computed;
        }
        return null;
    }

    public boolean isTraceEnabled() {
        return true;
    }

    public synchronized void trace(String msg) {
        this.log.format(this.logContent("TRACE", msg), new Object[0]);
    }

    public synchronized void trace(String format, Object ... arguments) {
        this.log.format(this.logContent("TRACE", this.format(format, arguments)), new Object[0]);
    }

    public synchronized void trace(String msg, Throwable t) {
        this.log.format(this.logContent("TRACE", String.format("%s - %s", msg, t)), new Object[0]);
        t.printStackTrace(this.err);
    }

    public boolean isDebugEnabled() {
        return true;
    }

    public synchronized void debug(String msg) {
        this.log.format(this.logContent("DEBUG", msg), new Object[0]);
    }

    public synchronized void debug(String format, Object ... arguments) {
        this.log.format(this.logContent("DEBUG", this.format(format, arguments)), new Object[0]);
    }

    public synchronized void debug(String msg, Throwable t) {
        this.log.format(this.logContent("DEBUG", String.format("%s - %s", msg, t)), new Object[0]);
        t.printStackTrace(this.err);
    }

    public boolean isInfoEnabled() {
        return true;
    }

    public synchronized void info(String msg) {
        this.log.format(this.logContent(" INFO", msg), new Object[0]);
    }

    public synchronized void info(String format, Object ... arguments) {
        this.log.format(this.logContent(" INFO", this.format(format, arguments)), new Object[0]);
    }

    public synchronized void info(String msg, Throwable t) {
        this.log.format(this.logContent(" INFO", String.format("%s - %s", msg, t)), new Object[0]);
        t.printStackTrace(this.err);
    }

    public boolean isWarnEnabled() {
        return true;
    }

    public synchronized void warn(String msg) {
        this.err.format(this.logContent(" WARN", msg), new Object[0]);
    }

    public synchronized void warn(String format, Object ... arguments) {
        this.err.format(this.logContent(" WARN", this.format(format, arguments)), new Object[0]);
    }

    public synchronized void warn(String msg, Throwable t) {
        this.err.format(this.logContent(" WARN", String.format("%s - %s", msg, t)), new Object[0]);
        t.printStackTrace(this.err);
    }

    public boolean isErrorEnabled() {
        return true;
    }

    public synchronized void error(String msg) {
        this.err.format(this.logContent("ERROR", msg), new Object[0]);
    }

    public synchronized void error(String format, Object ... arguments) {
        this.err.format(this.logContent("ERROR", this.format(format, arguments)), new Object[0]);
    }

    public synchronized void error(String msg, Throwable t) {
        this.err.format(this.logContent("ERROR", String.format("%s - %s", msg, t)), new Object[0]);
        t.printStackTrace(this.err);
    }

    String logContent(String logType, String msg) {
        if (this.logCurrentThreadName) {
            return String.format("[%s] (%s) %s\n", logType, Thread.currentThread().getName(), msg);
        }
        return String.format("[%s] %s\n", logType, msg);
    }

    public boolean isLogCurrentThreadName() {
        return this.logCurrentThreadName;
    }
}

