/*
 * Decompiled with CFR 0.152.
 */
package reactor.test;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Exceptions;
import reactor.core.Fuseable;
import reactor.core.Scannable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Hooks;
import reactor.core.publisher.Operators;
import reactor.core.publisher.Signal;
import reactor.test.StepVerifier;
import reactor.test.StepVerifierOptions;
import reactor.test.scheduler.VirtualTimeScheduler;
import reactor.util.Logger;
import reactor.util.Loggers;
import reactor.util.annotation.Nullable;
import reactor.util.context.Context;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuples;

final class DefaultStepVerifierBuilder<T>
implements StepVerifier.FirstStep<T> {
    static Duration defaultVerifyTimeout = StepVerifier.DEFAULT_VERIFY_TIMEOUT;
    final List<Event<T>> script;
    final long initialRequest;
    final Supplier<? extends VirtualTimeScheduler> vtsLookup;
    final Supplier<? extends Publisher<? extends T>> sourceSupplier;
    private final StepVerifierOptions options;
    long hangCheckRequested;
    int requestedFusionMode = -1;
    int expectedFusionMode = -1;
    static final SignalEvent DEFAULT_ONSUBSCRIBE_STEP = DefaultStepVerifierBuilder.newOnSubscribeStep("defaultOnSubscribe");
    static final AtomicReferenceFieldUpdater<DefaultVerifySubscriber, Throwable> ERRORS = AtomicReferenceFieldUpdater.newUpdater(DefaultVerifySubscriber.class, Throwable.class, "errors");
    static final AtomicIntegerFieldUpdater<DefaultVerifySubscriber> WIP = AtomicIntegerFieldUpdater.newUpdater(DefaultVerifySubscriber.class, "wip");
    static final Optional<AssertionError> EXPECT_MORE = Optional.of(new AssertionError((Object)"EXPECT MORE"));

    static void checkPositive(long n) {
        if (n < 0L) {
            throw new IllegalArgumentException("'n' should be >= 0 but was " + n);
        }
    }

    static void checkStrictlyPositive(long n) {
        if (n <= 0L) {
            throw new IllegalArgumentException("'n' should be > 0 but was " + n);
        }
    }

    static <T> StepVerifier.FirstStep<T> newVerifier(StepVerifierOptions options, Supplier<? extends Publisher<? extends T>> scenarioSupplier) {
        DefaultStepVerifierBuilder.checkPositive(options.getInitialRequest());
        Objects.requireNonNull(scenarioSupplier, "scenarioSupplier");
        return new DefaultStepVerifierBuilder<T>(options, scenarioSupplier);
    }

    static <T> SignalEvent<T> defaultFirstStep() {
        return DEFAULT_ONSUBSCRIBE_STEP;
    }

    DefaultStepVerifierBuilder(StepVerifierOptions options, @Nullable Supplier<? extends Publisher<? extends T>> sourceSupplier) {
        this.initialRequest = options.getInitialRequest();
        this.options = options;
        this.vtsLookup = options.getVirtualTimeSchedulerSupplier();
        this.sourceSupplier = sourceSupplier;
        this.script = new ArrayList<Event<T>>();
        this.script.add(DefaultStepVerifierBuilder.defaultFirstStep());
        this.hangCheckRequested = this.initialRequest;
    }

    @Override
    public DefaultStepVerifierBuilder<T> as(String description) {
        this.script.add(new DescriptionEvent(description));
        return this;
    }

    @Override
    public DefaultStepVerifier<T> consumeErrorWith(Consumer<Throwable> consumer) {
        Objects.requireNonNull(consumer, "consumer");
        return this.consumeErrorWith(consumer, "consumeErrorWith", false);
    }

    private DefaultStepVerifier<T> consumeErrorWith(Consumer<Throwable> assertionConsumer, String description, boolean wrap) {
        Objects.requireNonNull(assertionConsumer, "assertionConsumer");
        SignalEvent event = new SignalEvent((signal, se) -> {
            if (!signal.isOnError()) {
                return DefaultStepVerifierBuilder.fail(se, "expected: onError(); actual: %s", signal);
            }
            try {
                assertionConsumer.accept(signal.getThrowable());
                return Optional.empty();
            }
            catch (AssertionError e) {
                if (wrap) {
                    return DefaultStepVerifierBuilder.fail(se, "assertion failed on exception <%s>: %s", signal.getThrowable(), ((Throwable)((Object)e)).getMessage());
                }
                throw e;
            }
        }, description);
        this.script.add(event);
        return this.build();
    }

    @Override
    public DefaultStepVerifierBuilder<T> assertNext(Consumer<? super T> consumer) {
        return this.consumeNextWith(consumer, "assertNext");
    }

    @Override
    public DefaultStepVerifierBuilder<T> consumeNextWith(Consumer<? super T> consumer) {
        return this.consumeNextWith(consumer, "consumeNextWith");
    }

    private DefaultStepVerifierBuilder<T> consumeNextWith(Consumer<? super T> consumer, String description) {
        Objects.requireNonNull(consumer, "consumer");
        this.checkPotentialHang(1L, description);
        SignalEvent event = new SignalEvent((signal, se) -> {
            if (!signal.isOnNext()) {
                return DefaultStepVerifierBuilder.fail(se, "expected: onNext(); actual: %s", signal);
            }
            consumer.accept(signal.get());
            return Optional.empty();
        }, description);
        this.script.add(event);
        return this;
    }

    @Override
    public DefaultStepVerifierBuilder<T> consumeRecordedWith(Consumer<? super Collection<T>> consumer) {
        Objects.requireNonNull(consumer, "consumer");
        this.script.add(new CollectEvent(consumer, "consumeRecordedWith"));
        return this;
    }

    @Override
    public DefaultStepVerifierBuilder<T> consumeSubscriptionWith(Consumer<? super Subscription> consumer) {
        Objects.requireNonNull(consumer, "consumer");
        if (this.script.isEmpty() || this.script.size() == 1 && this.script.get(0) == DEFAULT_ONSUBSCRIBE_STEP) {
            this.script.set(0, new SignalEvent((signal, se) -> {
                if (!signal.isOnSubscribe()) {
                    return DefaultStepVerifierBuilder.fail(se, "expected: onSubscribe(); actual: %s", signal);
                }
                consumer.accept(signal.getSubscription());
                return Optional.empty();
            }, "consumeSubscriptionWith"));
        } else {
            this.script.add(new SubscriptionConsumerEvent(consumer, "consumeSubscriptionWith"));
        }
        return this;
    }

    @Override
    public StepVerifier.ContextExpectations<T> expectAccessibleContext() {
        return new DefaultContextExpectations(this);
    }

    @Override
    public DefaultStepVerifierBuilder<T> expectNoAccessibleContext() {
        return this.consumeSubscriptionWith((T sub) -> {
            Scannable lowest = Scannable.from((Object)sub);
            Scannable verifierSubscriber = Scannable.from((Object)lowest.scan(Scannable.Attr.ACTUAL));
            Context c = (Context)Flux.fromStream((Stream)verifierSubscriber.parents()).ofType(CoreSubscriber.class).map(CoreSubscriber::currentContext).blockLast();
            if (c != null) {
                throw new AssertionError((Object)("Expected no accessible Context, got " + c));
            }
        });
    }

    @Override
    public DefaultStepVerifier<T> expectComplete() {
        SignalEvent event = new SignalEvent((signal, se) -> {
            if (!signal.isOnComplete()) {
                return DefaultStepVerifierBuilder.fail(se, "expected: onComplete(); actual: %s", signal);
            }
            return Optional.empty();
        }, "expectComplete");
        this.script.add(event);
        return this.build();
    }

    @Override
    public DefaultStepVerifier<T> expectError() {
        SignalEvent event = new SignalEvent((signal, se) -> {
            if (!signal.isOnError()) {
                return DefaultStepVerifierBuilder.fail(se, "expected: onError(); actual: %s", signal);
            }
            return Optional.empty();
        }, "expectError()");
        this.script.add(event);
        return this.build();
    }

    @Override
    public DefaultStepVerifier<T> expectError(Class<? extends Throwable> clazz) {
        Objects.requireNonNull(clazz, "clazz");
        SignalEvent event = new SignalEvent((signal, se) -> {
            if (!signal.isOnError()) {
                return DefaultStepVerifierBuilder.fail(se, "expected: onError(%s); actual: %s", clazz.getSimpleName(), signal);
            }
            if (!clazz.isInstance(signal.getThrowable())) {
                return DefaultStepVerifierBuilder.fail(se, "expected error of type: %s; actual type: %s", clazz.getSimpleName(), signal.getThrowable());
            }
            return Optional.empty();
        }, "expectError(Class)");
        this.script.add(event);
        return this.build();
    }

    @Override
    public DefaultStepVerifier<T> expectErrorMessage(String errorMessage) {
        SignalEvent event = new SignalEvent((signal, se) -> {
            if (!signal.isOnError()) {
                return DefaultStepVerifierBuilder.fail(se, "expected: onError(\"%s\"); actual: %s", errorMessage, signal);
            }
            if (!Objects.equals(errorMessage, signal.getThrowable().getMessage())) {
                return DefaultStepVerifierBuilder.fail(se, "expected error message: \"%s\"; actual message: %s", errorMessage, signal.getThrowable().getMessage());
            }
            return Optional.empty();
        }, "expectErrorMessage");
        this.script.add(event);
        return this.build();
    }

    @Override
    public DefaultStepVerifier<T> expectErrorMatches(Predicate<Throwable> predicate) {
        Objects.requireNonNull(predicate, "predicate");
        SignalEvent event = new SignalEvent((signal, se) -> {
            if (!signal.isOnError()) {
                return DefaultStepVerifierBuilder.fail(se, "expected: onError(); actual: %s", signal);
            }
            if (!predicate.test(signal.getThrowable())) {
                return DefaultStepVerifierBuilder.fail(se, "predicate failed on exception: %s", signal.getThrowable());
            }
            return Optional.empty();
        }, "expectErrorMatches");
        this.script.add(event);
        return this.build();
    }

    @Override
    public DefaultStepVerifier<T> expectErrorSatisfies(Consumer<Throwable> assertionConsumer) {
        return this.consumeErrorWith(assertionConsumer, "expectErrorSatisfies", true);
    }

    @Override
    public DefaultStepVerifierBuilder<T> expectNoFusionSupport() {
        return this.expectFusion(3, 0);
    }

    @Override
    public DefaultStepVerifierBuilder<T> expectFusion() {
        return this.expectFusion(3, 3);
    }

    @Override
    public DefaultStepVerifierBuilder<T> expectFusion(int requested) {
        return this.expectFusion(requested, requested);
    }

    @Override
    public DefaultStepVerifierBuilder<T> expectFusion(int requested, int expected) {
        DefaultStepVerifierBuilder.checkPositive(requested);
        DefaultStepVerifierBuilder.checkPositive(expected);
        this.requestedFusionMode = requested;
        this.expectedFusionMode = expected;
        return this;
    }

    @Override
    public final DefaultStepVerifierBuilder<T> expectNext(T t) {
        return this.addExpectedValues(new Object[]{t});
    }

    @Override
    public final DefaultStepVerifierBuilder<T> expectNext(T t1, T t2) {
        return this.addExpectedValues(new Object[]{t1, t2});
    }

    @Override
    public final DefaultStepVerifierBuilder<T> expectNext(T t1, T t2, T t3) {
        return this.addExpectedValues(new Object[]{t1, t2, t3});
    }

    @Override
    public final DefaultStepVerifierBuilder<T> expectNext(T t1, T t2, T t3, T t4) {
        return this.addExpectedValues(new Object[]{t1, t2, t3, t4});
    }

    @Override
    public final DefaultStepVerifierBuilder<T> expectNext(T t1, T t2, T t3, T t4, T t5) {
        return this.addExpectedValues(new Object[]{t1, t2, t3, t4, t5});
    }

    @Override
    public final DefaultStepVerifierBuilder<T> expectNext(T t1, T t2, T t3, T t4, T t5, T t6) {
        return this.addExpectedValues(new Object[]{t1, t2, t3, t4, t5, t6});
    }

    @Override
    @SafeVarargs
    public final DefaultStepVerifierBuilder<T> expectNext(T ... ts) {
        Objects.requireNonNull(ts, "ts");
        Arrays.stream(ts).forEach(this::addExpectedValue);
        return this;
    }

    private DefaultStepVerifierBuilder<T> addExpectedValues(Object[] values) {
        Arrays.stream(values).map(val -> val).forEach(this::addExpectedValue);
        return this;
    }

    private void addExpectedValue(T value) {
        String desc = String.format("expectNext(%s)", value);
        this.checkPotentialHang(1L, desc);
        SignalEvent event = new SignalEvent((signal, se) -> {
            if (!signal.isOnNext()) {
                return DefaultStepVerifierBuilder.fail(se, "expected: onNext(%s); actual: %s", value, signal);
            }
            if (!Objects.equals(value, signal.get())) {
                return DefaultStepVerifierBuilder.fail(se, "expected value: %s; actual value: %s", value, signal.get());
            }
            return Optional.empty();
        }, desc);
        this.script.add(event);
    }

    @Override
    public DefaultStepVerifierBuilder<T> expectNextSequence(Iterable<? extends T> iterable) {
        Objects.requireNonNull(iterable, "iterable");
        if (iterable.iterator().hasNext()) {
            if (iterable instanceof Collection) {
                this.checkPotentialHang(((Collection)iterable).size(), "expectNextSequence");
            } else {
                this.checkPotentialHang(-1L, "expectNextSequence");
            }
            this.script.add(new SignalSequenceEvent<T>(iterable, "expectNextSequence"));
        }
        return this;
    }

    @Override
    public DefaultStepVerifierBuilder<T> expectNextCount(long count) {
        DefaultStepVerifierBuilder.checkPositive(count);
        if (count != 0L) {
            String desc = "expectNextCount(" + count + ")";
            this.checkPotentialHang(count, desc);
            this.script.add(new SignalCountEvent(count, desc));
        }
        return this;
    }

    @Override
    public DefaultStepVerifierBuilder<T> expectNextMatches(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate");
        this.checkPotentialHang(1L, "expectNextMatches");
        SignalEvent event = new SignalEvent((signal, se) -> {
            if (!signal.isOnNext()) {
                return DefaultStepVerifierBuilder.fail(se, "expected: onNext(); actual: %s", signal);
            }
            if (!predicate.test(signal.get())) {
                return DefaultStepVerifierBuilder.fail(se, "predicate failed on value: %s", signal.get());
            }
            return Optional.empty();
        }, "expectNextMatches");
        this.script.add(event);
        return this;
    }

    @Override
    public DefaultStepVerifierBuilder<T> expectRecordedMatches(Predicate<? super Collection<T>> predicate) {
        Objects.requireNonNull(predicate, "predicate");
        this.script.add(new CollectEvent(predicate, "expectRecordedMatches"));
        return this;
    }

    @Override
    public DefaultStepVerifierBuilder<T> expectSubscription() {
        if (this.script.get(0) instanceof NoEvent) {
            this.script.add(DefaultStepVerifierBuilder.defaultFirstStep());
        } else {
            this.script.set(0, DefaultStepVerifierBuilder.newOnSubscribeStep("expectSubscription"));
        }
        return this;
    }

    @Override
    public DefaultStepVerifierBuilder<T> expectSubscriptionMatches(Predicate<? super Subscription> predicate) {
        Objects.requireNonNull(predicate, "predicate");
        this.script.set(0, new SignalEvent((signal, se) -> {
            if (!signal.isOnSubscribe()) {
                return DefaultStepVerifierBuilder.fail(se, "expected: onSubscribe(); actual: %s", signal);
            }
            if (!predicate.test(signal.getSubscription())) {
                return DefaultStepVerifierBuilder.fail(se, "predicate failed on subscription: %s", signal.getSubscription());
            }
            return Optional.empty();
        }, "expectSubscriptionMatches"));
        return this;
    }

    @Override
    public DefaultStepVerifierBuilder<T> expectNoEvent(Duration duration) {
        Objects.requireNonNull(duration, "duration");
        if (this.script.size() == 1 && this.script.get(0) == DefaultStepVerifierBuilder.defaultFirstStep()) {
            this.script.set(0, new NoEvent(duration, "expectNoEvent"));
        } else {
            this.script.add(new NoEvent(duration, "expectNoEvent"));
        }
        return this;
    }

    @Override
    public DefaultStepVerifierBuilder<T> recordWith(Supplier<? extends Collection<T>> supplier) {
        Objects.requireNonNull(supplier, "supplier");
        this.script.add(new CollectEvent(supplier, "recordWith"));
        return this;
    }

    @Override
    public DefaultStepVerifierBuilder<T> then(Runnable task) {
        Objects.requireNonNull(task, "task");
        this.script.add(new TaskEvent(task, "then"));
        return this;
    }

    @Override
    public DefaultStepVerifier<T> thenCancel() {
        this.script.add(new SubscriptionEvent("thenCancel"));
        return this.build();
    }

    @Override
    public Duration verifyError() {
        return ((DefaultStepVerifier)this.expectError()).verify();
    }

    @Override
    public Duration verifyError(Class<? extends Throwable> clazz) {
        return ((DefaultStepVerifier)this.expectError((Class)clazz)).verify();
    }

    @Override
    public Duration verifyErrorMessage(String errorMessage) {
        return ((DefaultStepVerifier)this.expectErrorMessage(errorMessage)).verify();
    }

    @Override
    public Duration verifyErrorMatches(Predicate<Throwable> predicate) {
        return ((DefaultStepVerifier)this.expectErrorMatches((Predicate)predicate)).verify();
    }

    @Override
    public Duration verifyErrorSatisfies(Consumer<Throwable> assertionConsumer) {
        return this.consumeErrorWith(assertionConsumer, "verifyErrorSatisfies", true).verify();
    }

    @Override
    public Duration verifyComplete() {
        return ((DefaultStepVerifier)this.expectComplete()).verify();
    }

    @Override
    public DefaultStepVerifierBuilder<T> thenRequest(long n) {
        DefaultStepVerifierBuilder.checkStrictlyPositive(n);
        this.script.add(new RequestEvent(n, "thenRequest"));
        this.hangCheckRequested = Operators.addCap((long)this.hangCheckRequested, (long)n);
        return this;
    }

    @Override
    public DefaultStepVerifierBuilder<T> thenAwait() {
        return this.thenAwait(Duration.ZERO);
    }

    @Override
    public DefaultStepVerifierBuilder<T> thenAwait(Duration timeshift) {
        Objects.requireNonNull(timeshift, "timeshift");
        this.script.add(new WaitEvent(timeshift, "thenAwait"));
        return this;
    }

    @Override
    public DefaultStepVerifierBuilder<T> thenConsumeWhile(Predicate<T> predicate) {
        return this.thenConsumeWhile((Predicate)predicate, t -> {});
    }

    @Override
    public DefaultStepVerifierBuilder<T> thenConsumeWhile(Predicate<T> predicate, Consumer<T> consumer) {
        Objects.requireNonNull(predicate, "predicate");
        this.checkPotentialHang(-1L, "thenConsumeWhile");
        this.script.add(new SignalConsumeWhileEvent<T>(predicate, consumer, "thenConsumeWhile"));
        return this;
    }

    private void checkPotentialHang(long expectedAmount, String stepDescription) {
        if (!this.options.isCheckUnderRequesting()) {
            return;
        }
        boolean bestEffort = false;
        if (expectedAmount == -1L) {
            bestEffort = true;
            expectedAmount = 1L;
        }
        if (this.hangCheckRequested < expectedAmount) {
            StringBuilder message = new StringBuilder().append("The scenario will hang at ").append(stepDescription).append(" due to too little request being performed for the expectations to finish; ").append("request remaining since last step: ").append(this.hangCheckRequested).append(", expected: ");
            if (bestEffort) {
                message.append("at least ").append(expectedAmount).append(" (best effort estimation)");
            } else {
                message.append(expectedAmount);
            }
            throw new IllegalArgumentException(message.toString());
        }
        this.hangCheckRequested -= expectedAmount;
    }

    final DefaultStepVerifier<T> build() {
        return new DefaultStepVerifier(this);
    }

    static void virtualOrRealWait(Duration duration, DefaultVerifySubscriber<?> s) throws Exception {
        if (s.virtualTimeScheduler == null) {
            s.completeLatch.await(duration.toMillis(), TimeUnit.MILLISECONDS);
        } else {
            s.virtualTimeScheduler.advanceTimeBy(duration);
        }
    }

    static Optional<AssertionError> fail(@Nullable Event<?> event, String msg, Object ... args) {
        String prefix = "expectation failed (";
        if (event != null && event.getDescription().length() > 0) {
            prefix = String.format("expectation \"%s\" failed (", event.getDescription());
        }
        return DefaultStepVerifierBuilder.failPrefix(prefix, msg, args);
    }

    static Optional<AssertionError> failPrefix(String prefix, String msg, Object ... args) {
        return Optional.of(new AssertionError((Object)(prefix + String.format(msg, args) + ")")));
    }

    static String formatFusionMode(int m) {
        switch (m) {
            case 3: {
                return "(any)";
            }
            case 1: {
                return "(sync)";
            }
            case 2: {
                return "(async)";
            }
            case 0: {
                return "none";
            }
            case 4: {
                return "(thread-barrier)";
            }
        }
        return "" + m;
    }

    static <T> SignalEvent<T> newOnSubscribeStep(String desc) {
        return new SignalEvent((signal, se) -> {
            if (!signal.isOnSubscribe()) {
                return DefaultStepVerifierBuilder.fail(se, "expected: onSubscribe(); actual: %s", signal);
            }
            return Optional.empty();
        }, desc);
    }

    static final class DefaultContextExpectations<T>
    implements StepVerifier.ContextExpectations<T> {
        private final StepVerifier.Step<T> step;
        private Consumer<Context> contextExpectations;

        DefaultContextExpectations(StepVerifier.Step<T> step) {
            this.step = step;
            this.contextExpectations = c -> {
                if (c == null) {
                    throw new AssertionError((Object)"No propagated Context");
                }
            };
        }

        @Override
        public StepVerifier.Step<T> then() {
            return this.step.consumeSubscriptionWith(s -> {
                Scannable lowest = Scannable.from((Object)s);
                Scannable verifierSubscriber = Scannable.from((Object)lowest.scan(Scannable.Attr.ACTUAL));
                Context c = (Context)Flux.fromStream((Stream)verifierSubscriber.parents()).ofType(CoreSubscriber.class).map(CoreSubscriber::currentContext).blockLast();
                this.contextExpectations.accept(c);
            });
        }

        @Override
        public StepVerifier.ContextExpectations<T> hasKey(Object key) {
            this.contextExpectations = this.contextExpectations.andThen(c -> {
                if (!c.hasKey(key)) {
                    throw new AssertionError((Object)String.format("Key %s not found in Context %s", key, c));
                }
            });
            return this;
        }

        @Override
        public StepVerifier.ContextExpectations<T> hasSize(int size) {
            this.contextExpectations = this.contextExpectations.andThen(c -> {
                long realSize = c.stream().count();
                if (realSize != (long)size) {
                    throw new AssertionError((Object)String.format("Expected Context of size %d, got %d for Context %s", size, realSize, c));
                }
            });
            return this;
        }

        @Override
        public StepVerifier.ContextExpectations<T> contains(Object key, Object value) {
            this.contextExpectations = this.contextExpectations.andThen(c -> {
                Object realValue = c.getOrDefault(key, null);
                if (realValue == null) {
                    throw new AssertionError((Object)String.format("Expected value %s for key %s, key not present in Context %s", value, key, c));
                }
                if (!value.equals(realValue)) {
                    throw new AssertionError((Object)String.format("Expected value %s for key %s, got %s in Context %s", value, key, realValue, c));
                }
            });
            return this;
        }

        @Override
        public StepVerifier.ContextExpectations<T> containsAllOf(Context other) {
            this.contextExpectations = this.contextExpectations.andThen(c -> {
                boolean all = other.stream().allMatch(e -> e.getValue().equals(c.getOrDefault(e.getKey(), null)));
                if (!all) {
                    throw new AssertionError((Object)String.format("Expected Context %s to contain all of %s", c, other));
                }
            });
            return this;
        }

        @Override
        public StepVerifier.ContextExpectations<T> containsAllOf(Map<?, ?> other) {
            this.contextExpectations = this.contextExpectations.andThen(c -> {
                boolean all = other.entrySet().stream().allMatch(e -> e.getValue().equals(c.getOrDefault(e.getKey(), null)));
                if (!all) {
                    throw new AssertionError((Object)String.format("Expected Context %s to contain all of %s", c, other));
                }
            });
            return this;
        }

        @Override
        public StepVerifier.ContextExpectations<T> containsOnly(Context other) {
            this.contextExpectations = this.contextExpectations.andThen(c -> {
                if (c.stream().count() != other.stream().count()) {
                    throw new AssertionError((Object)String.format("Expected Context %s to contain same values as %s, but they differ in size", c, other));
                }
                boolean all = other.stream().allMatch(e -> e.getValue().equals(c.getOrDefault(e.getKey(), null)));
                if (!all) {
                    throw new AssertionError((Object)String.format("Expected Context %s to contain same values as %s, but they differ in content", c, other));
                }
            });
            return this;
        }

        @Override
        public StepVerifier.ContextExpectations<T> containsOnly(Map<?, ?> other) {
            this.contextExpectations = this.contextExpectations.andThen(c -> {
                if (c.stream().count() != (long)other.size()) {
                    throw new AssertionError((Object)String.format("Expected Context %s to contain same values as %s, but they differ in size", c, other));
                }
                boolean all = other.entrySet().stream().allMatch(e -> e.getValue().equals(c.getOrDefault(e.getKey(), null)));
                if (!all) {
                    throw new AssertionError((Object)String.format("Expected Context %s to contain same values as %s, but they differ in content", c, other));
                }
            });
            return this;
        }

        @Override
        public StepVerifier.ContextExpectations<T> assertThat(Consumer<Context> assertingConsumer) {
            this.contextExpectations = this.contextExpectations.andThen(assertingConsumer);
            return this;
        }

        @Override
        public StepVerifier.ContextExpectations<T> matches(Predicate<Context> predicate) {
            this.contextExpectations = this.contextExpectations.andThen(c -> {
                if (!predicate.test((Context)c)) {
                    throw new AssertionError((Object)String.format("Context %s doesn't match predicate", c));
                }
            });
            return this;
        }

        @Override
        public StepVerifier.ContextExpectations<T> matches(Predicate<Context> predicate, String description) {
            this.contextExpectations = this.contextExpectations.andThen(c -> {
                if (!predicate.test((Context)c)) {
                    throw new AssertionError((Object)String.format("Context %s doesn't match predicate %s", c, description));
                }
            });
            return this;
        }
    }

    static final class DescriptionEvent<T>
    implements Event<T> {
        final String description;

        public DescriptionEvent(String description) {
            this.description = description;
        }

        @Override
        public boolean setDescription(String description) {
            return false;
        }

        @Override
        public String getDescription() {
            return this.description;
        }
    }

    static final class SignalConsumeWhileEvent<T>
    extends AbstractSignalEvent<T> {
        private final Predicate<T> predicate;
        private final Consumer<T> consumer;

        SignalConsumeWhileEvent(Predicate<T> predicate, Consumer<T> consumer, String desc) {
            super(desc);
            this.predicate = predicate;
            this.consumer = consumer;
        }

        boolean test(T actual) {
            if (this.predicate.test(actual)) {
                this.consumer.accept(actual);
                return true;
            }
            return false;
        }
    }

    static final class SignalSequenceEvent<T>
    extends AbstractSignalEvent<T> {
        final Iterable<? extends T> iterable;

        SignalSequenceEvent(Iterable<? extends T> iterable, String desc) {
            super(desc);
            this.iterable = iterable;
        }

        Optional<AssertionError> test(Signal<T> signal, Iterator<? extends T> iterator) {
            if (signal.isOnNext()) {
                if (!iterator.hasNext()) {
                    return Optional.empty();
                }
                T d2 = iterator.next();
                if (!Objects.equals(signal.get(), d2)) {
                    return DefaultStepVerifierBuilder.fail(this, "expected : onNext(%s); actual: %s; iterable: %s", d2, signal.get(), this.iterable);
                }
                return iterator.hasNext() ? EXPECT_MORE : Optional.empty();
            }
            if (iterator.hasNext() || signal.isOnError()) {
                return DefaultStepVerifierBuilder.fail(this, "expected next value: %s; actual signal: %s; iterable: %s", iterator.hasNext() ? iterator.next() : "none", signal, this.iterable);
            }
            return Optional.empty();
        }
    }

    static final class SubscriptionTaskEvent<T>
    extends TaskEvent<T> {
        final SubscriptionEvent<T> delegate;

        SubscriptionTaskEvent(SubscriptionEvent<T> subscriptionEvent) {
            super(null, subscriptionEvent.getDescription());
            this.delegate = subscriptionEvent;
        }

        @Override
        void run(DefaultVerifySubscriber<T> parent) throws Exception {
            if (this.delegate.isTerminal()) {
                parent.doCancel();
            } else {
                this.delegate.consume((Subscription)parent.get());
            }
        }
    }

    static final class WaitEvent<T>
    extends TaskEvent<T> {
        final Duration duration;

        WaitEvent(Duration duration, String desc) {
            super(null, desc);
            this.duration = duration;
        }

        @Override
        void run(DefaultVerifySubscriber<T> s) throws Exception {
            DefaultStepVerifierBuilder.virtualOrRealWait(this.duration, s);
        }
    }

    static final class NoEvent<T>
    extends TaskEvent<T> {
        final Duration duration;

        NoEvent(Duration duration, String desc) {
            super(null, desc);
            this.duration = duration;
        }

        @Override
        void run(DefaultVerifySubscriber<T> parent) throws Exception {
            if (parent.virtualTimeScheduler != null) {
                parent.monitorSignal = true;
                DefaultStepVerifierBuilder.virtualOrRealWait(this.duration.minus(Duration.ofNanos(1L)), parent);
                parent.monitorSignal = false;
                if (parent.isTerminated() && !parent.isCancelled()) {
                    throw new AssertionError((Object)"unexpected end during a no-event expectation");
                }
                DefaultStepVerifierBuilder.virtualOrRealWait(Duration.ofNanos(1L), parent);
            } else {
                parent.monitorSignal = true;
                DefaultStepVerifierBuilder.virtualOrRealWait(this.duration, parent);
                parent.monitorSignal = false;
                if (parent.isTerminated() && !parent.isCancelled()) {
                    throw new AssertionError((Object)"unexpected end during a no-event expectation");
                }
            }
        }
    }

    static final class SubscriptionConsumerEvent<T>
    extends TaskEvent<T> {
        final Consumer<? super Subscription> task;

        SubscriptionConsumerEvent(Consumer<? super Subscription> task, String desc) {
            super(null, desc);
            this.task = task;
        }

        @Override
        void run(DefaultVerifySubscriber<T> parent) throws Exception {
            this.task.accept((Subscription)parent.get());
        }
    }

    static class TaskEvent<T>
    extends AbstractEagerEvent<T> {
        final Runnable task;

        TaskEvent(@Nullable Runnable task, String desc) {
            super(desc);
            this.task = task;
        }

        void run(DefaultVerifySubscriber<T> parent) throws Exception {
            if (this.task != null) {
                this.task.run();
            }
        }
    }

    static final class CollectEvent<T>
    extends AbstractEagerEvent<T> {
        final Supplier<? extends Collection<T>> supplier;
        final Predicate<? super Collection<T>> predicate;
        final Consumer<? super Collection<T>> consumer;

        CollectEvent(Supplier<? extends Collection<T>> supplier, String desc) {
            super(desc);
            this.supplier = supplier;
            this.predicate = null;
            this.consumer = null;
        }

        CollectEvent(Consumer<? super Collection<T>> consumer, String desc) {
            super(desc);
            this.supplier = null;
            this.predicate = null;
            this.consumer = consumer;
        }

        CollectEvent(Predicate<? super Collection<T>> predicate, String desc) {
            super(desc);
            this.supplier = null;
            this.predicate = predicate;
            this.consumer = null;
        }

        @Nullable
        Collection<T> get() {
            return this.supplier != null ? this.supplier.get() : null;
        }

        Optional<AssertionError> test(Collection<T> collection) {
            if (this.predicate != null) {
                if (!this.predicate.test(collection)) {
                    return DefaultStepVerifierBuilder.fail(this, "expected collection predicate match; actual: %s", collection);
                }
                return Optional.empty();
            }
            if (this.consumer != null) {
                this.consumer.accept(collection);
            }
            return Optional.empty();
        }
    }

    static final class SignalCountEvent<T>
    extends AbstractSignalEvent<T> {
        final long count;

        SignalCountEvent(long count, String desc) {
            super(desc);
            this.count = count;
        }
    }

    static final class SignalEvent<T>
    extends AbstractSignalEvent<T> {
        final BiFunction<Signal<T>, SignalEvent<T>, Optional<AssertionError>> function;

        SignalEvent(BiFunction<Signal<T>, SignalEvent<T>, Optional<AssertionError>> function, String desc) {
            super(desc);
            this.function = function;
        }

        Optional<AssertionError> test(Signal<T> signal) {
            return this.function.apply(signal, this);
        }
    }

    static abstract class AbstractSignalEvent<T>
    implements Event<T> {
        String description;

        public AbstractSignalEvent(String description) {
            this.description = description;
        }

        @Override
        public boolean setDescription(String description) {
            this.description = description;
            return true;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        public String toString() {
            return this.description + "_" + this.getClass().getSimpleName();
        }
    }

    static final class RequestEvent<T>
    extends SubscriptionEvent<T> {
        final long requestAmount;

        RequestEvent(long n, String desc) {
            super(s -> s.request(n), desc);
            this.requestAmount = n;
        }

        public long getRequestAmount() {
            return this.requestAmount;
        }

        public boolean isBounded() {
            return this.requestAmount >= 0L && this.requestAmount < Long.MAX_VALUE;
        }
    }

    static class SubscriptionEvent<T>
    extends AbstractEagerEvent<T> {
        final Consumer<Subscription> consumer;

        SubscriptionEvent(String desc) {
            this(null, desc);
        }

        SubscriptionEvent(@Nullable Consumer<Subscription> consumer, String desc) {
            super(desc);
            this.consumer = consumer;
        }

        void consume(Subscription subscription) {
            if (this.consumer != null) {
                this.consumer.accept(subscription);
            }
        }

        boolean isTerminal() {
            return this.consumer == null;
        }
    }

    static abstract class AbstractEagerEvent<T>
    implements EagerEvent<T> {
        String description = "";

        public AbstractEagerEvent(String description) {
            this.description = description;
        }

        @Override
        public boolean setDescription(String description) {
            this.description = description;
            return true;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        public String toString() {
            return this.description + "_" + this.getClass().getSimpleName();
        }
    }

    static interface EagerEvent<T>
    extends Event<T> {
    }

    static class DefaultStepVerifierAssertions
    implements StepVerifier.Assertions {
        private final Queue<Object> droppedElements;
        private final Queue<Throwable> droppedErrors;
        private final Queue<Tuple2<Optional<Throwable>, Optional<?>>> operatorErrors;
        private final Duration duration;

        DefaultStepVerifierAssertions(Queue<Object> droppedElements, Queue<Throwable> droppedErrors, Queue<Tuple2<Optional<Throwable>, Optional<?>>> operatorErrors, Duration duration) {
            this.droppedElements = droppedElements;
            this.droppedErrors = droppedErrors;
            this.operatorErrors = operatorErrors;
            this.duration = duration;
        }

        private StepVerifier.Assertions satisfies(BooleanSupplier check, Supplier<String> message) {
            if (!check.getAsBoolean()) {
                throw new AssertionError((Object)message.get());
            }
            return this;
        }

        @Override
        public StepVerifier.Assertions hasDroppedElements() {
            return this.satisfies(() -> !this.droppedElements.isEmpty(), () -> "Expected dropped elements, none found.");
        }

        @Override
        public StepVerifier.Assertions hasNotDroppedElements() {
            return this.satisfies(this.droppedElements::isEmpty, () -> String.format("Expected no dropped elements, found <%s>.", this.droppedElements));
        }

        @Override
        public StepVerifier.Assertions hasDropped(Object ... values) {
            this.satisfies(() -> values != null && values.length > 0, () -> "Require non-empty values");
            List<Object> valuesList = Arrays.asList(values);
            return this.satisfies(() -> this.droppedElements.containsAll(valuesList), () -> String.format("Expected dropped elements to contain <%s>, was <%s>.", valuesList, this.droppedElements));
        }

        @Override
        public StepVerifier.Assertions hasDroppedExactly(Object ... values) {
            this.satisfies(() -> values != null && values.length > 0, () -> "Require non-empty values");
            List<Object> valuesList = Arrays.asList(values);
            return this.satisfies(() -> this.droppedElements.containsAll(valuesList) && this.droppedElements.size() == valuesList.size(), () -> String.format("Expected dropped elements to contain exactly <%s>, was <%s>.", valuesList, this.droppedElements));
        }

        @Override
        public StepVerifier.Assertions hasNotDroppedErrors() {
            return this.satisfies(this.droppedErrors::isEmpty, () -> String.format("Expected no dropped errors, found <%s>.", this.droppedErrors));
        }

        @Override
        public StepVerifier.Assertions hasDroppedErrors() {
            return this.satisfies(() -> !this.droppedErrors.isEmpty(), () -> "Expected at least 1 dropped error, none found.");
        }

        @Override
        public StepVerifier.Assertions hasDroppedErrors(int size) {
            return this.satisfies(() -> this.droppedErrors.size() == size, () -> String.format("Expected exactly %d dropped errors, %d found.", size, this.droppedErrors.size()));
        }

        @Override
        public StepVerifier.Assertions hasDroppedErrorOfType(Class<? extends Throwable> clazz) {
            this.satisfies(() -> clazz != null, () -> "Require non-null clazz");
            this.hasDroppedErrors(1);
            return this.satisfies(() -> clazz.isInstance(this.droppedErrors.peek()), () -> String.format("Expected dropped error to be of type %s, was %s.", clazz.getCanonicalName(), this.droppedErrors.peek().getClass().getCanonicalName()));
        }

        @Override
        public StepVerifier.Assertions hasDroppedErrorMatching(Predicate<Throwable> matcher) {
            this.satisfies(() -> matcher != null, () -> "Require non-null matcher");
            this.hasDroppedErrors(1);
            return this.satisfies(() -> matcher.test(this.droppedErrors.peek()), () -> String.format("Expected dropped error matching the given predicate, did not match: <%s>.", this.droppedErrors.peek()));
        }

        @Override
        public StepVerifier.Assertions hasDroppedErrorWithMessage(String message) {
            this.satisfies(() -> message != null, () -> "Require non-null message");
            this.hasDroppedErrors(1);
            String actual = this.droppedErrors.peek().getMessage();
            return this.satisfies(() -> message.equals(actual), () -> String.format("Expected dropped error with message <\"%s\">, was <\"%s\">.", message, actual));
        }

        @Override
        public StepVerifier.Assertions hasDroppedErrorWithMessageContaining(String messagePart) {
            this.satisfies(() -> messagePart != null, () -> "Require non-null messagePart");
            this.hasDroppedErrors(1);
            String actual = this.droppedErrors.peek().getMessage();
            return this.satisfies(() -> actual != null && actual.contains(messagePart), () -> String.format("Expected dropped error with message containing <\"%s\">, was <\"%s\">.", messagePart, actual));
        }

        @Override
        public StepVerifier.Assertions hasDroppedErrorsMatching(Predicate<Collection<Throwable>> matcher) {
            this.satisfies(() -> matcher != null, () -> "Require non-null matcher");
            this.hasDroppedErrors();
            return this.satisfies(() -> matcher.test(this.droppedErrors), () -> String.format("Expected collection of dropped errors matching the given predicate, did not match: <%s>.", this.droppedErrors));
        }

        @Override
        public StepVerifier.Assertions hasDroppedErrorsSatisfying(Consumer<Collection<Throwable>> asserter) {
            this.satisfies(() -> asserter != null, () -> "Require non-null asserter");
            this.hasDroppedErrors();
            asserter.accept(this.droppedErrors);
            return this;
        }

        @Override
        public StepVerifier.Assertions hasOperatorErrors() {
            return this.satisfies(() -> !this.operatorErrors.isEmpty(), () -> "Expected at least 1 operator error, none found.");
        }

        @Override
        public StepVerifier.Assertions hasOperatorErrors(int size) {
            return this.satisfies(() -> this.operatorErrors.size() == size, () -> String.format("Expected exactly %d operator errors, %d found.", size, this.operatorErrors.size()));
        }

        StepVerifier.Assertions hasOneOperatorErrorWithError() {
            this.satisfies(() -> this.operatorErrors.size() == 1, () -> String.format("Expected exactly one operator error, %d found.", this.operatorErrors.size()));
            this.satisfies(() -> ((Optional)this.operatorErrors.peek().getT1()).isPresent(), () -> "Expected exactly one operator error with an actual throwable content, no throwable found.");
            return this;
        }

        @Override
        public StepVerifier.Assertions hasOperatorErrorOfType(Class<? extends Throwable> clazz) {
            this.satisfies(() -> clazz != null, () -> "Require non-null clazz");
            this.hasOneOperatorErrorWithError();
            return this.satisfies(() -> clazz.isInstance(((Optional)this.operatorErrors.peek().getT1()).get()), () -> String.format("Expected operator error to be of type %s, was %s.", clazz.getCanonicalName(), ((Throwable)((Optional)this.operatorErrors.peek().getT1()).get()).getClass().getCanonicalName()));
        }

        @Override
        public StepVerifier.Assertions hasOperatorErrorMatching(Predicate<Throwable> matcher) {
            this.satisfies(() -> matcher != null, () -> "Require non-null matcher");
            this.hasOneOperatorErrorWithError();
            return this.satisfies(() -> matcher.test(((Optional)this.operatorErrors.peek().getT1()).orElse(null)), () -> String.format("Expected operator error matching the given predicate, did not match: <%s>.", this.operatorErrors.peek()));
        }

        @Override
        public StepVerifier.Assertions hasOperatorErrorWithMessage(String message) {
            this.satisfies(() -> message != null, () -> "Require non-null message");
            this.hasOneOperatorErrorWithError();
            String actual = ((Throwable)((Optional)this.operatorErrors.peek().getT1()).get()).getMessage();
            return this.satisfies(() -> message.equals(actual), () -> String.format("Expected operator error with message <\"%s\">, was <\"%s\">.", message, actual));
        }

        @Override
        public StepVerifier.Assertions hasOperatorErrorWithMessageContaining(String messagePart) {
            this.satisfies(() -> messagePart != null, () -> "Require non-null messagePart");
            this.hasOneOperatorErrorWithError();
            String actual = ((Throwable)((Optional)this.operatorErrors.peek().getT1()).get()).getMessage();
            return this.satisfies(() -> actual != null && actual.contains(messagePart), () -> String.format("Expected operator error with message containing <\"%s\">, was <\"%s\">.", messagePart, actual));
        }

        @Override
        public StepVerifier.Assertions hasOperatorErrorsMatching(Predicate<Collection<Tuple2<Optional<Throwable>, Optional<?>>>> matcher) {
            this.satisfies(() -> matcher != null, () -> "Require non-null matcher");
            this.hasOperatorErrors();
            return this.satisfies(() -> matcher.test(this.operatorErrors), () -> String.format("Expected collection of operator errors matching the given predicate, did not match: <%s>.", this.operatorErrors));
        }

        @Override
        public StepVerifier.Assertions hasOperatorErrorsSatisfying(Consumer<Collection<Tuple2<Optional<Throwable>, Optional<?>>>> asserter) {
            this.satisfies(() -> asserter != null, () -> "Require non-null asserter");
            this.hasOperatorErrors();
            asserter.accept(this.operatorErrors);
            return this;
        }

        @Override
        public StepVerifier.Assertions tookLessThan(Duration d) {
            return this.satisfies(() -> this.duration.compareTo(d) <= 0, () -> String.format("Expected scenario to be verified in less than %sms, took %sms.", d.toMillis(), this.duration.toMillis()));
        }

        @Override
        public StepVerifier.Assertions tookMoreThan(Duration d) {
            return this.satisfies(() -> this.duration.compareTo(d) >= 0, () -> String.format("Expected scenario to be verified in more than %sms, took %sms.", d.toMillis(), this.duration.toMillis()));
        }
    }

    static final class DefaultVerifySubscriber<T>
    extends AtomicReference<Subscription>
    implements StepVerifier,
    CoreSubscriber<T>,
    Scannable {
        final CountDownLatch completeLatch;
        final Queue<Event<T>> script;
        final Queue<TaskEvent<T>> taskEvents;
        final int requestedFusionMode;
        final int expectedFusionMode;
        final long initialRequest;
        final Context initialContext;
        final VirtualTimeScheduler virtualTimeScheduler;
        Logger logger;
        int establishedFusionMode;
        Fuseable.QueueSubscription<T> qs;
        long produced;
        long unasserted;
        volatile long requested;
        volatile boolean done;
        Iterator<? extends T> currentNextAs;
        Collection<T> currentCollector;
        static final AtomicLongFieldUpdater<DefaultVerifySubscriber> REQUESTED = AtomicLongFieldUpdater.newUpdater(DefaultVerifySubscriber.class, "requested");
        volatile int wip;
        volatile Throwable errors;
        volatile boolean monitorSignal;

        DefaultVerifySubscriber(List<Event<T>> script, long initialRequest, int requestedFusionMode, int expectedFusionMode, boolean debugEnabled, @Nullable Context initialContext, @Nullable VirtualTimeScheduler vts) {
            Event<T> event;
            this.virtualTimeScheduler = vts;
            this.requestedFusionMode = requestedFusionMode;
            this.expectedFusionMode = expectedFusionMode;
            this.initialRequest = initialRequest;
            this.logger = debugEnabled ? Loggers.getLogger(StepVerifier.class) : null;
            this.script = DefaultVerifySubscriber.conflateScript(script, this.logger);
            this.taskEvents = new ConcurrentLinkedQueue<TaskEvent<T>>();
            while ((event = this.script.peek()) instanceof TaskEvent) {
                this.taskEvents.add((TaskEvent)this.script.poll());
            }
            this.monitorSignal = this.taskEvents.peek() instanceof NoEvent;
            this.produced = 0L;
            this.unasserted = 0L;
            this.completeLatch = new CountDownLatch(1);
            this.requested = initialRequest;
            this.initialContext = initialContext == null ? Context.empty() : initialContext;
        }

        static <R> Queue<Event<R>> conflateScript(List<Event<R>> script, @Nullable Logger logger) {
            Event<R> event;
            ConcurrentLinkedQueue<Event<R>> queue = new ConcurrentLinkedQueue<Event<R>>(script);
            ConcurrentLinkedQueue<Event<R>> conflated = new ConcurrentLinkedQueue<Event<Object>>();
            while ((event = queue.peek()) != null) {
                if (event instanceof TaskEvent) {
                    conflated.add(queue.poll());
                    while (queue.peek() instanceof SubscriptionEvent) {
                        conflated.add(new SubscriptionTaskEvent((SubscriptionEvent)queue.poll()));
                    }
                    continue;
                }
                conflated.add(queue.poll());
            }
            Iterator iterator = conflated.iterator();
            Event previous = null;
            while (iterator.hasNext()) {
                Event current = (Event)iterator.next();
                if (previous != null && current instanceof DescriptionEvent) {
                    String newDescription = current.getDescription();
                    String oldDescription = previous.getDescription();
                    boolean applied = previous.setDescription(newDescription);
                    if (logger != null && applied) {
                        logger.debug("expectation <{}> now described as <{}>", new Object[]{oldDescription, newDescription});
                    }
                }
                previous = current;
            }
            queue.clear();
            queue.addAll(conflated.stream().filter(ev -> !(ev instanceof DescriptionEvent)).collect(Collectors.toList()));
            conflated = queue;
            if (logger != null) {
                logger.debug("Scenario:");
                for (Event<R> current : conflated) {
                    logger.debug("\t<{}>", new Object[]{current.getDescription()});
                }
            }
            return conflated;
        }

        public Object scanUnsafe(Scannable.Attr key) {
            Subscription s;
            if (key == Scannable.Attr.PARENT && (s = (Subscription)this.get()) instanceof Scannable) {
                return s;
            }
            return null;
        }

        public Context currentContext() {
            return this.initialContext;
        }

        VirtualTimeScheduler virtualTimeScheduler() {
            return this.virtualTimeScheduler;
        }

        boolean isCancelled() {
            return this.get() == Operators.cancelledSubscription();
        }

        boolean isTerminated() {
            return this.completeLatch.getCount() == 0L;
        }

        public void onComplete() {
            if (this.establishedFusionMode != 2) {
                this.onExpectation(Signal.complete());
                this.completeLatch.countDown();
            } else {
                this.done = true;
                this.serializeDrainAndSubscriptionEvent();
            }
        }

        public void onError(Throwable t) {
            this.onExpectation(Signal.error((Throwable)t));
            this.completeLatch.countDown();
        }

        public void onNext(T t) {
            if (this.establishedFusionMode == 2) {
                this.serializeDrainAndSubscriptionEvent();
            } else {
                Signal signal;
                ++this.produced;
                ++this.unasserted;
                if (this.currentCollector != null) {
                    this.currentCollector.add(t);
                }
                if (!this.checkRequestOverflow(signal = Signal.next(t))) {
                    this.onExpectation(signal);
                }
            }
        }

        public void onSubscribe(Subscription subscription) {
            Objects.requireNonNull(subscription, "onSubscribe");
            if (this.compareAndSet(null, subscription)) {
                this.onExpectation(Signal.subscribe((Subscription)subscription));
                if (this.requestedFusionMode >= 0) {
                    this.startFusion(subscription);
                } else if (this.initialRequest != 0L) {
                    subscription.request(this.initialRequest);
                }
            } else {
                subscription.cancel();
                if (this.isCancelled()) {
                    this.setFailure(null, "an unexpected Subscription has been received: %s; actual: cancelled", subscription);
                } else {
                    this.setFailure(null, "an unexpected Subscription has been received: %s; actual: ", subscription, this);
                }
            }
        }

        void drainAsyncLoop() {
            long r = this.requested;
            do {
                boolean d;
                if ((d = this.done) && this.qs.isEmpty()) {
                    if (this.get() == Operators.cancelledSubscription()) {
                        return;
                    }
                    if (this.errors != null) {
                        this.onExpectation(Signal.complete());
                    }
                    this.completeLatch.countDown();
                    return;
                }
                if (r == 0L) {
                    return;
                }
                long p = 0L;
                while (p != r) {
                    Signal signal;
                    Object t;
                    if (this.get() == Operators.cancelledSubscription()) {
                        return;
                    }
                    try {
                        t = this.qs.poll();
                        if (t == null) break;
                        ++p;
                        ++this.produced;
                        ++this.unasserted;
                    }
                    catch (Throwable e) {
                        Exceptions.throwIfFatal((Throwable)e);
                        this.cancel();
                        this.onError(Exceptions.unwrap((Throwable)e));
                        return;
                    }
                    if (this.currentCollector != null) {
                        this.currentCollector.add(t);
                    }
                    if (!this.checkRequestOverflow(signal = Signal.next((Object)t))) {
                        this.onExpectation(signal);
                        if (!d || !this.qs.isEmpty()) continue;
                        if (this.get() == Operators.cancelledSubscription()) {
                            return;
                        }
                        if (this.errors != null) {
                            this.onExpectation(Signal.complete());
                        }
                        this.completeLatch.countDown();
                        return;
                    }
                    return;
                }
                if (p == 0L) continue;
                r = REQUESTED.addAndGet(this, -p);
            } while (r != 0L && !this.qs.isEmpty());
        }

        @Override
        public DefaultVerifySubscriber<T> log() {
            if (this.logger == null) {
                this.logger = Loggers.getLogger(StepVerifier.class);
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public StepVerifier.Assertions verifyThenAssertThat() {
            ConcurrentLinkedQueue<Object> droppedElements = new ConcurrentLinkedQueue<Object>();
            ConcurrentLinkedQueue<Throwable> droppedErrors = new ConcurrentLinkedQueue<Throwable>();
            ConcurrentLinkedQueue operatorErrors = new ConcurrentLinkedQueue();
            Hooks.onErrorDropped(droppedErrors::offer);
            Hooks.onNextDropped(droppedElements::offer);
            Hooks.onOperatorError((t, d) -> {
                operatorErrors.offer(Tuples.of(Optional.ofNullable(t), Optional.ofNullable(d)));
                return t;
            });
            try {
                Duration time = this.verify();
                DefaultStepVerifierAssertions defaultStepVerifierAssertions = new DefaultStepVerifierAssertions(droppedElements, droppedErrors, operatorErrors, time);
                return defaultStepVerifierAssertions;
            }
            finally {
                Hooks.resetOnNextDropped();
                Hooks.resetOnErrorDropped();
                Hooks.resetOnOperatorError();
            }
        }

        @Override
        public Duration verify() {
            return this.verify(defaultVerifyTimeout);
        }

        @Override
        public Duration verify(Duration duration) {
            Objects.requireNonNull(duration, "duration");
            Instant now = Instant.now();
            try {
                this.pollTaskEventOrComplete(duration);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
            this.validate();
            return Duration.between(now, Instant.now());
        }

        final void setFailure(@Nullable Event<T> event, String msg, Object ... arguments) {
            this.setFailure(event, null, msg, arguments);
        }

        final void setFailure(@Nullable Event<T> event, @Nullable Signal<T> actualSignal, String msg, Object ... arguments) {
            Exceptions.addThrowable(ERRORS, (Object)this, (Throwable)((Throwable)((Object)DefaultStepVerifierBuilder.fail(event, msg, arguments).get())));
            this.maybeCancel(actualSignal);
            this.completeLatch.countDown();
        }

        final void setFailurePrefix(String prefix, Signal<T> actualSignal, String msg, Object ... arguments) {
            Exceptions.addThrowable(ERRORS, (Object)this, (Throwable)((Throwable)((Object)DefaultStepVerifierBuilder.failPrefix(prefix, msg, arguments).get())));
            this.maybeCancel(actualSignal);
            this.completeLatch.countDown();
        }

        @Nullable
        final Subscription cancel() {
            Subscription s = this.getAndSet(Operators.cancelledSubscription());
            if (s != null && s != Operators.cancelledSubscription()) {
                s.cancel();
                if (this.establishedFusionMode == 2) {
                    this.qs.clear();
                }
            }
            return s;
        }

        final void maybeCancel(@Nullable Signal<T> actualSignal) {
            if (actualSignal == null || !actualSignal.isOnComplete() && !actualSignal.isOnError()) {
                this.cancel();
            }
        }

        final Optional<AssertionError> checkCountMismatch(SignalCountEvent<T> event, Signal<T> s) {
            long expected = event.count;
            if (!s.isOnNext()) {
                return DefaultStepVerifierBuilder.fail(event, "expected: count = %s; actual: counted = %s; signal: %s", expected, this.unasserted, s);
            }
            return Optional.empty();
        }

        final boolean checkRequestOverflow(Signal<T> s) {
            long r = this.requested;
            if (!s.isOnNext() || r < 0L || r == Long.MAX_VALUE || this.establishedFusionMode == 2 && r != 0L || r >= this.produced) {
                return false;
            }
            this.setFailurePrefix("request overflow (", s, "expected production of at most %s; produced: %s; request overflown by signal: %s", r, this.produced, s);
            return true;
        }

        boolean onCollect(Signal<T> actualSignal) {
            CollectEvent collectEvent = (CollectEvent)this.script.poll();
            if (collectEvent.supplier != null) {
                Collection c = collectEvent.get();
                this.currentCollector = c;
                if (c == null) {
                    this.setFailure(collectEvent, actualSignal, "expected collection; actual supplied is [null]", new Object[0]);
                }
                return true;
            }
            Collection<T> c = this.currentCollector;
            if (c == null) {
                this.setFailure(collectEvent, actualSignal, "expected record collector; actual record is [null]", new Object[0]);
                return true;
            }
            Optional<AssertionError> error = collectEvent.test(c);
            if (error.isPresent()) {
                Exceptions.addThrowable(ERRORS, (Object)this, (Throwable)((Throwable)((Object)error.get())));
                this.maybeCancel(actualSignal);
                this.completeLatch.countDown();
                return true;
            }
            return true;
        }

        final void onExpectation(Signal<T> actualSignal) {
            if (this.monitorSignal) {
                this.setFailure(null, actualSignal, "expected no event: %s", actualSignal);
                return;
            }
            try {
                Event<T> event = this.script.peek();
                if (event == null) {
                    this.waitTaskEvent();
                    if (this.isCancelled()) {
                        return;
                    }
                    this.setFailure(null, actualSignal, "did not expect: %s", actualSignal);
                    return;
                }
                if (this.onTaskEvent()) {
                    event = this.script.peek();
                }
                if (event instanceof SignalConsumeWhileEvent) {
                    if (this.consumeWhile(actualSignal, (SignalConsumeWhileEvent)event)) {
                        return;
                    }
                    event = this.script.peek();
                }
                if (event instanceof SignalCountEvent ? this.onSignalCount(actualSignal, (SignalCountEvent)event) : (event instanceof CollectEvent ? this.onCollect(actualSignal) : (event instanceof SignalSequenceEvent ? this.onSignalSequence(actualSignal, (SignalSequenceEvent)event) : event instanceof SignalEvent && this.onSignal(actualSignal)))) {
                    return;
                }
                event = this.script.peek();
                while (event != null && event instanceof EagerEvent) {
                    if (event instanceof SubscriptionEvent) {
                        if (this.serializeDrainAndSubscriptionEvent()) {
                            return;
                        }
                    } else if (event instanceof CollectEvent) {
                        if (this.onCollect(actualSignal)) {
                            return;
                        }
                    } else {
                        this.onTaskEvent();
                    }
                    event = this.script.peek();
                }
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal((Throwable)e);
                if (e instanceof AssertionError) {
                    Exceptions.addThrowable(ERRORS, (Object)this, (Throwable)e);
                } else {
                    String msg = e.getMessage() != null ? e.getMessage() : "";
                    AssertionError wrapFailure = DefaultStepVerifierBuilder.fail(null, "failed running expectation on signal [%s] with [%s]:\n%s", actualSignal, Exceptions.unwrap((Throwable)e).getClass().getName(), msg).get();
                    ((Throwable)((Object)wrapFailure)).addSuppressed(e);
                    Exceptions.addThrowable(ERRORS, (Object)this, (Throwable)((Object)wrapFailure));
                }
                this.maybeCancel(actualSignal);
                this.completeLatch.countDown();
            }
        }

        boolean onSignal(Signal<T> actualSignal) {
            SignalEvent signalEvent = (SignalEvent)this.script.poll();
            Optional<AssertionError> error = signalEvent.test(actualSignal);
            if (error.isPresent()) {
                Exceptions.addThrowable(ERRORS, (Object)this, (Throwable)((Throwable)((Object)error.get())));
                if (actualSignal.isOnError()) {
                    ((Throwable)((Object)error.get())).addSuppressed(actualSignal.getThrowable());
                }
                this.maybeCancel(actualSignal);
                this.completeLatch.countDown();
                return true;
            }
            if (actualSignal.isOnNext()) {
                --this.unasserted;
            }
            return false;
        }

        boolean onSignalSequence(Signal<T> actualSignal, SignalSequenceEvent<T> sequenceEvent) {
            Optional<AssertionError> error;
            Iterator<T> currentNextAs = this.currentNextAs;
            if (currentNextAs == null) {
                currentNextAs = sequenceEvent.iterable.iterator();
                this.currentNextAs = currentNextAs;
            }
            if ((error = sequenceEvent.test(actualSignal, currentNextAs)) == EXPECT_MORE) {
                if (actualSignal.isOnNext()) {
                    --this.unasserted;
                }
                return false;
            }
            if (!error.isPresent()) {
                this.currentNextAs = null;
                this.script.poll();
                if (actualSignal.isOnNext()) {
                    --this.unasserted;
                }
            } else {
                Exceptions.addThrowable(ERRORS, (Object)this, (Throwable)((Throwable)((Object)error.get())));
                if (actualSignal.isOnError()) {
                    ((Throwable)((Object)error.get())).addSuppressed(actualSignal.getThrowable());
                }
                this.maybeCancel(actualSignal);
                this.completeLatch.countDown();
                return true;
            }
            return false;
        }

        boolean consumeWhile(Signal<T> actualSignal, SignalConsumeWhileEvent<T> whileEvent) {
            if (actualSignal.isOnNext() && whileEvent.test(actualSignal.get())) {
                --this.unasserted;
                if (this.logger != null) {
                    this.logger.debug("{} consumed {}", new Object[]{whileEvent.getDescription(), actualSignal});
                }
                return true;
            }
            if (this.logger != null) {
                this.logger.debug("{} stopped at {}", new Object[]{whileEvent.getDescription(), actualSignal});
            }
            this.script.poll();
            return false;
        }

        final boolean onSignalCount(Signal<T> actualSignal, SignalCountEvent<T> event) {
            if (this.unasserted >= event.count) {
                this.script.poll();
                this.unasserted -= event.count;
            } else {
                Optional<AssertionError> error;
                if (event.count != 0L && (error = this.checkCountMismatch(event, actualSignal)).isPresent()) {
                    Exceptions.addThrowable(ERRORS, (Object)this, (Throwable)((Throwable)((Object)error.get())));
                    if (actualSignal.isOnError()) {
                        ((Throwable)((Object)error.get())).addSuppressed(actualSignal.getThrowable());
                    }
                    this.maybeCancel(actualSignal);
                    this.completeLatch.countDown();
                }
                return true;
            }
            return false;
        }

        boolean onTaskEvent() {
            boolean foundTaskEvents = false;
            while (!this.isCancelled()) {
                Event<T> event = this.script.peek();
                if (!(event instanceof TaskEvent)) {
                    return foundTaskEvents;
                }
                event = this.script.poll();
                if (!(event instanceof TaskEvent)) {
                    return foundTaskEvents;
                }
                this.taskEvents.add((TaskEvent)event);
                foundTaskEvents = true;
            }
            return foundTaskEvents;
        }

        boolean onSubscriptionLoop() {
            if (this.script.peek() instanceof SubscriptionEvent) {
                SubscriptionEvent subscriptionEvent = (SubscriptionEvent)this.script.poll();
                if (subscriptionEvent instanceof RequestEvent) {
                    this.updateRequested(subscriptionEvent);
                }
                if (subscriptionEvent.isTerminal()) {
                    this.doCancel();
                    return true;
                }
                subscriptionEvent.consume((Subscription)this.get());
            }
            return false;
        }

        boolean serializeDrainAndSubscriptionEvent() {
            int missed = WIP.incrementAndGet(this);
            if (missed != 1) {
                return true;
            }
            do {
                if (this.onSubscriptionLoop()) {
                    return true;
                }
                if (this.establishedFusionMode != 2) continue;
                this.drainAsyncLoop();
            } while ((missed = WIP.addAndGet(this, -missed)) != 0);
            return false;
        }

        void doCancel() {
            this.cancel();
            this.completeLatch.countDown();
        }

        void waitTaskEvent() {
            Event event;
            while ((event = (Event)this.taskEvents.poll()) != null) {
                try {
                    if (event instanceof SubscriptionTaskEvent) {
                        this.updateRequested(event);
                    }
                    ((TaskEvent)event).run(this);
                }
                catch (Throwable t) {
                    Exceptions.throwIfFatal((Throwable)t);
                    this.cancel();
                    if (t instanceof AssertionError) {
                        throw (AssertionError)((Object)t);
                    }
                    throw Exceptions.propagate((Throwable)t);
                }
            }
        }

        final void pollTaskEventOrComplete(Duration timeout) throws InterruptedException {
            block2: {
                Objects.requireNonNull(timeout, "timeout");
                Instant stop = Instant.now().plus(timeout);
                do {
                    this.waitTaskEvent();
                    if (this.completeLatch.await(10L, TimeUnit.NANOSECONDS)) break block2;
                } while (timeout == Duration.ZERO || !stop.isBefore(Instant.now()));
                if (this.get() == null) {
                    throw new IllegalStateException("VerifySubscriber has not been subscribed");
                }
                throw new AssertionError((Object)("VerifySubscriber timed out on " + this.get()));
            }
        }

        private void updateRequested(Event<?> event) {
            RequestEvent requestEvent = null;
            if (event instanceof RequestEvent) {
                requestEvent = (RequestEvent)event;
            } else if (event instanceof SubscriptionTaskEvent) {
                SubscriptionTaskEvent ste = (SubscriptionTaskEvent)event;
                if (ste.delegate instanceof RequestEvent) {
                    requestEvent = (RequestEvent)ste.delegate;
                }
            }
            if (requestEvent == null) {
                return;
            }
            if (requestEvent.isBounded()) {
                Operators.addCap(REQUESTED, (Object)this, (long)requestEvent.getRequestAmount());
            } else {
                REQUESTED.set(this, Long.MAX_VALUE);
            }
        }

        final void startFusion(Subscription s) {
            block15: {
                if (s instanceof Fuseable.QueueSubscription) {
                    Fuseable.QueueSubscription qs;
                    this.qs = qs = (Fuseable.QueueSubscription)s;
                    int m = qs.requestFusion(this.requestedFusionMode);
                    if (this.expectedFusionMode == 0 && m != 0) {
                        this.setFailure(null, "expected no fusion; actual: %s", DefaultStepVerifierBuilder.formatFusionMode(m));
                        return;
                    }
                    if (this.expectedFusionMode != 0 && m == 0) {
                        this.setFailure(null, "expected fusion: %s; actual does not support fusion", DefaultStepVerifierBuilder.formatFusionMode(this.expectedFusionMode));
                        return;
                    }
                    if ((m & this.expectedFusionMode) != m) {
                        this.setFailure(null, "expected fusion mode: %s; actual: %s", DefaultStepVerifierBuilder.formatFusionMode(this.expectedFusionMode), DefaultStepVerifierBuilder.formatFusionMode(m));
                        return;
                    }
                    this.establishedFusionMode = m;
                    if (m == 1) {
                        while (true) {
                            Object v;
                            if (this.get() == Operators.cancelledSubscription()) {
                                return;
                            }
                            try {
                                v = qs.poll();
                            }
                            catch (Throwable e) {
                                Exceptions.throwIfFatal((Throwable)e);
                                this.cancel();
                                this.onError(Exceptions.unwrap((Throwable)e));
                                return;
                            }
                            if (v == null) {
                                this.onComplete();
                                break block15;
                            }
                            this.onNext(v);
                        }
                    }
                    if (this.initialRequest != 0L) {
                        s.request(this.initialRequest);
                    }
                } else if (this.expectedFusionMode != 0) {
                    this.setFailure(null, "expected fuseable source but actual Subscription is not: %s", this.expectedFusionMode, s);
                } else if (this.initialRequest != 0L) {
                    s.request(this.initialRequest);
                }
            }
        }

        final void validate() {
            if (this.get() == null) {
                throw new IllegalStateException("VerifySubscriber has not been subscribed");
            }
            Throwable errors = this.errors;
            if (errors == null) {
                return;
            }
            if (errors instanceof AssertionError) {
                throw (AssertionError)((Object)errors);
            }
            ArrayList<Throwable> flat = new ArrayList<Throwable>();
            flat.add(errors);
            flat.addAll(Arrays.asList(errors.getSuppressed()));
            StringBuilder messageBuilder = new StringBuilder("Expectation failure(s):\n");
            flat.stream().flatMap(error -> Stream.of(" - ", error, "\n")).forEach(messageBuilder::append);
            messageBuilder.delete(messageBuilder.length() - 1, messageBuilder.length());
            throw new AssertionError(messageBuilder.toString(), errors);
        }
    }

    static final class DefaultStepVerifier<T>
    implements StepVerifier {
        private static final Lock vtsLock = new ReentrantLock(true);
        private final DefaultStepVerifierBuilder<T> parent;
        private final int requestedFusionMode;
        private final int expectedFusionMode;
        private boolean debugEnabled;

        DefaultStepVerifier(DefaultStepVerifierBuilder<T> parent) {
            this.parent = parent;
            this.requestedFusionMode = parent.requestedFusionMode;
            this.expectedFusionMode = parent.expectedFusionMode == -1 ? parent.requestedFusionMode : parent.expectedFusionMode;
        }

        @Override
        public DefaultStepVerifier<T> log() {
            this.debugEnabled = true;
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public StepVerifier.Assertions verifyThenAssertThat() {
            ConcurrentLinkedQueue<Object> droppedElements = new ConcurrentLinkedQueue<Object>();
            ConcurrentLinkedQueue<Throwable> droppedErrors = new ConcurrentLinkedQueue<Throwable>();
            ConcurrentLinkedQueue operatorErrors = new ConcurrentLinkedQueue();
            Hooks.onErrorDropped(droppedErrors::offer);
            Hooks.onNextDropped(droppedElements::offer);
            Hooks.onOperatorError((t, d) -> {
                operatorErrors.offer(Tuples.of(Optional.ofNullable(t), Optional.ofNullable(d)));
                return t;
            });
            try {
                Duration time = this.verify();
                DefaultStepVerifierAssertions defaultStepVerifierAssertions = new DefaultStepVerifierAssertions(droppedElements, droppedErrors, operatorErrors, time);
                return defaultStepVerifierAssertions;
            }
            finally {
                Hooks.resetOnNextDropped();
                Hooks.resetOnErrorDropped();
                Hooks.resetOnOperatorError();
            }
        }

        @Override
        public Duration verify() {
            return this.verify(defaultVerifyTimeout);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Duration verify(Duration duration) {
            Objects.requireNonNull(duration, "duration");
            if (this.parent.sourceSupplier != null) {
                VirtualTimeScheduler vts = null;
                if (this.parent.vtsLookup != null) {
                    vtsLock.lock();
                    vts = this.parent.vtsLookup.get();
                    VirtualTimeScheduler.set(vts);
                }
                try {
                    Publisher publisher = this.parent.sourceSupplier.get();
                    Instant now = Instant.now();
                    DefaultVerifySubscriber newVerifier = new DefaultVerifySubscriber(this.parent.script, this.parent.initialRequest, this.requestedFusionMode, this.expectedFusionMode, this.debugEnabled, ((DefaultStepVerifierBuilder)this.parent).options.getInitialContext(), vts);
                    publisher.subscribe(newVerifier);
                    newVerifier.verify(duration);
                    Duration duration2 = Duration.between(now, Instant.now());
                    return duration2;
                }
                finally {
                    if (vts != null) {
                        vts.dispose();
                        VirtualTimeScheduler.reset();
                        vtsLock.unlock();
                    }
                }
            }
            return this.toSubscriber().verify(duration);
        }

        DefaultVerifySubscriber<T> toSubscriber() {
            VirtualTimeScheduler vts = null;
            if (this.parent.vtsLookup != null) {
                vts = this.parent.vtsLookup.get();
            }
            return new DefaultVerifySubscriber(this.parent.script, this.parent.initialRequest, this.requestedFusionMode, this.expectedFusionMode, this.debugEnabled, ((DefaultStepVerifierBuilder)this.parent).options.getInitialContext(), vts);
        }
    }

    static interface Event<T> {
        public boolean setDescription(String var1);

        public String getDescription();
    }
}

