/*
 * Decompiled with CFR 0.152.
 */
package reactor.rx.stream;

import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.support.Exceptions;
import reactor.rx.Stream;
import reactor.rx.subscription.PushSubscription;

public final class RangeStream
extends Stream<Long> {
    private final long start;
    private final long end;

    public RangeStream(long start, long end) {
        this.start = start;
        this.end = end;
    }

    public void subscribe(Subscriber<? super Long> subscriber) {
        try {
            if (this.start <= this.end) {
                subscriber.onSubscribe((Subscription)new PushSubscription<Long>((Stream)this, subscriber){
                    Long cursor;
                    {
                        this.cursor = RangeStream.this.start;
                    }

                    @Override
                    public void request(long elements) {
                        for (long l = 0L; l < elements && this.cursor <= RangeStream.this.end; ++l) {
                            if (this.isComplete()) {
                                return;
                            }
                            Long l2 = this.cursor;
                            Long l3 = this.cursor = Long.valueOf(this.cursor + 1L);
                            this.onNext(l2);
                        }
                        if (this.cursor > RangeStream.this.end) {
                            this.onComplete();
                        }
                    }

                    @Override
                    public String toString() {
                        return "{cursor=" + this.cursor + "" + (RangeStream.this.end > 0L ? "[" + 100L * (this.cursor - 1L) / RangeStream.this.end + "%]" : "") + ", start=" + RangeStream.this.start + ", end=" + RangeStream.this.end + "}";
                    }
                });
            } else {
                subscriber.onComplete();
            }
        }
        catch (Throwable throwable) {
            Exceptions.throwIfFatal((Throwable)throwable);
            subscriber.onError(throwable);
        }
    }

    @Override
    public String toString() {
        return super.toString() + " [" + this.start + " to " + this.end + "]";
    }
}

