/*
 * Decompiled with CFR 0.152.
 */
package reactor.rx.subscription;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.fn.Consumer;
import reactor.rx.Stream;
import reactor.rx.subscription.support.WrappedSubscription;

public class PushSubscription<O>
implements Subscription,
Consumer<Long> {
    protected final Subscriber<? super O> subscriber;
    protected final Stream<O> publisher;
    protected volatile int terminated = 0;
    protected static final AtomicIntegerFieldUpdater<PushSubscription> TERMINAL_UPDATER = AtomicIntegerFieldUpdater.newUpdater(PushSubscription.class, "terminated");
    protected volatile long pendingRequestSignals = 0L;
    protected static final AtomicLongFieldUpdater<PushSubscription> PENDING_UPDATER = AtomicLongFieldUpdater.newUpdater(PushSubscription.class, "pendingRequestSignals");

    public static <O> PushSubscription<O> wrap(Subscription subscription, Subscriber<? super O> errorSubscriber) {
        return new WrappedSubscription<O>(subscription, errorSubscriber);
    }

    public PushSubscription(Stream<O> publisher, Subscriber<? super O> subscriber) {
        this.subscriber = subscriber;
        this.publisher = publisher;
    }

    public final void accept(Long n) {
        this.request(n);
    }

    public void request(long n) {
        try {
            if (this.publisher == null && this.pendingRequestSignals != Long.MAX_VALUE && PENDING_UPDATER.addAndGet(this, n) < 0L) {
                PENDING_UPDATER.set(this, Long.MAX_VALUE);
            }
            if ((long)this.terminated == -1L) {
                this.pendingRequestSignals = n;
                return;
            }
            this.onRequest(n);
        }
        catch (Throwable t) {
            this.subscriber.onError(t);
        }
    }

    public void cancel() {
        TERMINAL_UPDATER.set(this, 1);
        if (this.publisher != null) {
            this.publisher.cancelSubscription(this);
        }
    }

    public boolean terminate() {
        return TERMINAL_UPDATER.compareAndSet(this, 0, 1);
    }

    public void onComplete() {
        if (TERMINAL_UPDATER.compareAndSet(this, 0, 1) && this.subscriber != null) {
            this.subscriber.onComplete();
        }
    }

    public void onNext(O ev) {
        this.subscriber.onNext(ev);
    }

    public void onError(Throwable throwable) {
        if (TERMINAL_UPDATER.compareAndSet(this, 0, 1) && this.subscriber != null) {
            this.subscriber.onError(throwable);
        }
    }

    public Stream<O> getPublisher() {
        return this.publisher;
    }

    public boolean hasPublisher() {
        return this.publisher != null;
    }

    public void updatePendingRequests(long n) {
        long newPending;
        long oldPending;
        do {
            oldPending = this.pendingRequestSignals;
            long l = newPending = n == 0L ? 0L : oldPending + n;
            if (newPending >= 0L) continue;
            long l2 = newPending = n > 0L ? Long.MAX_VALUE : 0L;
        } while (!PENDING_UPDATER.compareAndSet(this, oldPending, newPending));
    }

    public void start() {
        if (this.subscriber != null && (long)this.terminated == -1L) {
            this.subscriber.onSubscribe((Subscription)this);
            if (this.markAsStarted() && this.pendingRequestSignals > 0L) {
                this.onRequest(this.pendingRequestSignals);
            }
        }
    }

    public final boolean markAsStarted() {
        return TERMINAL_UPDATER.compareAndSet(this, -1, 0);
    }

    public final boolean markAsDeferredStart() {
        return TERMINAL_UPDATER.compareAndSet(this, 0, -1);
    }

    protected void onRequest(long n) {
    }

    public final Subscriber<? super O> getSubscriber() {
        return this.subscriber;
    }

    public boolean isComplete() {
        return this.terminated == 1;
    }

    public final long pendingRequestSignals() {
        return this.pendingRequestSignals;
    }

    public void maxCapacity(long n) {
    }

    public boolean shouldRequestPendingSignals() {
        return false;
    }

    public int hashCode() {
        int result = this.subscriber.hashCode();
        if (this.publisher != null) {
            result = 31 * result + this.publisher.hashCode();
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PushSubscription that = (PushSubscription)o;
        if (this.publisher != null && this.publisher.hashCode() != that.publisher.hashCode()) {
            return false;
        }
        return this.subscriber.equals(that.subscriber);
    }

    public String toString() {
        return "{push" + (this.pendingRequestSignals > 0L && this.pendingRequestSignals != Long.MAX_VALUE ? ",pending=" + this.pendingRequestSignals : "") + "}";
    }
}

