/*
 * Decompiled with CFR 0.152.
 */
package reactor.rx.stream;

import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Dispatcher;
import reactor.fn.Supplier;
import reactor.rx.Stream;
import reactor.rx.subscription.PushSubscription;

public final class SupplierStream<T>
extends Stream<T> {
    private final Dispatcher dispatcher;
    private final Supplier<? extends T> supplier;

    public SupplierStream(Dispatcher dispatcher, Supplier<? extends T> supplier) {
        this.dispatcher = dispatcher;
        this.supplier = supplier;
    }

    public void subscribe(Subscriber<? super T> subscriber) {
        if (this.supplier != null) {
            subscriber.onSubscribe((Subscription)new PushSubscription<T>(this, subscriber){

                @Override
                public void request(long elements) {
                    try {
                        SupplierStream.this.supplyValue(this.subscriber);
                    }
                    catch (Throwable throwable) {
                        this.subscriber.onError(throwable);
                    }
                }
            });
        } else {
            subscriber.onComplete();
        }
    }

    private void supplyValue(final Subscriber<? super T> subscriber) {
        this.dispatcher.execute(new Runnable(){

            @Override
            public void run() {
                Object supplied = SupplierStream.this.supplier.get();
                if (supplied != null) {
                    subscriber.onNext(supplied);
                } else {
                    subscriber.onComplete();
                }
            }
        });
    }
}

