/*
 * Decompiled with CFR 0.152.
 */
package reactor.rx.stream;

import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.rx.Stream;
import reactor.rx.subscription.ReactiveSubscription;

public class PublisherStream<T>
extends Stream<T> {
    private final Publisher<T> source;

    public PublisherStream(Publisher<T> publisher) {
        this.source = publisher;
    }

    public void subscribe(Subscriber<? super T> subscriber) {
        subscriber.onSubscribe((Subscription)new ReactiveSubscription<T>(this, subscriber){
            private boolean started;
            private ReactiveSubscription<T> thiz;
            private Subscription subscription;
            {
                this.started = false;
                this.thiz = this;
            }

            @Override
            protected void onRequest(long elements) {
                super.onRequest(elements);
                if (!this.started) {
                    this.started = true;
                    PublisherStream.this.source.subscribe(new Subscriber<T>(){

                        public void onSubscribe(Subscription s) {
                            subscription = s;
                        }

                        public void onNext(T t) {
                            thiz.onNext(t);
                        }

                        public void onError(Throwable t) {
                            thiz.onError(t);
                        }

                        public void onComplete() {
                            thiz.onComplete();
                        }
                    });
                } else if (this.subscription != null) {
                    this.subscription.request(elements);
                }
            }

            @Override
            public void cancel() {
                super.cancel();
                if (this.subscription != null) {
                    this.subscription.cancel();
                }
            }
        });
    }
}

