/*
 * Decompiled with CFR 0.152.
 */
package reactor.rx.stream;

import java.util.concurrent.TimeUnit;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.fn.Consumer;
import reactor.fn.Pausable;
import reactor.fn.timer.Timer;
import reactor.rx.Stream;
import reactor.rx.subscription.PushSubscription;

public final class PeriodicTimerStream
extends Stream<Long> {
    private final long delay;
    private final long period;
    private final TimeUnit unit;
    private final Timer timer;

    public PeriodicTimerStream(long delay, long period, TimeUnit unit, Timer timer) {
        this.delay = delay >= 0L ? delay : -1L;
        this.unit = unit != null ? unit : TimeUnit.SECONDS;
        this.period = period;
        this.timer = timer;
    }

    public void subscribe(Subscriber<? super Long> subscriber) {
        subscriber.onSubscribe((Subscription)new TimerSubscription(this, subscriber));
    }

    @Override
    public String toString() {
        return "delay=" + this.delay + "ms" + (this.period > 0L ? ", period=" + this.period : "") + ", period-unit=" + (Object)((Object)this.unit);
    }

    private class TimerSubscription
    extends PushSubscription<Long> {
        long counter;
        final Pausable registration;

        public TimerSubscription(Stream<Long> publisher, Subscriber<? super Long> subscriber) {
            super(publisher, subscriber);
            this.counter = 0L;
            this.registration = PeriodicTimerStream.this.timer.schedule((Consumer)new Consumer<Long>(){

                public void accept(Long aLong) {
                    TimerSubscription.this.subscriber.onNext((Object)TimerSubscription.this.counter++);
                }
            }, PeriodicTimerStream.this.period, PeriodicTimerStream.this.unit, PeriodicTimerStream.this.delay == -1L ? TimeUnit.MILLISECONDS.convert(PeriodicTimerStream.this.period, PeriodicTimerStream.this.unit) : PeriodicTimerStream.this.delay);
        }

        @Override
        public void cancel() {
            this.registration.cancel();
            super.cancel();
        }
    }
}

