/*
 * Decompiled with CFR 0.152.
 */
package reactor.rx.action.control;

import org.reactivestreams.Subscriber;
import reactor.core.queue.CompletableQueue;
import reactor.fn.Supplier;
import reactor.rx.action.Action;
import reactor.rx.subscription.DropSubscription;
import reactor.rx.subscription.PushSubscription;
import reactor.rx.subscription.ReactiveSubscription;

public class FlowControlAction<O>
extends Action<O, O> {
    private final Supplier<? extends CompletableQueue<O>> queueSupplier;

    public FlowControlAction(Supplier<? extends CompletableQueue<O>> queueSupplier) {
        this.queueSupplier = queueSupplier;
    }

    @Override
    protected void doNext(O ev) {
        this.broadcastNext(ev);
    }

    @Override
    public void onError(Throwable cause) {
        this.doError(cause);
    }

    @Override
    protected PushSubscription<O> createSubscription(Subscriber<? super O> subscriber, boolean reactivePull) {
        if (this.queueSupplier != null) {
            return new ReactiveSubscription<O>(this, subscriber, (CompletableQueue)this.queueSupplier.get()){

                @Override
                public void onRequest(long elements) {
                    super.onRequest(elements);
                    FlowControlAction.this.requestUpstream(FlowControlAction.this.capacity, this.buffer.isComplete(), elements);
                }
            };
        }
        return new DropSubscription<O>(this, subscriber){

            @Override
            public void request(long elements) {
                super.request(elements);
                FlowControlAction.this.requestUpstream(this.capacity, this.isComplete(), elements);
            }
        };
    }
}

