/*
 * Decompiled with CFR 0.152.
 */
package reactor.rx.action.combination;

import java.util.Arrays;
import java.util.List;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Dispatcher;
import reactor.fn.Consumer;
import reactor.fn.Function;
import reactor.fn.tuple.Tuple;
import reactor.rx.action.combination.FanInAction;
import reactor.rx.action.combination.FanInSubscription;
import reactor.rx.subscription.PushSubscription;

public final class ZipAction<O, V, TUPLE extends Tuple>
extends FanInAction<O, Zippable<O>, V, InnerSubscriber<O, V>> {
    private static final Object EMPTY_ZIPPED_DATA = new Object();
    final Function<TUPLE, ? extends V> accumulator;
    int index = 0;
    int count = 0;
    Object[] toZip = new Object[2];

    public static <TUPLE extends Tuple, V> Function<TUPLE, List<V>> joinZipper() {
        return new Function<TUPLE, List<V>>(){

            public List<V> apply(TUPLE ts) {
                return Arrays.asList(ts.toArray());
            }
        };
    }

    public ZipAction(Dispatcher dispatcher, Function<TUPLE, ? extends V> accumulator, Iterable<? extends Publisher<? extends O>> composables) {
        super(dispatcher, composables);
        this.accumulator = accumulator;
    }

    protected void broadcastTuple(boolean isFinishing) {
        long capacity = this.capacity;
        if ((long)this.count >= capacity) {
            if (!this.checkAllFilled()) {
                return;
            }
            this.count = 0;
            Object[] _toZip = this.toZip;
            this.toZip = new Object[this.toZip.length];
            Object res = this.accumulator.apply((Object)Tuple.of((Object[])_toZip));
            if (res != null) {
                this.broadcastNext(res);
                if (!isFinishing && this.upstreamSubscription.pendingRequestSignals() > 0L) {
                    this.dispatcher.dispatch((Object)capacity, (Consumer)this.upstreamSubscription, null);
                }
            }
        }
    }

    private boolean checkAllFilled() {
        for (int i = 0; i < this.toZip.length; ++i) {
            if (this.toZip[i] != null) continue;
            return false;
        }
        return true;
    }

    @Override
    protected FanInSubscription<O, Zippable<O>, V, InnerSubscriber<O, V>> createFanInSubscription() {
        return new ZipSubscription(this);
    }

    @Override
    protected PushSubscription<Zippable<O>> createTrackingSubscription(Subscription subscription) {
        return this.innerSubscriptions;
    }

    @Override
    protected void doNext(Zippable<O> ev) {
        ++this.count;
        this.toZip[ev.index] = ev.data == null ? EMPTY_ZIPPED_DATA : ev.data;
        this.broadcastTuple(false);
    }

    @Override
    public void scheduleCompletion() {
    }

    @Override
    protected void doComplete() {
        this.broadcastTuple(true);
        super.doComplete();
    }

    protected InnerSubscriber<O, V> createSubscriber() {
        int newSize = this.innerSubscriptions.runningComposables + 1;
        this.capacity(newSize);
        if (newSize > this.toZip.length) {
            Object[] previousZip = this.toZip;
            this.toZip = new Object[newSize];
            System.arraycopy(previousZip, 0, this.toZip, 0, newSize - 1);
        }
        return new InnerSubscriber(this, this.index++);
    }

    @Override
    protected long initUpstreamPublisherAndCapacity() {
        long i = 0L;
        for (Publisher composable : this.publishers) {
            this.addPublisher(composable);
            ++i;
        }
        return i;
    }

    @Override
    public String toString() {
        String formatted = super.toString();
        for (int i = 0; i < this.toZip.length; ++i) {
            if (this.toZip[i] == null) continue;
            formatted = formatted + "(" + i + "):" + this.toZip[i] + ",";
        }
        return formatted.substring(0, this.count > 0 ? formatted.length() - 1 : formatted.length());
    }

    public static final class Zippable<O> {
        final int index;
        final O data;

        public Zippable(int index, O data) {
            this.index = index;
            this.data = data;
        }
    }

    private final class ZipSubscription
    extends FanInSubscription<O, Zippable<O>, V, InnerSubscriber<O, V>> {
        public ZipSubscription(Subscriber<? super Zippable<O>> subscriber) {
            super(subscriber);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean shouldRequestPendingSignals() {
            ZipSubscription zipSubscription = this;
            synchronized (zipSubscription) {
                return this.pendingRequestSignals > 0L && this.pendingRequestSignals != Long.MAX_VALUE && (long)ZipAction.this.count == this.maxCapacity;
            }
        }

        @Override
        public void request(long elements) {
            if (this.pendingRequestSignals == Long.MAX_VALUE) {
                super.parallelRequest(1L);
            } else {
                super.request(Math.max(elements, (long)this.runningComposables));
            }
        }
    }

    public static final class InnerSubscriber<O, V>
    extends FanInAction.InnerSubscriber<O, Zippable<O>, V> {
        final ZipAction<O, V, ?> outerAction;
        final int index;

        InnerSubscriber(ZipAction<O, V, ?> outerAction, int index) {
            super(outerAction);
            this.index = index;
            this.outerAction = outerAction;
        }

        public void onSubscribe(Subscription subscription) {
            this.setSubscription(new FanInSubscription.InnerSubscription(subscription, this));
            if (this.pendingRequests > 0L) {
                this.request(1L);
            }
            if (this.outerAction.dynamicMergeAction != null) {
                this.outerAction.dynamicMergeAction.decrementWip();
            }
        }

        @Override
        public void request(long n) {
            super.request(1L);
        }

        public void onNext(O ev) {
            if (--this.pendingRequests > 0L) {
                this.pendingRequests = 0L;
            }
            this.outerAction.innerSubscriptions.serialNext(new Zippable<O>(this.index, ev));
            if (this.outerAction.toZip[this.index] != null && this.outerAction.status.get() == 2) {
                this.onComplete();
            }
        }

        @Override
        public boolean isReactivePull(Dispatcher dispatcher, long producerCapacity) {
            return true;
        }

        @Override
        public long getCapacity() {
            return 1L;
        }

        @Override
        public String toString() {
            return "Zip.InnerSubscriber{index=" + this.index + ", " + "pending=" + this.pendingRequests + ", emitted=" + this.emittedSignals + "}";
        }
    }
}

