/*
 * Decompiled with CFR 0.152.
 */
package reactor.rx.action.combination;

import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Dispatcher;
import reactor.core.dispatch.SynchronousDispatcher;
import reactor.core.reactivestreams.SerializedSubscriber;
import reactor.core.support.NonBlocking;
import reactor.rx.action.Action;
import reactor.rx.action.support.DefaultSubscriber;

public class SwitchAction<T>
extends Action<Publisher<? extends T>, T> {
    private final SerializedSubscriber<T> serialized;
    private final Dispatcher dispatcher;
    private long pendingRequests = 0L;
    private SwitchSubscriber switchSubscriber;

    public SwitchAction(Dispatcher dispatcher) {
        this.dispatcher = dispatcher;
        this.serialized = dispatcher != SynchronousDispatcher.INSTANCE ? null : SerializedSubscriber.create((Subscriber)new DefaultSubscriber<T>(){

            @Override
            public void onNext(T t) {
                SwitchAction.this.broadcastNext(t);
            }

            @Override
            public void onError(Throwable t) {
                SwitchAction.this.broadcastError(t);
            }

            @Override
            public void onComplete() {
                SwitchAction.this.broadcastComplete();
            }
        });
    }

    public SwitchSubscriber getSwitchSubscriber() {
        return this.switchSubscriber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doNext(Publisher<? extends T> ev) {
        SwitchSubscriber nextSubscriber;
        SwitchSubscriber subscriber;
        SwitchAction switchAction = this;
        synchronized (switchAction) {
            --this.pendingRequests;
            subscriber = this.switchSubscriber;
            this.switchSubscriber = nextSubscriber = new SwitchSubscriber();
        }
        if (subscriber != null) {
            subscriber.cancel();
        }
        ev.subscribe((Subscriber)nextSubscriber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doShutdown() {
        SwitchSubscriber subscriber;
        SwitchAction switchAction = this;
        synchronized (switchAction) {
            subscriber = this.switchSubscriber;
            if (subscriber != null) {
                this.switchSubscriber = null;
            }
        }
        if (subscriber != null) {
            subscriber.cancel();
        }
        super.doShutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doComplete() {
        SwitchSubscriber subscriber;
        SwitchAction switchAction = this;
        synchronized (switchAction) {
            subscriber = this.switchSubscriber;
        }
        if (subscriber == null) {
            super.doComplete();
        } else {
            this.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void requestUpstream(long capacity, boolean terminated, long elements) {
        SwitchSubscriber subscriber;
        SwitchAction switchAction = this;
        synchronized (switchAction) {
            if ((this.pendingRequests += elements) < 0L) {
                this.pendingRequests = Long.MAX_VALUE;
            }
            subscriber = this.switchSubscriber;
        }
        super.requestUpstream(capacity, terminated, elements);
        if (subscriber != null) {
            subscriber.request(elements);
        }
    }

    @Override
    public final Dispatcher getDispatcher() {
        return this.dispatcher;
    }

    public class SwitchSubscriber
    implements NonBlocking,
    Subscriber<T>,
    Subscription {
        Subscription s;

        public boolean isReactivePull(Dispatcher dispatcher, long producerCapacity) {
            return SwitchAction.this.isReactivePull(dispatcher, producerCapacity);
        }

        public long getCapacity() {
            return SwitchAction.this.capacity;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onSubscribe(Subscription s) {
            long pending;
            this.s = s;
            SwitchAction switchAction = SwitchAction.this;
            synchronized (switchAction) {
                pending = SwitchAction.this.pendingRequests;
            }
            if (pending > 0L) {
                s.request(pending);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onNext(T t) {
            SwitchAction switchAction = SwitchAction.this;
            synchronized (switchAction) {
                if (SwitchAction.this.pendingRequests > 0L && SwitchAction.this.pendingRequests != Long.MAX_VALUE) {
                    SwitchAction.this.pendingRequests--;
                }
            }
            SwitchAction.this.serialized.onNext(t);
        }

        public void onError(Throwable t) {
            SwitchAction.this.serialized.onError(t);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onComplete() {
            SwitchAction switchAction = SwitchAction.this;
            synchronized (switchAction) {
                SwitchAction.this.switchSubscriber = null;
            }
            this.cancel();
            if (SwitchAction.this.upstreamSubscription == null) {
                SwitchAction.this.serialized.onComplete();
            }
        }

        public void request(long n) {
            this.s.request(n);
        }

        public void cancel() {
            if (this.s != null) {
                this.s.cancel();
            }
        }

        public Subscription getSubscription() {
            return this.s;
        }
    }
}

