/*
 * Decompiled with CFR 0.152.
 */
package reactor.rx.action.combination;

import org.reactivestreams.Publisher;
import org.reactivestreams.Subscription;
import reactor.core.Dispatcher;
import reactor.fn.Function;
import reactor.fn.tuple.Tuple;
import reactor.rx.action.combination.FanInAction;
import reactor.rx.action.combination.FanInSubscription;
import reactor.rx.subscription.PushSubscription;

public final class CombineLatestAction<O, V, TUPLE extends Tuple>
extends FanInAction<O, Zippable<O>, V, InnerSubscriber<O, V>> {
    private static final Object EMPTY_ZIPPED_DATA = new Object();
    final Function<TUPLE, ? extends V> accumulator;
    int index = 0;
    Object[] toZip = new Object[2];

    public CombineLatestAction(Dispatcher dispatcher, Function<TUPLE, ? extends V> accumulator, Iterable<? extends Publisher<? extends O>> composables) {
        super(dispatcher, composables);
        this.accumulator = accumulator;
    }

    protected void broadcastTuple() {
        if (!this.checkAllFilled()) {
            return;
        }
        Object[] _toZip = this.toZip;
        Object res = this.accumulator.apply((Object)Tuple.of((Object[])_toZip));
        if (res != null) {
            this.broadcastNext(res);
        }
    }

    private boolean checkAllFilled() {
        for (int i = 0; i < this.toZip.length; ++i) {
            if (this.toZip[i] != null) continue;
            return false;
        }
        return true;
    }

    @Override
    protected FanInSubscription<O, Zippable<O>, V, InnerSubscriber<O, V>> createFanInSubscription() {
        return new FanInSubscription(this);
    }

    @Override
    protected PushSubscription<Zippable<O>> createTrackingSubscription(Subscription subscription) {
        return this.innerSubscriptions;
    }

    @Override
    protected void doNext(Zippable<O> ev) {
        this.toZip[ev.index] = ev.data == null ? EMPTY_ZIPPED_DATA : ev.data;
        this.broadcastTuple();
    }

    @Override
    public void scheduleCompletion() {
    }

    @Override
    protected void doComplete() {
        this.cancel();
        this.broadcastComplete();
    }

    protected InnerSubscriber<O, V> createSubscriber() {
        int newSize = this.innerSubscriptions.runningComposables + 1;
        this.capacity(newSize);
        if (newSize > this.toZip.length) {
            Object[] previousZip = this.toZip;
            this.toZip = new Object[newSize];
            System.arraycopy(previousZip, 0, this.toZip, 0, newSize - 1);
        }
        return new InnerSubscriber(this, this.index++);
    }

    @Override
    protected long initUpstreamPublisherAndCapacity() {
        long i = 0L;
        for (Publisher composable : this.publishers) {
            this.addPublisher(composable);
            ++i;
        }
        return i++;
    }

    @Override
    public String toString() {
        String formatted = super.toString();
        for (int i = 0; i < this.toZip.length; ++i) {
            if (this.toZip[i] == null) continue;
            formatted = formatted + "(" + i + "):" + this.toZip[i] + ",";
        }
        return formatted.substring(0, formatted.length());
    }

    public static final class Zippable<O> {
        final int index;
        final O data;

        public Zippable(int index, O data) {
            this.index = index;
            this.data = data;
        }
    }

    public static final class InnerSubscriber<O, V>
    extends FanInAction.InnerSubscriber<O, Zippable<O>, V> {
        final CombineLatestAction<O, V, ?> outerAction;
        final int index;

        InnerSubscriber(CombineLatestAction<O, V, ?> outerAction, int index) {
            super(outerAction);
            this.index = index;
            this.outerAction = outerAction;
        }

        public void onSubscribe(Subscription subscription) {
            this.setSubscription(new FanInSubscription.InnerSubscription(subscription, this));
            if (this.pendingRequests > 0L) {
                this.request(this.pendingRequests);
            }
            if (this.outerAction.dynamicMergeAction != null) {
                this.outerAction.dynamicMergeAction.decrementWip();
            }
        }

        public void onNext(O ev) {
            if (--this.pendingRequests > 0L) {
                this.pendingRequests = 0L;
            }
            this.outerAction.innerSubscriptions.serialNext(new Zippable<O>(this.index, ev));
        }

        @Override
        public boolean isReactivePull(Dispatcher dispatcher, long producerCapacity) {
            return false;
        }

        @Override
        public String toString() {
            return "CombineLatest.InnerSubscriber{index=" + this.index + ", " + "pending=" + this.pendingRequests + ", emitted=" + this.emittedSignals + "}";
        }
    }
}

