/*
 * Decompiled with CFR 0.152.
 */
package reactor.io.net.tcp;

import java.net.InetSocketAddress;
import reactor.Environment;
import reactor.core.Dispatcher;
import reactor.core.support.Assert;
import reactor.io.buffer.Buffer;
import reactor.io.codec.Codec;
import reactor.io.net.ChannelStream;
import reactor.io.net.ReactorPeer;
import reactor.io.net.config.ServerSocketOptions;
import reactor.io.net.config.SslOptions;

public abstract class TcpServer<IN, OUT>
extends ReactorPeer<IN, OUT, ChannelStream<IN, OUT>> {
    private final ServerSocketOptions options;
    private final SslOptions sslOptions;
    protected InetSocketAddress listenAddress;

    protected TcpServer(Environment env, Dispatcher dispatcher, InetSocketAddress listenAddress, ServerSocketOptions options, SslOptions sslOptions, Codec<Buffer, IN, OUT> codec) {
        super(env, dispatcher, codec, options.prefetch());
        this.listenAddress = listenAddress;
        Assert.notNull((Object)options, (String)"ServerSocketOptions cannot be null");
        this.options = options;
        this.sslOptions = sslOptions;
    }

    public InetSocketAddress getListenAddress() {
        return this.listenAddress;
    }

    protected ServerSocketOptions getOptions() {
        return this.options;
    }

    protected SslOptions getSslOptions() {
        return this.sslOptions;
    }
}

