/*
 * Decompiled with CFR 0.152.
 */
package reactor.io.net.http.model;

public enum Protocol {
    HTTP_1_0("http/1.0"),
    HTTP_1_1("http/1.1"),
    HTTP_2_0("h2-15");

    private final String protocol;

    private Protocol(String protocol) {
        this.protocol = protocol;
    }

    public static Protocol get(String protocol) {
        if (protocol.equals(Protocol.HTTP_1_0.protocol)) {
            return HTTP_1_0;
        }
        if (protocol.equals(Protocol.HTTP_1_1.protocol)) {
            return HTTP_1_1;
        }
        if (protocol.equals(Protocol.HTTP_2_0.protocol)) {
            return HTTP_2_0;
        }
        throw new IllegalArgumentException("Unexpected protocol: " + protocol);
    }

    public String toString() {
        return this.protocol;
    }
}

