/*
 * Decompiled with CFR 0.152.
 */
package reactor.test.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import reactor.core.Loopback;
import reactor.core.MultiProducer;
import reactor.core.MultiReceiver;
import reactor.core.Producer;
import reactor.core.Receiver;
import reactor.core.Trackable;
import reactor.core.publisher.GroupedFlux;

public abstract class StageUtils {
    public static Graph createGraph() {
        return StageUtils.createGraph(false);
    }

    public static Graph createGraph(boolean trace) {
        return new Graph(false, trace);
    }

    public static Graph scan(Object o) {
        return StageUtils.scan(o, false);
    }

    public static Graph scan(Object o, boolean trace) {
        if (o == null) {
            return null;
        }
        if (Graph.class.equals(o.getClass())) {
            return (Graph)o;
        }
        Graph graph = new Graph(false, trace);
        Node origin = graph.expandReactiveSate(o, null);
        graph.addUpstream(origin, null);
        graph.addDownstream(origin, null);
        return graph;
    }

    public static Graph subscan(Object o) {
        return StageUtils.subscan(o, false);
    }

    public static Graph subscan(Object o, boolean trace) {
        if (o == null) {
            return null;
        }
        if (Graph.class.equals(o.getClass())) {
            return (Graph)o;
        }
        Graph graph = new Graph(true, trace);
        Node root = graph.expandReactiveSate(o, null);
        graph.addDownstream(root, null);
        return graph;
    }

    public static String prettyPrint(Object o) {
        return StageUtils.print(o, true);
    }

    public static String print(Object o) {
        return StageUtils.print(o, false);
    }

    public static String print(Object o, boolean prettyPrint) {
        if (o == null) {
            return null;
        }
        Node n = new Node(StageUtils.getName(o), StageUtils.getIdOrDefault(o), o, null);
        if (prettyPrint) {
            return n.toJSON();
        }
        return n.toString();
    }

    public static boolean hasUpstream(Object o) {
        return StageUtils.reactiveStateCheck(o, Receiver.class) && ((Receiver)o).upstream() != null;
    }

    public static boolean hasUpstreams(Object o) {
        return StageUtils.reactiveStateCheck(o, MultiReceiver.class);
    }

    public static boolean hasDownstream(Object o) {
        return StageUtils.reactiveStateCheck(o, Producer.class) && ((Producer)o).downstream() != null;
    }

    public static boolean hasDownstreams(Object o) {
        return StageUtils.reactiveStateCheck(o, MultiProducer.class);
    }

    public static boolean hasFeedbackLoop(Object o) {
        return StageUtils.reactiveStateCheck(o, Loopback.class);
    }

    public static boolean hasSubscription(Object o) {
        return StageUtils.reactiveStateCheck(o, Trackable.class);
    }

    public static boolean isCancellable(Object o) {
        return StageUtils.reactiveStateCheck(o, Trackable.class);
    }

    public static boolean isContained(Object o) {
        return StageUtils.reactiveStateCheck(o, Trackable.class) && o.getClass().isMemberClass();
    }

    public static boolean isLogging(Object o) {
        return o != null && o.getClass().getSimpleName().contains("Log");
    }

    public static long getCapacity(Object o) {
        if (StageUtils.reactiveStateCheck(o, Trackable.class)) {
            return ((Trackable)o).getCapacity();
        }
        return -1L;
    }

    public static Throwable getFailedState(Object o) {
        if (StageUtils.reactiveStateCheck(o, Trackable.class)) {
            return ((Trackable)o).getError();
        }
        return null;
    }

    public static long getTimedPeriod(Object o) {
        if (StageUtils.reactiveStateCheck(o, Trackable.class)) {
            return ((Trackable)o).getPending();
        }
        return -1L;
    }

    public static long getUpstreamLimit(Object o) {
        if (StageUtils.reactiveStateCheck(o, Trackable.class)) {
            return ((Trackable)o).limit();
        }
        return -1L;
    }

    public static long getExpectedUpstream(Object o) {
        if (StageUtils.reactiveStateCheck(o, Trackable.class)) {
            return ((Trackable)o).expectedFromUpstream();
        }
        return -1L;
    }

    public static long getRequestedDownstream(Object o) {
        if (StageUtils.reactiveStateCheck(o, Trackable.class)) {
            return ((Trackable)o).requestedFromDownstream();
        }
        return -1L;
    }

    public static String getName(Object o) {
        if (o == null) {
            return null;
        }
        String name = o.toString();
        return (name = name.replaceAll("Flux|Mono|Subscriber", "")).isEmpty() ? "anonymous" : name;
    }

    public static String getGroup(Object o) {
        Object key;
        if (o == null) {
            return null;
        }
        Object object = key = GroupedFlux.class.isAssignableFrom(o.getClass()) ? ((GroupedFlux)o).key() : null;
        if (key == null) {
            return null;
        }
        return key.toString();
    }

    public static String getIdOrDefault(Object o) {
        return StageUtils.getName(o).hashCode() + ":" + o.hashCode();
    }

    public static boolean isFactory(Object o) {
        return o.getClass().getSuperclass().getSimpleName().contains("Flux") || o.getClass().getSuperclass().getSimpleName().contains("Mono");
    }

    public static long getBuffered(Object o) {
        if (StageUtils.reactiveStateCheck(o, Trackable.class)) {
            return ((Trackable)o).getPending();
        }
        return -1L;
    }

    private static boolean reactiveStateCheck(Object o, Class<?> clazz) {
        return o != null && clazz.isAssignableFrom(o.getClass());
    }

    public static String property(String name, Object value) {
        if (value == null || value.equals(-1) || value.equals(-1L)) {
            return "";
        }
        if (Number.class.isAssignableFrom(value.getClass())) {
            if (Long.MAX_VALUE == ((Number)value).longValue()) {
                return "\"" + name + "\" : \"unbounded\"";
            }
            return "\"" + name + "\" : " + value.toString();
        }
        if (Boolean.class.isAssignableFrom(value.getClass())) {
            return "\"" + name + "\" : " + value.toString();
        }
        return "\"" + name + "\" : " + (String.class.isAssignableFrom(value.getClass()) ? "\"" + value.toString().replaceAll("\"", "\\\"") + "\"" : value);
    }

    static void indent(String symbol, StringBuffer res, int indent, boolean comma) {
        if (symbol.isEmpty()) {
            return;
        }
        for (int i = 0; i < indent; ++i) {
            res.append("\t");
        }
        res.append(symbol);
        if (comma) {
            res.append(", ");
        }
        if (indent > -1) {
            res.append("\n");
        }
    }

    public static class Edge {
        private final String from;
        private final String to;
        private final Type type;

        protected Edge(String from, String to, Type type) {
            this.from = from;
            this.to = to;
            this.type = type;
        }

        public final String getFrom() {
            return this.from;
        }

        public final String getTo() {
            return this.to;
        }

        public final Type getType() {
            return this.type;
        }

        public final String getId() {
            return this.from + "_" + this.to;
        }

        public final boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Edge edge = (Edge)o;
            if (!this.from.equals(edge.from)) {
                return false;
            }
            return this.to.equals(edge.to);
        }

        public final int hashCode() {
            int result = this.from.hashCode();
            result = 31 * result + this.to.hashCode();
            return result;
        }

        public String toString() {
            return "{ " + StageUtils.property("id", this.getId()) + (this.type != null ? ", " + StageUtils.property("type", this.type.name()) : "") + ", " + StageUtils.property("from", this.from) + ", " + StageUtils.property("to", this.to) + " }";
        }

        public static enum Type {
            feedbackLoop,
            inner,
            reference;

        }
    }

    public static class Node
    implements Comparable<Node> {
        private final transient Object object;
        private transient Edge[] connectionsRef;
        private final String id;
        private final String name;
        private final String group;
        private final boolean unique;
        private final boolean factory;
        private final boolean inner;
        private final boolean logging;
        private final String rootId;

        protected Node(String name, String id, Object o, String rootId) {
            this.object = o;
            this.id = id;
            this.name = name;
            this.factory = StageUtils.isFactory(o);
            this.inner = StageUtils.isContained(o);
            this.group = StageUtils.getGroup(o);
            this.unique = false;
            this.rootId = rootId == null ? id : rootId;
            this.logging = StageUtils.isLogging(o);
        }

        private void addEdgeRef(Edge edge) {
            if (this.connectionsRef == null) {
                this.connectionsRef = new Edge[1];
                this.connectionsRef[0] = edge;
                return;
            }
            int n = this.connectionsRef.length;
            Edge[] b = new Edge[n + 1];
            System.arraycopy(this.connectionsRef, 0, b, 0, n);
            b[n] = edge;
            this.connectionsRef = b;
        }

        public final Object value() {
            return this.object;
        }

        public final String getId() {
            return this.id;
        }

        public final String getName() {
            return this.name;
        }

        public final String getGroup() {
            return this.group;
        }

        public final boolean isFactory() {
            return this.factory;
        }

        public final boolean isInner() {
            return this.inner;
        }

        public final boolean isLogging() {
            return this.logging;
        }

        public final boolean isReference() {
            return this.object == null;
        }

        public final boolean isDefinedId() {
            return this.unique;
        }

        public final long getCapacity() {
            return StageUtils.getCapacity(this.object);
        }

        public final long getBuffered() {
            return StageUtils.getBuffered(this.object);
        }

        public final long getUpstreamLimit() {
            return StageUtils.getUpstreamLimit(this.object);
        }

        public final long getPeriod() {
            return StageUtils.getTimedPeriod(this.object);
        }

        public final Throwable getFailedState() {
            return StageUtils.getFailedState(this.object);
        }

        public final long getExpectedUpstream() {
            return StageUtils.getExpectedUpstream(this.object);
        }

        public final long getRequestedDownstream() {
            return StageUtils.getRequestedDownstream(this.object);
        }

        public final Boolean isActive() {
            if (!StageUtils.hasSubscription(this.object)) {
                return null;
            }
            return ((Trackable)this.object).isStarted();
        }

        public final Boolean isTerminated() {
            if (!StageUtils.hasSubscription(this.object)) {
                return null;
            }
            return ((Trackable)this.object).isTerminated();
        }

        public final Boolean isCancelled() {
            if (!StageUtils.isCancellable(this.object)) {
                return null;
            }
            return ((Trackable)this.object).isCancelled();
        }

        protected final Edge createEdgeTo(Node to) {
            return this.createEdgeTo(to.id, null);
        }

        protected final Edge createEdgeTo(Node to, Edge.Type type) {
            return this.createEdgeTo(to.id, type);
        }

        protected final Edge createEdgeTo(String to, Edge.Type type) {
            Edge edge = new Edge(this.id, to, type);
            this.addEdgeRef(edge);
            return edge;
        }

        public final boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            Node node = (Node)o;
            return this.id.equals(node.id);
        }

        public final int hashCode() {
            return this.id.hashCode();
        }

        public String toString() {
            return this.toJSON(-1);
        }

        public String toJSON() {
            return this.toJSON(1);
        }

        public String toJSON(int indent) {
            int i = indent;
            StringBuffer res = new StringBuffer();
            StageUtils.indent("{", res, indent != -1 ? 0 : -1, false);
            StageUtils.indent(StageUtils.property("id", this.getId()), res, i, true);
            StageUtils.indent(StageUtils.property("origin", this.rootId), res, i, true);
            if (this.isDefinedId()) {
                StageUtils.indent(StageUtils.property("definedId", "true"), res, i, true);
            }
            StageUtils.indent(StageUtils.property("name", this.getName()), res, i, true);
            if (this.isInner()) {
                StageUtils.indent(StageUtils.property("inner", "true"), res, i, true);
            }
            if (this.isReference()) {
                StageUtils.indent(StageUtils.property("reference", "true"), res, i, true);
            } else {
                Boolean cancelled = this.isCancelled();
                if (this.getFailedState() != null) {
                    StageUtils.indent(StageUtils.property("failed", this.getFailedState().getMessage()), res, i, true);
                }
                StageUtils.indent(StageUtils.property("period", this.getPeriod()), res, i, true);
                StageUtils.indent(StageUtils.property("capacity", this.getCapacity()), res, i, true);
                StageUtils.indent(StageUtils.property("group", this.getGroup()), res, i, true);
                StageUtils.indent(StageUtils.property("buffered", this.getBuffered()), res, i, true);
                if (this.isFactory()) {
                    StageUtils.indent(StageUtils.property("factory", "true"), res, i, true);
                }
                if (this.isLogging()) {
                    StageUtils.indent(StageUtils.property("logging", "true"), res, i, true);
                }
                StageUtils.indent(StageUtils.property("upstreamLimit", this.getUpstreamLimit()), res, i, true);
                StageUtils.indent(StageUtils.property("expectedUpstream", this.getExpectedUpstream()), res, i, true);
                StageUtils.indent(StageUtils.property("requestedDownstream", this.getRequestedDownstream()), res, i, true);
                StageUtils.indent(StageUtils.property("active", this.isActive()), res, i, true);
                StageUtils.indent(StageUtils.property("terminated", this.isTerminated()), res, i, true);
                StageUtils.indent(StageUtils.property("cancelled", cancelled), res, i, false);
            }
            StageUtils.indent("}", res, indent != -1 ? 0 : -1, false);
            return res.toString();
        }

        @Override
        public int compareTo(Node o) {
            return this.name.compareTo(o.name);
        }
    }

    public static final class Graph {
        private final Map<String, Node> nodes = new HashMap<String, Node>();
        private final Map<String, Edge> edges = new WeakHashMap<String, Edge>();
        private final boolean subscan;
        private final boolean trace;
        private boolean cyclic;

        Graph() {
            this(false, false);
        }

        Graph(boolean subscan, boolean trace) {
            this.subscan = subscan;
            this.trace = trace;
        }

        public Graph mergeWith(Graph graph) {
            if (graph == null || graph.nodes.isEmpty() && graph.edges.isEmpty()) {
                return this;
            }
            this.nodes.putAll(graph.nodes);
            this.edges.putAll(graph.edges);
            return this;
        }

        public Collection<String> removeTerminatedNodes() {
            if (this.nodes.isEmpty()) {
                return null;
            }
            HashSet<String> removedGraph = new HashSet<String>();
            Iterator<Node> nodeIterator = this.nodes.values().iterator();
            while (nodeIterator.hasNext()) {
                Boolean bool1;
                boolean remove;
                Node node = nodeIterator.next();
                if (node.isReference()) {
                    remove = true;
                    for (Edge edge : node.connectionsRef) {
                        Node n = this.nodes.get(edge.from);
                        if (n == null) continue;
                        bool1 = n.isCancelled();
                        if (bool1 == null || !bool1.booleanValue()) {
                            remove = false;
                        } else {
                            bool1 = n.isTerminated();
                            if (bool1 != null && bool1.booleanValue()) continue;
                            remove = false;
                        }
                        break;
                    }
                } else {
                    bool1 = node.isTerminated();
                    boolean bl = remove = bool1 != null && bool1 != false;
                    if (!remove) {
                        bool1 = node.isCancelled();
                        boolean bl2 = remove = bool1 != null && bool1 != false;
                    }
                    if (!remove) {
                        boolean bl3 = remove = node.connectionsRef != null && node.connectionsRef.length == 0;
                    }
                }
                if (!remove) continue;
                nodeIterator.remove();
                removedGraph.add("\"" + node.getId() + "\"");
            }
            return removedGraph;
        }

        public Collection<Node> getNodes() {
            return this.nodes.values();
        }

        public Collection<Edge> getEdges() {
            return this.edges.values();
        }

        public boolean isCyclic() {
            return this.cyclic;
        }

        private void addUpstream(Node target, Node grandchild) {
            Object in;
            if (target == null) {
                return;
            }
            Node child = target;
            if (this.nodes.containsKey(child.getId()) && grandchild != null) {
                this.cyclic = true;
                return;
            }
            this.nodes.put(child.getId(), child);
            if (StageUtils.hasUpstream(target.object) && !this.virtualRef(in = ((Receiver)target.object).upstream(), target)) {
                Node upstream = this.expandReactiveSate(in, target.rootId);
                this.addEdge(upstream.createEdgeTo(child));
                this.addUpstream(upstream, child);
            }
            if (StageUtils.hasUpstreams(target.object)) {
                this.addUpstreams(child, ((MultiReceiver)target.object).upstreams());
            }
            if (StageUtils.hasDownstreams(target.object)) {
                this.addDownstreams(child, ((MultiProducer)target.object).downstreams());
            }
        }

        private void addUpstreams(Node target, Iterator o) {
            if (o == null) {
                return;
            }
            while (o.hasNext()) {
                Object in = o.next();
                if (this.virtualRef(in, target)) continue;
                Node source = this.expandReactiveSate(in, target != null ? target.rootId : null);
                if (target != null && source != null) {
                    this.addEdge(source.createEdgeTo(target, Edge.Type.inner));
                }
                this.addUpstream(source, target);
            }
        }

        private void addDownstream(Node origin, Node ancestor) {
            Object out;
            if (origin == null) {
                return;
            }
            Node root = origin;
            if (this.nodes.containsKey(root.getId()) && ancestor != null) {
                this.cyclic = true;
                return;
            }
            this.nodes.put(root.getId(), root);
            if (StageUtils.hasDownstream(origin.object) && !this.virtualRef(out = ((Producer)origin.object).downstream(), origin)) {
                Node downstream = this.expandReactiveSate(out, origin.rootId);
                if (root != null) {
                    this.addEdge(root.createEdgeTo(downstream));
                }
                this.addDownstream(downstream, root);
            }
            if (StageUtils.hasDownstreams(origin.object)) {
                this.addDownstreams(root, ((MultiProducer)origin.object).downstreams());
            }
            if (StageUtils.hasUpstreams(origin.object)) {
                this.addUpstreams(root, ((MultiReceiver)origin.object).upstreams());
            }
        }

        private void addDownstreams(Node source, Iterator o) {
            if (o == null) {
                return;
            }
            while (o.hasNext()) {
                Object out = o.next();
                if (this.virtualRef(out, source)) continue;
                Node downstream = this.expandReactiveSate(out, source != null ? source.rootId : null);
                if (source != null && downstream != null) {
                    this.addEdge(source.createEdgeTo(downstream, Edge.Type.inner));
                }
                this.addDownstream(downstream, source);
            }
        }

        private Node expandReactiveSate(Object o, String rootid) {
            if (o == null) {
                return null;
            }
            String name = StageUtils.getName(o);
            String id = StageUtils.getIdOrDefault(o);
            Node r = new Node(name, id, o, rootid);
            if (StageUtils.hasFeedbackLoop(o)) {
                Loopback loop = (Loopback)o;
                Object target = loop.connectedInput();
                if (target != null && target != loop && !this.virtualRef(target, r)) {
                    Node input = this.expandReactiveSate(target, r.rootId);
                    this.addEdge(r.createEdgeTo(input, Edge.Type.feedbackLoop));
                    this.addDownstream(input, null);
                }
                if ((target = loop.connectedOutput()) != null && target != loop && !this.virtualRef(target, r)) {
                    Node output = this.expandReactiveSate(target, r.rootId);
                    this.addEdge(output.createEdgeTo(r, Edge.Type.feedbackLoop));
                    this.addUpstream(output, null);
                }
            }
            return r;
        }

        private void addEdge(Edge edge) {
            this.edges.put(edge.getId(), edge);
        }

        private boolean virtualRef(Object o, Node ancestor) {
            if (o != null && ancestor != null && String.class.isAssignableFrom(o.getClass())) {
                Node virtualNode = new Node(o.toString(), o.toString(), null, ancestor.rootId);
                Edge edge = ancestor.createEdgeTo(o.toString(), Edge.Type.reference);
                virtualNode.addEdgeRef(edge);
                this.nodes.put(virtualNode.id, virtualNode);
                this.addEdge(edge);
                return true;
            }
            return false;
        }

        public String toString(boolean timestamp) {
            return "{ \"edges\" : " + this.edges.values() + (this.trace ? ", \"trace\" : true" : "") + ", \"nodes\" : " + this.nodes.values() + (this.subscan ? ", \"full\" : false" : "") + (timestamp ? ", \"timestamp\" : " + System.currentTimeMillis() : "") + '}';
        }

        public String toString() {
            return this.toString(true);
        }
    }
}

