/*
 * Decompiled with CFR 0.152.
 */
package reactor.test.scheduler;

import java.time.Duration;
import java.time.Instant;
import java.util.Queue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import reactor.core.Cancellation;
import reactor.core.Exceptions;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;
import reactor.core.scheduler.TimedScheduler;
import reactor.util.concurrent.QueueSupplier;

public class VirtualTimeScheduler
implements TimedScheduler {
    final boolean allScheduler;
    final Queue<TimedRunnable> queue = new PriorityBlockingQueue<TimedRunnable>(QueueSupplier.XS_BUFFER_SIZE);
    volatile long counter;
    volatile long nanoTime;
    volatile boolean shutdown;
    static final Cancellation CANCELLED = () -> {};
    static final Cancellation EMPTY = () -> {};
    static final AtomicReference<VirtualTimeScheduler> CURRENT = new AtomicReference();
    static final AtomicLongFieldUpdater<VirtualTimeScheduler> COUNTER = AtomicLongFieldUpdater.newUpdater(VirtualTimeScheduler.class, "counter");
    static final long CLOCK_DRIFT_TOLERANCE_NANOSECONDS = TimeUnit.MINUTES.toNanos(Long.getLong("reactor.scheduler.drift-tolerance", 15L));

    public static VirtualTimeScheduler create() {
        return new VirtualTimeScheduler(false);
    }

    public static VirtualTimeScheduler createForAll() {
        return new VirtualTimeScheduler(true);
    }

    public static VirtualTimeScheduler enable(boolean allSchedulers) {
        return VirtualTimeScheduler.enable(() -> new VirtualTimeScheduler(allSchedulers), allSchedulers);
    }

    public static VirtualTimeScheduler enable(VirtualTimeScheduler scheduler) {
        return VirtualTimeScheduler.enable(() -> scheduler, scheduler.isEnabledOnAllSchedulers());
    }

    static VirtualTimeScheduler enable(Supplier<VirtualTimeScheduler> schedulerSupplier, boolean allSchedulers) {
        VirtualTimeScheduler newS;
        while (true) {
            VirtualTimeScheduler s;
            if ((s = CURRENT.get()) != null && s.allScheduler == allSchedulers) {
                return s;
            }
            newS = schedulerSupplier.get();
            if (newS == CURRENT.get()) {
                return newS;
            }
            if (!CURRENT.compareAndSet(s, newS)) continue;
            if (!allSchedulers) {
                Schedulers.setFactory((Schedulers.Factory)new TimedOnlyFactory(newS));
            } else {
                Schedulers.setFactory((Schedulers.Factory)new AllFactory(newS));
            }
            if (CURRENT.get() == newS) break;
        }
        return newS;
    }

    public static VirtualTimeScheduler get() {
        VirtualTimeScheduler s = CURRENT.get();
        if (s == null) {
            throw new IllegalStateException("Check if VirtualTimeScheduler#enable has been invoked first: " + s);
        }
        return s;
    }

    public static void reset() {
        VirtualTimeScheduler s = CURRENT.get();
        if (s != null && CURRENT.compareAndSet(s, null)) {
            Schedulers.resetFactory();
        }
    }

    protected VirtualTimeScheduler(boolean allScheduler) {
        this.allScheduler = allScheduler;
    }

    public void advanceTime() {
        this.advanceTimeBy(Duration.ZERO);
    }

    public void advanceTimeBy(Duration delayTime) {
        this.advanceTime(this.nanoTime + delayTime.toNanos());
    }

    public void advanceTimeTo(Instant instant) {
        long targetTime = TimeUnit.NANOSECONDS.convert(instant.toEpochMilli(), TimeUnit.MILLISECONDS);
        this.advanceTime(targetTime);
    }

    public TimedScheduler.TimedWorker createWorker() {
        if (this.shutdown) {
            throw new IllegalStateException("VirtualTimeScheduler is shutdown");
        }
        return new VirtualTimeWorker();
    }

    public boolean isEnabledOnAllSchedulers() {
        return this.allScheduler;
    }

    public long now(TimeUnit unit) {
        return unit.convert(this.nanoTime, TimeUnit.NANOSECONDS);
    }

    public Cancellation schedule(Runnable task) {
        if (this.shutdown) {
            return REJECTED;
        }
        return this.createWorker().schedule(task);
    }

    public Cancellation schedule(Runnable task, long delay, TimeUnit unit) {
        if (this.shutdown) {
            return REJECTED;
        }
        return this.createWorker().schedule(task, delay, unit);
    }

    public void shutdown() {
        if (this.shutdown) {
            return;
        }
        this.queue.clear();
        this.shutdown = true;
        VirtualTimeScheduler s = CURRENT.get();
        if (s != null && s == this && CURRENT.compareAndSet(s, null)) {
            Schedulers.resetFactory();
        }
    }

    public Cancellation schedulePeriodically(Runnable task, long initialDelay, long period, TimeUnit unit) {
        if (this.shutdown) {
            return REJECTED;
        }
        TimedScheduler.TimedWorker w = this.createWorker();
        PeriodicDirectTask periodicTask = new PeriodicDirectTask(task, (Scheduler.Worker)w);
        w.schedulePeriodically((Runnable)periodicTask, initialDelay, period, unit);
        return periodicTask;
    }

    final void advanceTime(long targetTimeInNanoseconds) {
        while (!this.queue.isEmpty()) {
            TimedRunnable current = this.queue.peek();
            if (current.time > targetTimeInNanoseconds) break;
            this.nanoTime = current.time == 0L ? this.nanoTime : current.time;
            this.queue.remove();
            if (current.scheduler.shutdown) continue;
            current.run.run();
        }
        this.nanoTime = targetTimeInNanoseconds;
    }

    static boolean replace(AtomicReference<Cancellation> ref, Cancellation c) {
        Cancellation current;
        do {
            if ((current = ref.get()) != CANCELLED) continue;
            if (c != null) {
                c.dispose();
            }
            return false;
        } while (!ref.compareAndSet(current, c));
        return true;
    }

    static class PeriodicDirectTask
    implements Runnable,
    Cancellation {
        final Runnable run;
        final Scheduler.Worker worker;
        volatile boolean disposed;

        PeriodicDirectTask(Runnable run, Scheduler.Worker worker) {
            this.run = run;
            this.worker = worker;
        }

        @Override
        public void run() {
            if (!this.disposed) {
                try {
                    this.run.run();
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal((Throwable)ex);
                    this.worker.shutdown();
                    throw Exceptions.propagate((Throwable)ex);
                }
            }
        }

        public void dispose() {
            this.disposed = true;
            this.worker.shutdown();
        }
    }

    final class PeriodicTask
    extends AtomicReference<Cancellation>
    implements Runnable,
    Cancellation {
        final Runnable decoratedRun;
        final long periodInNanoseconds;
        long count;
        long lastNowNanoseconds;
        long startInNanoseconds;

        PeriodicTask(long firstStartInNanoseconds, Runnable decoratedRun, long firstNowNanoseconds, long periodInNanoseconds) {
            this.decoratedRun = decoratedRun;
            this.periodInNanoseconds = periodInNanoseconds;
            this.lastNowNanoseconds = firstNowNanoseconds;
            this.startInNanoseconds = firstStartInNanoseconds;
            this.lazySet(EMPTY);
        }

        @Override
        public void run() {
            this.decoratedRun.run();
            if (this.get() != CANCELLED) {
                long nextTick;
                long nowNanoseconds = VirtualTimeScheduler.this.now(TimeUnit.NANOSECONDS);
                if (nowNanoseconds + CLOCK_DRIFT_TOLERANCE_NANOSECONDS < this.lastNowNanoseconds || nowNanoseconds >= this.lastNowNanoseconds + this.periodInNanoseconds + CLOCK_DRIFT_TOLERANCE_NANOSECONDS) {
                    nextTick = nowNanoseconds + this.periodInNanoseconds;
                    this.startInNanoseconds = nextTick - this.periodInNanoseconds * ++this.count;
                } else {
                    nextTick = this.startInNanoseconds + ++this.count * this.periodInNanoseconds;
                }
                this.lastNowNanoseconds = nowNanoseconds;
                long delay = nextTick - nowNanoseconds;
                VirtualTimeScheduler.replace(this, VirtualTimeScheduler.this.schedule(this, delay, TimeUnit.NANOSECONDS));
            }
        }

        public void dispose() {
            this.getAndSet(CANCELLED).dispose();
        }
    }

    final class VirtualTimeWorker
    implements TimedScheduler.TimedWorker {
        volatile boolean shutdown;

        VirtualTimeWorker() {
        }

        public long now(TimeUnit unit) {
            return VirtualTimeScheduler.this.now(unit);
        }

        public Cancellation schedule(Runnable run) {
            if (this.shutdown) {
                return Scheduler.REJECTED;
            }
            TimedRunnable timedTask = new TimedRunnable(this, 0L, run, COUNTER.getAndIncrement(VirtualTimeScheduler.this));
            VirtualTimeScheduler.this.queue.add(timedTask);
            return () -> VirtualTimeScheduler.this.queue.remove(timedTask);
        }

        public Cancellation schedule(Runnable run, long delayTime, TimeUnit unit) {
            if (this.shutdown) {
                return Scheduler.REJECTED;
            }
            TimedRunnable timedTask = new TimedRunnable(this, VirtualTimeScheduler.this.nanoTime + unit.toNanos(delayTime), run, COUNTER.getAndIncrement(VirtualTimeScheduler.this));
            VirtualTimeScheduler.this.queue.add(timedTask);
            return () -> VirtualTimeScheduler.this.queue.remove(timedTask);
        }

        public Cancellation schedulePeriodically(Runnable task, long initialDelay, long period, TimeUnit unit) {
            long periodInNanoseconds = unit.toNanos(period);
            long firstNowNanoseconds = this.now(TimeUnit.NANOSECONDS);
            long firstStartInNanoseconds = firstNowNanoseconds + unit.toNanos(initialDelay);
            PeriodicTask periodicTask = new PeriodicTask(firstStartInNanoseconds, task, firstNowNanoseconds, periodInNanoseconds);
            VirtualTimeScheduler.replace(periodicTask, this.schedule(periodicTask, initialDelay, unit));
            return periodicTask;
        }

        public void shutdown() {
            this.shutdown = true;
        }
    }

    static final class AllFactory
    implements Schedulers.Factory {
        final VirtualTimeScheduler s;

        public AllFactory(VirtualTimeScheduler s) {
            this.s = s;
        }

        public Scheduler newElastic(int ttlSeconds, ThreadFactory threadFactory) {
            return this.s;
        }

        public Scheduler newParallel(int parallelism, ThreadFactory threadFactory) {
            return this.s;
        }

        public Scheduler newSingle(ThreadFactory threadFactory) {
            return this.s;
        }

        public TimedScheduler newTimer(ThreadFactory threadFactory) {
            return this.s;
        }
    }

    static final class TimedOnlyFactory
    implements Schedulers.Factory {
        final VirtualTimeScheduler s;

        public TimedOnlyFactory(VirtualTimeScheduler s) {
            this.s = s;
        }

        public TimedScheduler newTimer(ThreadFactory threadFactory) {
            return this.s;
        }
    }

    static final class TimedRunnable
    implements Comparable<TimedRunnable> {
        final long time;
        final Runnable run;
        final VirtualTimeWorker scheduler;
        final long count;

        TimedRunnable(VirtualTimeWorker scheduler, long time, Runnable run, long count) {
            this.time = time;
            this.run = run;
            this.scheduler = scheduler;
            this.count = count;
        }

        @Override
        public int compareTo(TimedRunnable o) {
            if (this.time == o.time) {
                return TimedRunnable.compare(this.count, o.count);
            }
            return TimedRunnable.compare(this.time, o.time);
        }

        static int compare(long a, long b) {
            return a < b ? -1 : (a > b ? 1 : 0);
        }
    }
}

