/*
 * Decompiled with CFR 0.152.
 */
package reactor.test;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Exceptions;
import reactor.core.Fuseable;
import reactor.core.Receiver;
import reactor.core.Trackable;
import reactor.core.publisher.Operators;
import reactor.core.publisher.Signal;
import reactor.test.StepVerifier;
import reactor.test.scheduler.VirtualTimeScheduler;

final class DefaultStepVerifierBuilder<T>
implements StepVerifier.FirstStep<T> {
    final List<Event<T>> script;
    final long initialRequest;
    final Supplier<? extends VirtualTimeScheduler> vtsLookup;
    final Supplier<? extends Publisher<? extends T>> sourceSupplier;
    int requestedFusionMode = -1;
    int expectedFusionMode = -1;
    static final SignalEvent DEFAULT_ONSUBSCRIBE_STEP = DefaultStepVerifierBuilder.newOnSubscribeStep();
    static final int NO_FUSION_SUPPORT = Integer.MIN_VALUE;
    static final AtomicReferenceFieldUpdater<DefaultVerifySubscriber, Throwable> ERRORS = AtomicReferenceFieldUpdater.newUpdater(DefaultVerifySubscriber.class, Throwable.class, "errors");
    static final AtomicIntegerFieldUpdater<DefaultVerifySubscriber> WIP = AtomicIntegerFieldUpdater.newUpdater(DefaultVerifySubscriber.class, "wip");
    static final Optional<AssertionError> EXPECT_MORE = Optional.ofNullable(null);

    static void checkPositive(long n) {
        if (n < 0L) {
            throw new IllegalArgumentException("'n' should be >= 0 but was " + n);
        }
    }

    static void checkStrictlyPositive(long n) {
        if (n <= 0L) {
            throw new IllegalArgumentException("'n' should be > 0 but was " + n);
        }
    }

    static <T> StepVerifier.FirstStep<T> newVerifier(long n, Supplier<? extends Publisher<? extends T>> scenarioSupplier, Supplier<? extends VirtualTimeScheduler> vtsLookup) {
        DefaultStepVerifierBuilder.checkPositive(n);
        Objects.requireNonNull(scenarioSupplier, "scenarioSupplier");
        return new DefaultStepVerifierBuilder<T>(n, scenarioSupplier, vtsLookup);
    }

    static <T> SignalEvent<T> defaultFirstStep() {
        return DEFAULT_ONSUBSCRIBE_STEP;
    }

    DefaultStepVerifierBuilder(long initialRequest, Supplier<? extends Publisher<? extends T>> sourceSupplier, Supplier<? extends VirtualTimeScheduler> vtsLookup) {
        this.initialRequest = initialRequest;
        this.vtsLookup = vtsLookup;
        this.sourceSupplier = sourceSupplier;
        this.script = new ArrayList<Event<T>>();
        this.script.add(DefaultStepVerifierBuilder.defaultFirstStep());
    }

    @Override
    public DefaultStepVerifier<T> consumeErrorWith(Consumer<Throwable> consumer) {
        Objects.requireNonNull(consumer, "consumer");
        SignalEvent event = new SignalEvent(signal -> {
            if (!signal.isOnError()) {
                return DefaultStepVerifierBuilder.fail("expected: onError(); actual: %s", signal);
            }
            consumer.accept(signal.getThrowable());
            return Optional.empty();
        });
        this.script.add(event);
        return this.build();
    }

    @Override
    public DefaultStepVerifierBuilder<T> consumeNextWith(Consumer<? super T> consumer) {
        Objects.requireNonNull(consumer, "consumer");
        SignalEvent event = new SignalEvent(signal -> {
            if (!signal.isOnNext()) {
                return DefaultStepVerifierBuilder.fail("expected: onNext(); actual: %s", signal);
            }
            consumer.accept(signal.get());
            return Optional.empty();
        });
        this.script.add(event);
        return this;
    }

    @Override
    public DefaultStepVerifierBuilder<T> consumeRecordedWith(Consumer<? super Collection<T>> consumer) {
        Objects.requireNonNull(consumer, "consumer");
        this.script.add(new CollectEvent(consumer));
        return this;
    }

    @Override
    public DefaultStepVerifierBuilder<T> consumeSubscriptionWith(Consumer<? super Subscription> consumer) {
        Objects.requireNonNull(consumer, "consumer");
        this.script.set(0, new SignalEvent(signal -> {
            if (!signal.isOnSubscribe()) {
                return DefaultStepVerifierBuilder.fail("expected: onSubscribe(); actual: %s", signal);
            }
            consumer.accept(signal.getSubscription());
            return Optional.empty();
        }));
        return this;
    }

    @Override
    public DefaultStepVerifier<T> expectComplete() {
        SignalEvent event = new SignalEvent(signal -> {
            if (!signal.isOnComplete()) {
                return DefaultStepVerifierBuilder.fail("expected: onComplete(); actual: %s", signal);
            }
            return Optional.empty();
        });
        this.script.add(event);
        return this.build();
    }

    @Override
    public DefaultStepVerifier<T> expectError() {
        SignalEvent event = new SignalEvent(signal -> {
            if (!signal.isOnError()) {
                return DefaultStepVerifierBuilder.fail("expected: onError(); actual: %s", signal);
            }
            return Optional.empty();
        });
        this.script.add(event);
        return this.build();
    }

    @Override
    public DefaultStepVerifier<T> expectError(Class<? extends Throwable> clazz) {
        Objects.requireNonNull(clazz, "clazz");
        SignalEvent event = new SignalEvent(signal -> {
            if (!signal.isOnError()) {
                return DefaultStepVerifierBuilder.fail("expected: onError(%s); actual: %s", clazz.getSimpleName(), signal);
            }
            if (!clazz.isInstance(signal.getThrowable())) {
                return DefaultStepVerifierBuilder.fail("expected error of type: %s; actual type: %s", clazz.getSimpleName(), signal.getThrowable());
            }
            return Optional.empty();
        });
        this.script.add(event);
        return this.build();
    }

    @Override
    public DefaultStepVerifier<T> expectErrorMessage(String errorMessage) {
        SignalEvent event = new SignalEvent(signal -> {
            if (!signal.isOnError()) {
                return DefaultStepVerifierBuilder.fail("expected: onError(\"%s\"); actual: %s", errorMessage, signal);
            }
            if (!Objects.equals(errorMessage, signal.getThrowable().getMessage())) {
                return DefaultStepVerifierBuilder.fail("expected error message: \"%s\"; actual message: %s", errorMessage, signal.getThrowable().getMessage());
            }
            return Optional.empty();
        });
        this.script.add(event);
        return this.build();
    }

    @Override
    public DefaultStepVerifier<T> expectErrorMatches(Predicate<Throwable> predicate) {
        Objects.requireNonNull(predicate, "predicate");
        SignalEvent event = new SignalEvent(signal -> {
            if (!signal.isOnError()) {
                return DefaultStepVerifierBuilder.fail("expected: onError(); actual: %s", signal);
            }
            if (!predicate.test(signal.getThrowable())) {
                return DefaultStepVerifierBuilder.fail("predicate failed on exception: %s", signal.getThrowable());
            }
            return Optional.empty();
        });
        this.script.add(event);
        return this.build();
    }

    @Override
    public DefaultStepVerifierBuilder<T> expectNoFusionSupport() {
        this.requestedFusionMode = Integer.MIN_VALUE;
        return this;
    }

    @Override
    public DefaultStepVerifierBuilder<T> expectFusion() {
        return this.expectFusion(3, 3);
    }

    @Override
    public DefaultStepVerifierBuilder<T> expectFusion(int requested) {
        return this.expectFusion(requested, requested);
    }

    @Override
    public DefaultStepVerifierBuilder<T> expectFusion(int requested, int expected) {
        DefaultStepVerifierBuilder.checkPositive(requested);
        DefaultStepVerifierBuilder.checkPositive(expected);
        this.requestedFusionMode = requested;
        this.expectedFusionMode = expected;
        return this;
    }

    @Override
    @SafeVarargs
    public final DefaultStepVerifierBuilder<T> expectNext(T ... ts) {
        Objects.requireNonNull(ts, "ts");
        for (Object t : ts) {
            SignalEvent event = new SignalEvent(signal -> {
                if (!signal.isOnNext()) {
                    return DefaultStepVerifierBuilder.fail("expected: onNext(%s); actual: %s", t, signal);
                }
                if (!Objects.equals(t, signal.get())) {
                    return DefaultStepVerifierBuilder.fail("expected value: %s; actual value: %s", t, signal.get());
                }
                return Optional.empty();
            });
            this.script.add(event);
        }
        return this;
    }

    @Override
    public DefaultStepVerifierBuilder<T> expectNextSequence(Iterable<? extends T> iterable) {
        Objects.requireNonNull(iterable, "iterable");
        this.script.add(new SignalSequenceEvent<T>(iterable));
        return this;
    }

    @Override
    public DefaultStepVerifierBuilder<T> expectNextCount(long count) {
        DefaultStepVerifierBuilder.checkPositive(count);
        this.script.add(new SignalCountEvent(count));
        return this;
    }

    @Override
    public DefaultStepVerifierBuilder<T> expectNextMatches(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate");
        SignalEvent event = new SignalEvent(signal -> {
            if (!signal.isOnNext()) {
                return DefaultStepVerifierBuilder.fail("expected: onNext(); actual: %s", signal);
            }
            if (!predicate.test(signal.get())) {
                return DefaultStepVerifierBuilder.fail("predicate failed on value: %s", signal.get());
            }
            return Optional.empty();
        });
        this.script.add(event);
        return this;
    }

    @Override
    public DefaultStepVerifierBuilder<T> expectRecordedMatches(Predicate<? super Collection<T>> predicate) {
        Objects.requireNonNull(predicate, "predicate");
        this.script.add(new CollectEvent(predicate));
        return this;
    }

    @Override
    public DefaultStepVerifierBuilder<T> expectSubscription() {
        if (this.script.get(0) instanceof NoEvent) {
            this.script.add(DefaultStepVerifierBuilder.defaultFirstStep());
        } else {
            this.script.set(0, DefaultStepVerifierBuilder.newOnSubscribeStep());
        }
        return this;
    }

    @Override
    public DefaultStepVerifierBuilder<T> expectSubscriptionMatches(Predicate<? super Subscription> predicate) {
        Objects.requireNonNull(predicate, "predicate");
        this.script.set(0, new SignalEvent(signal -> {
            if (!signal.isOnSubscribe()) {
                return DefaultStepVerifierBuilder.fail("expected: onSubscribe(); actual: %s", signal);
            }
            if (!predicate.test(signal.getSubscription())) {
                return DefaultStepVerifierBuilder.fail("predicate failed on subscription: %s", signal.getSubscription());
            }
            return Optional.empty();
        }));
        return this;
    }

    @Override
    public DefaultStepVerifierBuilder<T> expectNoEvent(Duration duration) {
        Objects.requireNonNull(duration, "duration");
        if (this.script.size() == 1 && this.script.get(0) == DefaultStepVerifierBuilder.defaultFirstStep()) {
            this.script.set(0, new NoEvent(duration));
        } else {
            this.script.add(new NoEvent(duration));
        }
        return this;
    }

    @Override
    public DefaultStepVerifierBuilder<T> recordWith(Supplier<? extends Collection<T>> supplier) {
        Objects.requireNonNull(supplier, "supplier");
        this.script.add(new CollectEvent(supplier));
        return this;
    }

    @Override
    public DefaultStepVerifierBuilder<T> then(Runnable task) {
        Objects.requireNonNull(task, "task");
        this.script.add(new TaskEvent(task));
        return this;
    }

    @Override
    public DefaultStepVerifier<T> thenCancel() {
        this.script.add(new SubscriptionEvent());
        return this.build();
    }

    @Override
    public DefaultStepVerifierBuilder<T> thenRequest(long n) {
        DefaultStepVerifierBuilder.checkStrictlyPositive(n);
        this.script.add(new SubscriptionEvent(subscription -> subscription.request(n)));
        return this;
    }

    @Override
    public DefaultStepVerifierBuilder<T> thenAwait() {
        return this.thenAwait(Duration.ZERO);
    }

    @Override
    public DefaultStepVerifierBuilder<T> thenAwait(Duration timeshift) {
        Objects.requireNonNull(timeshift, "timeshift");
        this.script.add(new WaitEvent(timeshift));
        return this;
    }

    final DefaultStepVerifier<T> build() {
        return new DefaultStepVerifier(this);
    }

    static void virtualOrRealWait(Duration duration, DefaultVerifySubscriber<?> s) throws Exception {
        if (s.virtualTimeScheduler == null) {
            s.completeLatch.await(duration.toMillis(), TimeUnit.MILLISECONDS);
        } else {
            s.virtualTimeScheduler.advanceTimeBy(duration);
        }
    }

    static Optional<AssertionError> fail(String msg, Object ... args) {
        return Optional.of(new AssertionError((Object)String.format(msg, args)));
    }

    static String formatFusionMode(int m) {
        switch (m) {
            case 3: {
                return "(any)";
            }
            case 1: {
                return "(sync)";
            }
            case 2: {
                return "(async)";
            }
            case 0: {
                return "none";
            }
            case 4: {
                return "(thread-barrier)";
            }
        }
        return "" + m;
    }

    static <T> SignalEvent<T> newOnSubscribeStep() {
        return new SignalEvent(signal -> {
            if (!signal.isOnSubscribe()) {
                return DefaultStepVerifierBuilder.fail("expected: onSubscribe(); actual: %s", signal);
            }
            return Optional.empty();
        });
    }

    static final class SignalSequenceEvent<T>
    implements Event<T> {
        final Iterable<? extends T> iterable;

        SignalSequenceEvent(Iterable<? extends T> iterable) {
            this.iterable = iterable;
        }

        Optional<AssertionError> test(Signal<T> signal, Iterator<? extends T> iterator) {
            if (signal.isOnNext()) {
                if (!iterator.hasNext()) {
                    return DefaultStepVerifierBuilder.fail("unexpected iterator request; onNext(%s); iterable: %s", signal.get(), this.iterable);
                }
                T d2 = iterator.next();
                if (!Objects.equals(signal.get(), d2)) {
                    return DefaultStepVerifierBuilder.fail("expected : onNext(%s); actual: %s; iterable: %s", d2, signal.get(), this.iterable);
                }
                return iterator.hasNext() ? EXPECT_MORE : Optional.empty();
            }
            if (iterator != null && iterator.hasNext() || signal.isOnError()) {
                return DefaultStepVerifierBuilder.fail("expected next value: %s; actual actual signal: %s; iterable: %s", iterator != null && iterator.hasNext() ? iterator.next() : "none", signal, this.iterable);
            }
            return Optional.empty();
        }
    }

    static final class SubscriptionTaskEvent<T>
    extends TaskEvent<T> {
        final SubscriptionEvent<T> delegate;

        SubscriptionTaskEvent(SubscriptionEvent<T> subscriptionEvent) {
            super(null);
            this.delegate = subscriptionEvent;
        }

        @Override
        void run(DefaultVerifySubscriber<T> parent) throws Exception {
            if (this.delegate.isTerminal()) {
                parent.doCancel();
            } else {
                this.delegate.consume(parent.upstream());
            }
        }
    }

    static final class WaitEvent<T>
    extends TaskEvent<T> {
        final Duration duration;

        WaitEvent(Duration duration) {
            super(null);
            this.duration = duration;
        }

        @Override
        void run(DefaultVerifySubscriber<T> s) throws Exception {
            DefaultStepVerifierBuilder.virtualOrRealWait(this.duration, s);
        }
    }

    static final class NoEvent<T>
    extends TaskEvent<T> {
        final Duration duration;

        NoEvent(Duration duration) {
            super(null);
            this.duration = duration;
        }

        @Override
        void run(DefaultVerifySubscriber<T> parent) throws Exception {
            if (parent.virtualTimeScheduler != null) {
                parent.monitorSignal = true;
                DefaultStepVerifierBuilder.virtualOrRealWait(this.duration.minus(Duration.ofNanos(1L)), parent);
                parent.monitorSignal = false;
                if (parent.isTerminated() && !parent.isCancelled()) {
                    throw new AssertionError((Object)"unexpected end during a no-event expectation");
                }
                DefaultStepVerifierBuilder.virtualOrRealWait(Duration.ofNanos(1L), parent);
            } else {
                parent.monitorSignal = true;
                DefaultStepVerifierBuilder.virtualOrRealWait(this.duration, parent);
                parent.monitorSignal = false;
                if (parent.isTerminated() && !parent.isCancelled()) {
                    throw new AssertionError((Object)"unexpected end during a no-event expectation");
                }
            }
        }
    }

    static class TaskEvent<T>
    implements EagerEvent<T> {
        final Runnable task;

        TaskEvent(Runnable task) {
            this.task = task;
        }

        void run(DefaultVerifySubscriber<T> parent) throws Exception {
            this.task.run();
        }
    }

    static final class CollectEvent<T>
    implements EagerEvent<T> {
        final Supplier<? extends Collection<T>> supplier;
        final Predicate<? super Collection<T>> predicate;
        final Consumer<? super Collection<T>> consumer;

        CollectEvent(Supplier<? extends Collection<T>> supplier) {
            this.supplier = supplier;
            this.predicate = null;
            this.consumer = null;
        }

        CollectEvent(Consumer<? super Collection<T>> consumer) {
            this.supplier = null;
            this.predicate = null;
            this.consumer = consumer;
        }

        CollectEvent(Predicate<? super Collection<T>> predicate) {
            this.supplier = null;
            this.predicate = predicate;
            this.consumer = null;
        }

        Collection<T> get() {
            return this.supplier != null ? this.supplier.get() : null;
        }

        Optional<AssertionError> test(Collection<T> collection) {
            if (this.predicate != null) {
                if (!this.predicate.test(collection)) {
                    return DefaultStepVerifierBuilder.fail("expected collection predicate match; actual: %s", collection);
                }
                return Optional.empty();
            }
            if (this.consumer != null) {
                this.consumer.accept(collection);
            }
            return Optional.empty();
        }
    }

    static final class SignalCountEvent<T>
    implements Event<T> {
        final long count;

        SignalCountEvent(long count) {
            this.count = count;
        }
    }

    static final class SignalEvent<T>
    implements Event<T> {
        final Function<Signal<T>, Optional<AssertionError>> function;

        SignalEvent(Function<Signal<T>, Optional<AssertionError>> function) {
            this.function = function;
        }

        Optional<AssertionError> test(Signal<T> signal) {
            return this.function.apply(signal);
        }
    }

    static final class SubscriptionEvent<T>
    implements EagerEvent<T> {
        final Consumer<Subscription> consumer;

        SubscriptionEvent() {
            this(null);
        }

        SubscriptionEvent(Consumer<Subscription> consumer) {
            this.consumer = consumer;
        }

        void consume(Subscription subscription) {
            if (this.consumer != null) {
                this.consumer.accept(subscription);
            }
        }

        boolean isTerminal() {
            return this.consumer == null;
        }
    }

    static interface EagerEvent<T>
    extends Event<T> {
    }

    static final class DefaultVerifySubscriber<T>
    implements StepVerifier,
    Subscriber<T>,
    Trackable,
    Receiver {
        final AtomicReference<Subscription> subscription;
        final CountDownLatch completeLatch;
        final Queue<Event<T>> script;
        final Queue<TaskEvent<T>> taskEvents;
        final int requestedFusionMode;
        final int expectedFusionMode;
        final long initialRequest;
        final VirtualTimeScheduler virtualTimeScheduler;
        int establishedFusionMode;
        Fuseable.QueueSubscription<T> qs;
        long produced;
        Iterator<? extends T> currentNextAs;
        Collection<T> currentCollector;
        volatile int wip;
        volatile Throwable errors;
        volatile boolean monitorSignal;

        DefaultVerifySubscriber(List<Event<T>> script, long initialRequest, int requestedFusionMode, int expectedFusionMode, VirtualTimeScheduler vts) {
            Event<T> event;
            this.virtualTimeScheduler = vts;
            this.requestedFusionMode = requestedFusionMode;
            this.expectedFusionMode = expectedFusionMode;
            this.initialRequest = initialRequest;
            this.script = DefaultVerifySubscriber.conflateScript(script);
            this.taskEvents = new ConcurrentLinkedQueue<TaskEvent<T>>();
            while ((event = this.script.peek()) instanceof TaskEvent) {
                this.taskEvents.add((TaskEvent)this.script.poll());
            }
            this.monitorSignal = this.taskEvents.peek() instanceof NoEvent;
            this.produced = 0L;
            this.completeLatch = new CountDownLatch(1);
            this.subscription = new AtomicReference();
        }

        static <R> Queue<Event<R>> conflateScript(List<Event<R>> script) {
            Event<R> event;
            ConcurrentLinkedQueue<Event<R>> queue = new ConcurrentLinkedQueue<Event<R>>(script);
            ConcurrentLinkedQueue<Event<R>> conflated = new ConcurrentLinkedQueue<Event<R>>();
            while ((event = queue.peek()) != null) {
                if (event instanceof TaskEvent) {
                    conflated.add(queue.poll());
                    while (queue.peek() instanceof SubscriptionEvent) {
                        conflated.add(new SubscriptionTaskEvent((SubscriptionEvent)queue.poll()));
                    }
                    continue;
                }
                conflated.add(queue.poll());
            }
            return conflated;
        }

        public VirtualTimeScheduler virtualTimeScheduler() {
            return this.virtualTimeScheduler;
        }

        public Throwable getError() {
            return this.errors;
        }

        public boolean isCancelled() {
            return this.upstream() == Operators.cancelledSubscription();
        }

        public boolean isStarted() {
            return this.upstream() != null;
        }

        public boolean isTerminated() {
            return this.completeLatch.getCount() == 0L;
        }

        public void onComplete() {
            this.onExpectation(Signal.complete());
            this.completeLatch.countDown();
        }

        public void onError(Throwable t) {
            this.onExpectation(Signal.error((Throwable)t));
            this.completeLatch.countDown();
        }

        public void onNext(T t) {
            block7: {
                if (this.establishedFusionMode == 2) {
                    while (true) {
                        block6: {
                            try {
                                t = this.qs.poll();
                                if (t != null) break block6;
                                break block7;
                            }
                            catch (Throwable e) {
                                Exceptions.throwIfFatal((Throwable)e);
                                this.onExpectation(Signal.error((Throwable)e));
                                this.cancel();
                                this.completeLatch.countDown();
                                return;
                            }
                        }
                        ++this.produced;
                        if (this.currentCollector != null) {
                            this.currentCollector.add(t);
                        }
                        this.onExpectation(Signal.next(t));
                    }
                }
                ++this.produced;
                if (this.currentCollector != null) {
                    this.currentCollector.add(t);
                }
                this.onExpectation(Signal.next(t));
            }
        }

        public void onSubscribe(Subscription subscription) {
            if (subscription == null) {
                throw Exceptions.argumentIsNullException();
            }
            if (this.subscription.compareAndSet(null, subscription)) {
                this.onExpectation(Signal.subscribe((Subscription)subscription));
                if (this.requestedFusionMode == Integer.MIN_VALUE && subscription instanceof Fuseable.QueueSubscription) {
                    this.setFailure("unexpected fusion support: %s", subscription);
                } else if (this.requestedFusionMode >= 0) {
                    this.startFusion(subscription);
                } else if (this.initialRequest != 0L) {
                    subscription.request(this.initialRequest);
                }
            } else {
                subscription.cancel();
                if (this.isCancelled()) {
                    this.setFailure("an unexpected Subscription has been received: %s; actual: cancelled", subscription);
                } else {
                    this.setFailure("an unexpected Subscription has been received: %s; actual: ", subscription, this.subscription);
                }
            }
        }

        public Subscription upstream() {
            return this.subscription.get();
        }

        @Override
        public Duration verify() {
            return this.verify(Duration.ZERO);
        }

        @Override
        public Duration verify(Duration duration) {
            Objects.requireNonNull(duration, "duration");
            Instant now = Instant.now();
            try {
                this.pollTaskEventOrComplete(duration);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
            this.validate();
            return Duration.between(now, Instant.now());
        }

        final void setFailure(String msg, Object ... arguments) {
            Exceptions.addThrowable(ERRORS, (Object)this, (Throwable)((Throwable)((Object)DefaultStepVerifierBuilder.fail(msg, arguments).get())));
            this.cancel();
            this.completeLatch.countDown();
        }

        final Subscription cancel() {
            Subscription s = this.subscription.getAndSet(Operators.cancelledSubscription());
            if (s != null && s != Operators.cancelledSubscription()) {
                s.cancel();
            }
            return s;
        }

        final Optional<AssertionError> checkCountMismatch(long expected, Signal<T> s) {
            if (!s.isOnNext()) {
                return DefaultStepVerifierBuilder.fail("expected: count = %s; actual: produced = %s; signal: %s", expected, this.produced, s);
            }
            return Optional.empty();
        }

        boolean onCollect() {
            CollectEvent collectEvent = (CollectEvent)this.script.poll();
            if (collectEvent.supplier != null) {
                Collection c = collectEvent.get();
                this.currentCollector = c;
                if (c == null) {
                    this.setFailure("expected collection; actual supplied is [null]", new Object[0]);
                }
                return true;
            }
            Collection<T> c = this.currentCollector;
            if (c == null) {
                this.setFailure("expected record collector; actual record is [null]", new Object[0]);
                return true;
            }
            Optional<AssertionError> error = collectEvent.test(c);
            if (error.isPresent()) {
                Exceptions.addThrowable(ERRORS, (Object)this, (Throwable)((Throwable)((Object)error.get())));
                this.cancel();
                this.completeLatch.countDown();
                return true;
            }
            return true;
        }

        final void onExpectation(Signal<T> actualSignal) {
            if (this.monitorSignal) {
                this.setFailure("expected no event: %s", actualSignal);
                return;
            }
            try {
                Event<T> event = this.script.peek();
                if (event == null) {
                    this.setFailure("did not expect: %s", actualSignal);
                    return;
                }
                this.onTaskEvent();
                if (event instanceof SignalCountEvent ? this.onSignalCount(actualSignal, (SignalCountEvent)event) : (event instanceof CollectEvent ? this.onCollect() : (event instanceof SignalSequenceEvent ? this.onSignalSequence(actualSignal, (SignalSequenceEvent)event) : event instanceof SignalEvent && this.onSignal(actualSignal)))) {
                    return;
                }
                event = this.script.peek();
                if (event == null || !(event instanceof EagerEvent)) {
                    return;
                }
                while (event != null && event instanceof EagerEvent) {
                    if (event instanceof SubscriptionEvent) {
                        if (this.onSubscription()) {
                            return;
                        }
                    } else if (event instanceof CollectEvent) {
                        if (this.onCollect()) {
                            return;
                        }
                    } else {
                        this.onTaskEvent();
                    }
                    event = this.script.peek();
                }
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal((Throwable)e);
                if (e instanceof AssertionError) {
                    Exceptions.addThrowable(ERRORS, (Object)this, (Throwable)e);
                } else {
                    String msg = e.getMessage() != null ? e.getMessage() : "";
                    Exceptions.addThrowable(ERRORS, (Object)this, (Throwable)((Throwable)((Object)DefaultStepVerifierBuilder.fail("failed running expectation on signal [%s] with [%s]:\n%s", Exceptions.unwrap((Throwable)e).getClass().getName(), msg).get())));
                }
                this.cancel();
                this.completeLatch.countDown();
            }
        }

        boolean onSignal(Signal<T> actualSignal) {
            SignalEvent signalEvent = (SignalEvent)this.script.poll();
            Optional<AssertionError> error = signalEvent.test(actualSignal);
            if (error.isPresent()) {
                Exceptions.addThrowable(ERRORS, (Object)this, (Throwable)((Throwable)((Object)error.get())));
                this.cancel();
                this.completeLatch.countDown();
                return true;
            }
            return false;
        }

        boolean onSignalSequence(Signal<T> actualSignal, SignalSequenceEvent<T> sequenceEvent) {
            Optional<AssertionError> error;
            Iterator<T> currentNextAs = this.currentNextAs;
            if (actualSignal.isOnNext() && currentNextAs == null) {
                currentNextAs = sequenceEvent.iterable.iterator();
                this.currentNextAs = currentNextAs;
            }
            if ((error = sequenceEvent.test(actualSignal, currentNextAs)) == EXPECT_MORE) {
                return false;
            }
            if (error.isPresent()) {
                Exceptions.addThrowable(ERRORS, (Object)this, (Throwable)((Throwable)((Object)error.get())));
                this.cancel();
                this.completeLatch.countDown();
                return true;
            }
            this.currentNextAs = null;
            this.script.poll();
            return false;
        }

        final boolean onSignalCount(Signal<T> actualSignal, SignalCountEvent<T> event) {
            if (this.produced < event.count) {
                Optional<AssertionError> error;
                if (event.count != 0L && (error = this.checkCountMismatch(event.count, actualSignal)).isPresent()) {
                    Exceptions.addThrowable(ERRORS, (Object)this, (Throwable)((Throwable)((Object)error.get())));
                    this.cancel();
                    this.completeLatch.countDown();
                }
                return true;
            }
            this.script.poll();
            this.produced = 0L;
            return false;
        }

        void onTaskEvent() {
            while (true) {
                if (this.isCancelled()) {
                    return;
                }
                Event<T> event = this.script.peek();
                if (!(event instanceof TaskEvent)) break;
                event = this.script.poll();
                if (!(event instanceof TaskEvent)) {
                    return;
                }
                this.taskEvents.add((TaskEvent)event);
            }
        }

        boolean onSubscription() {
            int missed = WIP.incrementAndGet(this);
            if (missed != 1) {
                return true;
            }
            do {
                if (!(this.script.peek() instanceof SubscriptionEvent)) continue;
                SubscriptionEvent subscriptionEvent = (SubscriptionEvent)this.script.poll();
                if (subscriptionEvent.isTerminal()) {
                    this.doCancel();
                    return true;
                }
                subscriptionEvent.consume(this.upstream());
            } while ((missed = WIP.addAndGet(this, -missed)) != 0);
            return false;
        }

        void doCancel() {
            this.cancel();
            this.completeLatch.countDown();
        }

        final void pollTaskEventOrComplete(Duration timeout) throws InterruptedException {
            block7: {
                Objects.requireNonNull(timeout, "timeout");
                Instant stop = Instant.now().plus(timeout);
                boolean skip = true;
                while (true) {
                    Event<T> event;
                    if ((event = (Event<T>)this.taskEvents.poll()) != null) {
                        try {
                            skip = false;
                            ((TaskEvent)event).run(this);
                        }
                        catch (Throwable t) {
                            Exceptions.throwIfFatal((Throwable)t);
                            this.cancel();
                            if (t instanceof AssertionError) {
                                throw (AssertionError)((Object)t);
                            }
                            throw Exceptions.propagate((Throwable)t);
                        }
                    }
                    if (!skip && (event = this.script.peek()) instanceof SubscriptionEvent) {
                        this.onSubscription();
                    }
                    if (this.completeLatch.await(10L, TimeUnit.NANOSECONDS)) break block7;
                    if (timeout != Duration.ZERO && stop.isBefore(Instant.now())) break;
                }
                if (!this.isStarted()) {
                    throw new IllegalStateException("VerifySubscriber has not been subscribed");
                }
                throw new AssertionError((Object)("VerifySubscriber timed out on " + this.upstream()));
            }
        }

        final void startFusion(Subscription s) {
            block9: {
                if (s instanceof Fuseable.QueueSubscription) {
                    Fuseable.QueueSubscription qs;
                    this.qs = qs = (Fuseable.QueueSubscription)s;
                    int m = qs.requestFusion(this.requestedFusionMode);
                    if ((m & this.expectedFusionMode) != m) {
                        this.setFailure("expected fusion mode: %s; actual: %s", DefaultStepVerifierBuilder.formatFusionMode(this.expectedFusionMode), DefaultStepVerifierBuilder.formatFusionMode(m));
                        return;
                    }
                    this.establishedFusionMode = m;
                    if (m == 1) {
                        while (true) {
                            Object v;
                            try {
                                v = qs.poll();
                            }
                            catch (Throwable e) {
                                Exceptions.throwIfFatal((Throwable)e);
                                this.onExpectation(Signal.error((Throwable)e));
                                return;
                            }
                            if (v == null) {
                                this.onComplete();
                                break block9;
                            }
                            this.onNext(v);
                        }
                    }
                    if (this.initialRequest != 0L) {
                        s.request(this.initialRequest);
                    }
                } else {
                    this.setFailure("expected fusion-ready source but actual Subscription is not: %s", this.expectedFusionMode, s);
                }
            }
        }

        final void validate() {
            if (!this.isStarted()) {
                throw new IllegalStateException("VerifySubscriber has not been subscribed");
            }
            Throwable errors = this.errors;
            if (errors == null) {
                return;
            }
            if (errors.getSuppressed().length == 0 && errors instanceof AssertionError) {
                throw (AssertionError)((Object)errors);
            }
            ArrayList<Throwable> flat = new ArrayList<Throwable>();
            flat.add(errors);
            flat.addAll(Arrays.asList(errors.getSuppressed()));
            StringBuilder messageBuilder = new StringBuilder("Expectation failure(s):\n");
            flat.stream().flatMap(error -> Stream.of(" - ", error, "\n")).forEach(messageBuilder::append);
            messageBuilder.delete(messageBuilder.length() - 1, messageBuilder.length());
            throw new AssertionError(messageBuilder.toString(), errors);
        }
    }

    static final class DefaultStepVerifier<T>
    implements StepVerifier {
        private final DefaultStepVerifierBuilder<T> parent;
        private final int requestedFusionMode;
        private final int expectedFusionMode;

        DefaultStepVerifier(DefaultStepVerifierBuilder<T> parent) {
            this.parent = parent;
            this.requestedFusionMode = parent.requestedFusionMode;
            this.expectedFusionMode = parent.expectedFusionMode == -1 ? parent.requestedFusionMode : parent.expectedFusionMode;
        }

        @Override
        public Duration verify() {
            return this.verify(Duration.ZERO);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Duration verify(Duration duration) {
            Objects.requireNonNull(duration, "duration");
            if (this.parent.sourceSupplier != null) {
                VirtualTimeScheduler vts = null;
                if (this.parent.vtsLookup != null) {
                    vts = this.parent.vtsLookup.get();
                    VirtualTimeScheduler.enable(vts);
                }
                try {
                    Publisher publisher = this.parent.sourceSupplier.get();
                    this.precheckVerify(publisher);
                    Instant now = Instant.now();
                    DefaultVerifySubscriber newVerifier = new DefaultVerifySubscriber(this.parent.script, this.parent.initialRequest, this.requestedFusionMode, this.expectedFusionMode, vts);
                    publisher.subscribe(newVerifier);
                    newVerifier.verify(duration);
                    Duration duration2 = Duration.between(now, Instant.now());
                    return duration2;
                }
                finally {
                    if (vts != null) {
                        vts.shutdown();
                    }
                }
            }
            return this.toSubscriber().verify(duration);
        }

        DefaultVerifySubscriber<T> toSubscriber() {
            VirtualTimeScheduler vts = null;
            if (this.parent.vtsLookup != null) {
                vts = this.parent.vtsLookup.get();
            }
            return new DefaultVerifySubscriber(this.parent.script, this.parent.initialRequest, this.requestedFusionMode, this.expectedFusionMode, vts);
        }

        void precheckVerify(Publisher<? extends T> publisher) {
            Objects.requireNonNull(publisher, "publisher");
            if (this.requestedFusionMode == Integer.MIN_VALUE && publisher instanceof Fuseable) {
                throw new AssertionError((Object)"The source publisher supports fusion");
            }
            if (this.requestedFusionMode >= 0 && !(publisher instanceof Fuseable)) {
                throw new AssertionError((Object)"The source publisher does not support fusion");
            }
        }
    }

    static interface Event<T> {
    }
}

