/*
 * Decompiled with CFR 0.152.
 */
package reactor.pool;

import java.time.Clock;
import java.util.function.BiPredicate;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.pool.AllocationStrategy;
import reactor.pool.PoolMetricsRecorder;
import reactor.pool.PooledRefMetadata;

public interface PoolConfig<POOLABLE> {
    public Mono<POOLABLE> allocator();

    public AllocationStrategy allocationStrategy();

    public int maxPending();

    public Function<POOLABLE, ? extends Publisher<Void>> releaseHandler();

    public Function<POOLABLE, ? extends Publisher<Void>> destroyHandler();

    public BiPredicate<POOLABLE, PooledRefMetadata> evictionPredicate();

    public Scheduler acquisitionScheduler();

    public PoolMetricsRecorder metricsRecorder();

    public Clock clock();

    public boolean reuseIdleResourcesInLruOrder();
}

