/*
 * Decompiled with CFR 0.152.
 */
package reactor.retry;

import java.time.Duration;
import java.time.Instant;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.scheduler.Scheduler;
import reactor.retry.AbstractRetry;
import reactor.retry.Backoff;
import reactor.retry.BackoffDelay;
import reactor.retry.DefaultContext;
import reactor.retry.Jitter;
import reactor.retry.Repeat;
import reactor.retry.RepeatContext;
import reactor.util.Logger;
import reactor.util.Loggers;

@Deprecated
public class DefaultRepeat<T>
extends AbstractRetry<T, Long>
implements Repeat<T> {
    static final Logger log = Loggers.getLogger(DefaultRepeat.class);
    static final Consumer<? super RepeatContext<?>> NOOP_ON_REPEAT = r -> {};
    final Predicate<? super RepeatContext<T>> repeatPredicate;
    final Consumer<? super RepeatContext<T>> onRepeat;

    DefaultRepeat(Predicate<? super RepeatContext<T>> repeatPredicate, long maxRepeats, Duration timeout, Backoff backoff, Jitter jitter, Scheduler backoffScheduler, Consumer<? super RepeatContext<T>> onRepeat, T applicationContext) {
        super(maxRepeats, timeout, backoff, jitter, backoffScheduler, applicationContext);
        this.repeatPredicate = repeatPredicate;
        this.onRepeat = onRepeat;
    }

    public static <T> DefaultRepeat<T> create(Predicate<? super RepeatContext<T>> repeatPredicate, long n) {
        return new DefaultRepeat<Object>(repeatPredicate, n, null, Backoff.zero(), Jitter.noJitter(), null, NOOP_ON_REPEAT, null);
    }

    @Override
    public Repeat<T> withApplicationContext(T applicationContext) {
        return new DefaultRepeat<T>(this.repeatPredicate, this.maxIterations, this.timeout, this.backoff, this.jitter, this.backoffScheduler, this.onRepeat, applicationContext);
    }

    @Override
    public Repeat<T> doOnRepeat(Consumer<? super RepeatContext<T>> onRepeat) {
        return new DefaultRepeat<Object>(this.repeatPredicate, this.maxIterations, this.timeout, this.backoff, this.jitter, this.backoffScheduler, onRepeat, this.applicationContext);
    }

    @Override
    public Repeat<T> timeout(Duration timeout) {
        if (timeout.isNegative()) {
            throw new IllegalArgumentException("timeout should be >= 0");
        }
        return new DefaultRepeat<Object>(this.repeatPredicate, this.maxIterations, timeout, this.backoff, this.jitter, this.backoffScheduler, this.onRepeat, this.applicationContext);
    }

    @Override
    public Repeat<T> repeatMax(long maxRepeats) {
        if (maxRepeats < 1L) {
            throw new IllegalArgumentException("maxRepeats should be > 0");
        }
        return new DefaultRepeat<Object>(this.repeatPredicate, maxRepeats, this.timeout, this.backoff, this.jitter, this.backoffScheduler, this.onRepeat, this.applicationContext);
    }

    @Override
    public Repeat<T> backoff(Backoff backoff) {
        return new DefaultRepeat<Object>(this.repeatPredicate, this.maxIterations, this.timeout, backoff, this.jitter, this.backoffScheduler, this.onRepeat, this.applicationContext);
    }

    @Override
    public Repeat<T> jitter(Jitter jitter) {
        return new DefaultRepeat<Object>(this.repeatPredicate, this.maxIterations, this.timeout, this.backoff, jitter, this.backoffScheduler, this.onRepeat, this.applicationContext);
    }

    @Override
    public Repeat<T> withBackoffScheduler(Scheduler scheduler) {
        return new DefaultRepeat<Object>(this.repeatPredicate, this.maxIterations, this.timeout, this.backoff, this.jitter, scheduler, this.onRepeat, this.applicationContext);
    }

    @Override
    public Publisher<Long> apply(Flux<Long> companionValues) {
        Instant timeoutInstant = this.calculateTimeout();
        DefaultContext<Object> context = new DefaultContext<Object>(this.applicationContext, 0L, null, -1L);
        return companionValues.index().map(tuple -> this.repeatBackoff((Long)tuple.getT2(), (Long)tuple.getT1() + 1L, timeoutInstant, context)).takeWhile(backoff -> backoff != RETRY_EXHAUSTED).concatMap(backoff -> this.retryMono(backoff.delay));
    }

    BackoffDelay repeatBackoff(Long companionValue, Long iteration, Instant timeoutInstant, DefaultContext<T> context) {
        DefaultContext<Object> tmpContext = new DefaultContext<Object>(this.applicationContext, (long)iteration, context.lastBackoff, companionValue);
        BackoffDelay nextBackoff = this.calculateBackoff(tmpContext, timeoutInstant);
        DefaultContext<Object> repeatContext = new DefaultContext<Object>(this.applicationContext, (long)iteration, nextBackoff, companionValue);
        context.lastBackoff = nextBackoff;
        if (!this.repeatPredicate.test(repeatContext)) {
            log.debug("Stopping repeats since predicate returned false, retry context: {}", new Object[]{repeatContext});
            return RETRY_EXHAUSTED;
        }
        if (nextBackoff == RETRY_EXHAUSTED) {
            log.debug("Repeats exhausted, retry context: {}", new Object[]{repeatContext});
            return RETRY_EXHAUSTED;
        }
        log.debug("Scheduling repeat attempt, retry context: {}", new Object[]{repeatContext});
        this.onRepeat.accept(repeatContext);
        return nextBackoff;
    }

    public String toString() {
        return "Repeat{times=" + this.maxIterations + ",backoff=" + this.backoff + ",jitter=" + this.jitter + "}";
    }
}

