/*
 * Decompiled with CFR 0.152.
 */
package reactor.retry;

import java.time.Duration;
import java.util.function.Function;
import reactor.retry.BackoffDelay;
import reactor.retry.Context;

public interface Backoff
extends Function<Context<?>, BackoffDelay> {
    public static final Backoff ZERO_BACKOFF = new Backoff(){

        @Override
        public BackoffDelay apply(Context<?> context) {
            return BackoffDelay.ZERO;
        }

        public String toString() {
            return "Backoff{ZERO}";
        }
    };

    public static Backoff zero() {
        return ZERO_BACKOFF;
    }

    public static Backoff fixed(final Duration backoffInterval) {
        return new Backoff(){

            @Override
            public BackoffDelay apply(Context<?> context) {
                return new BackoffDelay(backoffInterval);
            }

            public String toString() {
                return "Backoff{fixed=" + backoffInterval.toMillis() + "ms}";
            }
        };
    }

    public static Backoff exponential(final Duration firstBackoff, final Duration maxBackoff, final int factor, boolean basedOnPreviousValue) {
        Duration maxBackoffInterval;
        if (firstBackoff == null || firstBackoff.isNegative() || firstBackoff.isZero()) {
            throw new IllegalArgumentException("firstBackoff must be > 0");
        }
        Duration duration = maxBackoffInterval = maxBackoff != null ? maxBackoff : Duration.ofSeconds(Long.MAX_VALUE);
        if (maxBackoffInterval.compareTo(firstBackoff) <= 0) {
            throw new IllegalArgumentException("maxBackoff must be >= firstBackoff");
        }
        if (!basedOnPreviousValue) {
            return new Backoff(){

                @Override
                public BackoffDelay apply(Context<?> context) {
                    Duration nextBackoff = firstBackoff.multipliedBy((long)Math.pow(factor, context.iteration() - 1L));
                    return new BackoffDelay(firstBackoff, maxBackoffInterval, nextBackoff);
                }

                public String toString() {
                    return String.format("Backoff{exponential,min=%sms,max=%s,factor=%s,basedOnPreviousValue=false}", firstBackoff.toMillis(), maxBackoff == null ? "NONE" : maxBackoff.toMillis() + "ms", factor);
                }
            };
        }
        return new Backoff(){

            @Override
            public BackoffDelay apply(Context<?> context) {
                Duration prevBackoff = context.backoff() == null ? Duration.ZERO : context.backoff();
                Duration nextBackoff = prevBackoff.multipliedBy(factor);
                nextBackoff = nextBackoff.compareTo(firstBackoff) < 0 ? firstBackoff : nextBackoff;
                return new BackoffDelay(firstBackoff, maxBackoff, nextBackoff);
            }

            public String toString() {
                return String.format("Backoff{exponential,min=%sms,max=%s,factor=%s,basedOnPreviousValue=true}", firstBackoff.toMillis(), maxBackoff == null ? "NONE" : maxBackoff.toMillis() + "ms", factor);
            }
        };
    }
}

