/*
 * Decompiled with CFR 0.152.
 */
package reactor.retry;

import java.time.Duration;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.scheduler.Scheduler;
import reactor.retry.Backoff;
import reactor.retry.DefaultRepeat;
import reactor.retry.Jitter;
import reactor.retry.RepeatContext;

public interface Repeat<T>
extends Function<Flux<Long>, Publisher<Long>> {
    public static <T> Repeat<T> onlyIf(Predicate<? super RepeatContext<T>> predicate) {
        return DefaultRepeat.create(predicate, Integer.MAX_VALUE);
    }

    public static <T> Repeat<T> once() {
        return Repeat.times(1);
    }

    public static <T> Repeat<T> times(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("n should be >= 0");
        }
        return DefaultRepeat.create(context -> true, n);
    }

    public Repeat<T> withApplicationContext(T var1);

    public Repeat<T> doOnRepeat(Consumer<? super RepeatContext<T>> var1);

    public Repeat<T> timeout(Duration var1);

    public Repeat<T> backoff(Backoff var1);

    public Repeat<T> jitter(Jitter var1);

    public Repeat<T> withBackoffScheduler(Scheduler var1);

    default public Repeat<T> noBackoff() {
        return this.backoff(Backoff.zero());
    }

    default public Repeat<T> fixedBackoff(Duration backoffInterval) {
        return this.backoff(Backoff.fixed(backoffInterval));
    }

    default public Repeat<T> exponentialBackoff(Duration firstBackoff, Duration maxBackoff) {
        return this.backoff(Backoff.exponential(firstBackoff, maxBackoff, 2, false));
    }

    default public Repeat<T> exponentialBackoffWithJitter(Duration firstBackoff, Duration maxBackoff) {
        return this.backoff(Backoff.exponential(firstBackoff, maxBackoff, 2, false)).jitter(Jitter.random());
    }

    default public Repeat<T> randomBackoff(Duration firstBackoff, Duration maxBackoff) {
        return this.backoff(Backoff.exponential(firstBackoff, maxBackoff, 3, true)).jitter(Jitter.random());
    }

    @Override
    default public <S> Flux<S> apply(Publisher<S> source) {
        return Flux.from(source).repeatWhen((Function)this);
    }
}

