/*
 * Decompiled with CFR 0.152.
 */
package reactor.retry;

import java.time.Duration;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Function;
import reactor.retry.BackoffDelay;

public interface Jitter
extends Function<BackoffDelay, Duration> {
    public static Jitter noJitter() {
        return backoff -> backoff.delay();
    }

    public static Jitter random() {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        return backoff -> {
            long minBackoffMs;
            long backoffMs = backoff.delay().toMillis();
            long jitterBackoffMs = backoffMs == (minBackoffMs = backoff.min.toMillis()) ? minBackoffMs : random.nextLong(minBackoffMs, backoffMs);
            return Duration.ofMillis(jitterBackoffMs);
        };
    }
}

