/*
 * Decompiled with CFR 0.152.
 */
package reactor.retry;

import java.time.Duration;
import java.time.Instant;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.retry.AbstractRetry;
import reactor.retry.Backoff;
import reactor.retry.BackoffDelay;
import reactor.retry.DefaultContext;
import reactor.retry.Jitter;
import reactor.retry.Retry;
import reactor.retry.RetryContext;
import reactor.retry.RetryExhaustedException;
import reactor.util.Logger;
import reactor.util.Loggers;

public class DefaultRetry<T>
extends AbstractRetry<T, Throwable>
implements Retry<T> {
    static final Logger log = Loggers.getLogger(DefaultRetry.class);
    static final Consumer<? super RetryContext<?>> NOOP_ON_RETRY = r -> {};
    final Predicate<? super RetryContext<T>> retryPredicate;
    final Consumer<? super RetryContext<T>> onRetry;

    DefaultRetry(Predicate<? super RetryContext<T>> retryPredicate, int maxIterations, Duration timeout, Backoff backoff, Jitter jitter, Scheduler backoffScheduler, Consumer<? super RetryContext<T>> onRetry, T applicationContext) {
        super(maxIterations, timeout, backoff, jitter, backoffScheduler, applicationContext);
        this.retryPredicate = retryPredicate;
        this.onRetry = onRetry;
    }

    public static <T> DefaultRetry<T> create(Predicate<? super RetryContext<T>> retryPredicate) {
        return new DefaultRetry<Object>(retryPredicate, 1, null, Backoff.zero(), Jitter.noJitter(), null, NOOP_ON_RETRY, null);
    }

    @Override
    public Retry<T> withApplicationContext(T applicationContext) {
        return new DefaultRetry<T>(this.retryPredicate, this.maxIterations, this.timeout, this.backoff, this.jitter, this.backoffScheduler, this.onRetry, applicationContext);
    }

    @Override
    public Retry<T> doOnRetry(Consumer<? super RetryContext<T>> onRetry) {
        return new DefaultRetry<Object>(this.retryPredicate, this.maxIterations, this.timeout, this.backoff, this.jitter, this.backoffScheduler, onRetry, this.applicationContext);
    }

    @Override
    public Retry<T> retryMax(int maxIterations) {
        if (maxIterations < 0) {
            throw new IllegalArgumentException("maxIterations should be >= 0");
        }
        return new DefaultRetry<Object>(this.retryPredicate, maxIterations, this.timeout, this.backoff, this.jitter, this.backoffScheduler, this.onRetry, this.applicationContext);
    }

    @Override
    public Retry<T> timeout(Duration timeout) {
        if (timeout.isNegative()) {
            throw new IllegalArgumentException("timeout should be >= 0");
        }
        return new DefaultRetry<Object>(this.retryPredicate, Integer.MAX_VALUE, timeout, this.backoff, this.jitter, this.backoffScheduler, this.onRetry, this.applicationContext);
    }

    @Override
    public Retry<T> backoff(Backoff backoff) {
        return new DefaultRetry<Object>(this.retryPredicate, this.maxIterations, this.timeout, backoff, this.jitter, this.backoffScheduler, this.onRetry, this.applicationContext);
    }

    @Override
    public Retry<T> jitter(Jitter jitter) {
        return new DefaultRetry<Object>(this.retryPredicate, this.maxIterations, this.timeout, this.backoff, jitter, this.backoffScheduler, this.onRetry, this.applicationContext);
    }

    @Override
    public Retry<T> withBackoffScheduler(Scheduler scheduler) {
        return new DefaultRetry<Object>(this.retryPredicate, this.maxIterations, this.timeout, this.backoff, this.jitter, scheduler, this.onRetry, this.applicationContext);
    }

    @Override
    public Publisher<Long> apply(Flux<Throwable> errors) {
        Instant timeoutInstant = this.calculateTimeout();
        DefaultContext<Object> context = new DefaultContext<Object>(this.applicationContext, 0L, null, null);
        return errors.zipWith((Publisher)Flux.range((int)1, (int)Integer.MAX_VALUE)).concatMap(tuple -> this.retry((Throwable)tuple.getT1(), ((Integer)tuple.getT2()).intValue(), timeoutInstant, context));
    }

    Publisher<Long> retry(Throwable e, long iteration, Instant timeoutInstant, DefaultContext<T> context) {
        DefaultContext<Object> tmpContext = new DefaultContext<Object>(this.applicationContext, iteration, context.lastBackoff, e);
        BackoffDelay nextBackoff = this.calculateBackoff(tmpContext, timeoutInstant);
        DefaultContext<Object> retryContext = new DefaultContext<Object>(this.applicationContext, iteration, nextBackoff, e);
        context.lastBackoff = nextBackoff;
        if (!this.retryPredicate.test(retryContext)) {
            log.debug("Stopping retries since predicate returned false, retry context: {}", new Object[]{retryContext});
            return Mono.error((Throwable)e);
        }
        if (nextBackoff == RETRY_EXHAUSTED) {
            log.debug("Retries exhausted, retry context: {}", new Object[]{retryContext});
            return Mono.error((Throwable)new RetryExhaustedException(e));
        }
        log.debug("Scheduling retry attempt, retry context: {}", new Object[]{retryContext});
        this.onRetry.accept(retryContext);
        return this.retryMono(nextBackoff.delay());
    }
}

