/*
 * Decompiled with CFR 0.152.
 */
package reactor.math;

import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import reactor.core.Fuseable;
import reactor.core.publisher.MonoSource;
import reactor.math.MathSubscriber;

final class MonoAverageFloat<T>
extends MonoSource<T, Float>
implements Fuseable {
    final Function<? super T, ? extends Number> mapping;

    MonoAverageFloat(Publisher<? extends T> source, Function<? super T, ? extends Number> mapping) {
        super(source);
        this.mapping = mapping;
    }

    public void subscribe(Subscriber<? super Float> s) {
        this.source.subscribe(new AverageFloatSubscriber<T>(s, this.mapping));
    }

    static final class AverageFloatSubscriber<T>
    extends MathSubscriber<T, Float> {
        final Function<? super T, ? extends Number> mapping;
        int count;
        float sum;

        AverageFloatSubscriber(Subscriber<? super Float> actual, Function<? super T, ? extends Number> mapping) {
            super(actual);
            this.mapping = mapping;
        }

        @Override
        protected void updateResult(T newValue) {
            ++this.count;
            float floatValue = this.mapping.apply(newValue).floatValue();
            this.sum += floatValue;
        }

        @Override
        protected Float result() {
            return this.count == 0 ? null : Float.valueOf(this.sum / (float)this.count);
        }

        @Override
        protected void reset() {
            this.count = 0;
            this.sum = 0.0f;
        }
    }
}

