/*
 * Decompiled with CFR 0.152.
 */
package reactor.math;

import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import reactor.core.Fuseable;
import reactor.core.publisher.MonoSource;
import reactor.math.MathSubscriber;

final class MonoSumInt<T>
extends MonoSource<T, Integer>
implements Fuseable {
    final Function<? super T, ? extends Number> mapping;

    MonoSumInt(Publisher<? extends T> source, Function<? super T, ? extends Number> mapping) {
        super(source);
        this.mapping = mapping;
    }

    public void subscribe(Subscriber<? super Integer> s) {
        this.source.subscribe(new SumIntSubscriber<T>(s, this.mapping));
    }

    static final class SumIntSubscriber<T>
    extends MathSubscriber<T, Integer> {
        final Function<? super T, ? extends Number> mapping;
        int sum;
        boolean hasValue;

        SumIntSubscriber(Subscriber<? super Integer> actual, Function<? super T, ? extends Number> mapping) {
            super(actual);
            this.mapping = mapping;
        }

        @Override
        protected void updateResult(T newValue) {
            int intValue = this.mapping.apply(newValue).intValue();
            this.sum = this.hasValue ? this.sum + intValue : intValue;
            this.hasValue = true;
        }

        @Override
        protected Integer result() {
            return this.hasValue ? Integer.valueOf(this.sum) : null;
        }

        @Override
        protected void reset() {
            this.sum = 0;
            this.hasValue = false;
        }
    }
}

