/*
 * Decompiled with CFR 0.152.
 */
package reactor.math;

import java.util.Comparator;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import reactor.core.Fuseable;
import reactor.core.publisher.MonoSource;
import reactor.math.MathSubscriber;

final class MonoMinMax<T>
extends MonoSource<T, T>
implements Fuseable {
    final Comparator<? super T> comparator;
    final int comparisonMultiplier;

    MonoMinMax(Publisher<? extends T> source, Comparator<? super T> comparator, int comparisonMultiplier) {
        super(source);
        this.comparator = comparator;
        this.comparisonMultiplier = comparisonMultiplier;
    }

    public void subscribe(Subscriber<? super T> s) {
        this.source.subscribe(new MinMaxSubscriber<T>(s, this.comparator, this.comparisonMultiplier));
    }

    static final class MinMaxSubscriber<T>
    extends MathSubscriber<T, T> {
        final Comparator<? super T> comparator;
        final int comparisonMultiplier;
        T result;

        MinMaxSubscriber(Subscriber<? super T> actual, Comparator<? super T> comparator, int comparisonMultiplier) {
            super(actual);
            this.comparator = comparator;
            this.comparisonMultiplier = comparisonMultiplier;
        }

        @Override
        protected void updateResult(T newValue) {
            T r = this.result;
            if (r == null || this.comparator.compare(newValue, this.result) * this.comparisonMultiplier > 0) {
                r = newValue;
            }
            this.result = r;
        }

        @Override
        protected T result() {
            return this.result;
        }

        @Override
        protected void reset() {
            this.result = null;
        }
    }
}

