/*
 * Decompiled with CFR 0.152.
 */
package reactor.math;

import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import reactor.core.Fuseable;
import reactor.core.publisher.MonoSource;
import reactor.math.MathSubscriber;

final class MonoAverageDouble<T>
extends MonoSource<T, Double>
implements Fuseable {
    final Function<? super T, ? extends Number> mapping;

    MonoAverageDouble(Publisher<? extends T> source, Function<? super T, ? extends Number> mapping) {
        super(source);
        this.mapping = mapping;
    }

    public void subscribe(Subscriber<? super Double> s) {
        this.source.subscribe(new AverageDoubleSubscriber<T>(s, this.mapping));
    }

    static final class AverageDoubleSubscriber<T>
    extends MathSubscriber<T, Double> {
        final Function<? super T, ? extends Number> mapping;
        int count;
        double sum;

        AverageDoubleSubscriber(Subscriber<? super Double> actual, Function<? super T, ? extends Number> mapping) {
            super(actual);
            this.mapping = mapping;
        }

        @Override
        protected void updateResult(T newValue) {
            ++this.count;
            double doubleValue = this.mapping.apply(newValue).doubleValue();
            this.sum += doubleValue;
        }

        @Override
        protected Double result() {
            return this.count == 0 ? null : Double.valueOf(this.sum / (double)this.count);
        }

        @Override
        protected void reset() {
            this.count = 0;
            this.sum = 0.0;
        }
    }
}

