/*
 * Decompiled with CFR 0.152.
 */
package reactor.adapter.rxjava;

import io.reactivex.Scheduler;
import io.reactivex.disposables.Disposables;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import reactor.core.Disposable;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

public final class RxJava2Schedulers {
    private RxJava2Schedulers() {
        throw new IllegalStateException("No instances!");
    }

    public static void useReactorCoreSchedulers() {
        if (RxJavaPlugins.getComputationSchedulerHandler() == null) {
            io.reactivex.schedulers.Schedulers.computation().shutdown();
        }
        if (RxJavaPlugins.getIoSchedulerHandler() == null) {
            io.reactivex.schedulers.Schedulers.io().shutdown();
        }
        if (RxJavaPlugins.getSingleSchedulerHandler() == null) {
            io.reactivex.schedulers.Schedulers.single().shutdown();
        }
        if (RxJavaPlugins.getNewThreadSchedulerHandler() == null) {
            io.reactivex.schedulers.Schedulers.newThread().shutdown();
        }
        io.reactivex.Scheduler computation = ReactorCoreSchedulerWrapper.from(Schedulers.parallel());
        RxJavaPlugins.setComputationSchedulerHandler(s -> computation);
        io.reactivex.Scheduler elastic = ReactorCoreSchedulerWrapper.from(Schedulers.elastic());
        RxJavaPlugins.setIoSchedulerHandler(s -> elastic);
        io.reactivex.Scheduler single = ReactorCoreSchedulerWrapper.from(Schedulers.single());
        RxJavaPlugins.setSingleSchedulerHandler(s -> single);
        RxJavaPlugins.setNewThreadSchedulerHandler(s -> elastic);
    }

    public static void resetReactorCoreSchedulers() {
        RxJavaPlugins.setComputationSchedulerHandler(null);
        RxJavaPlugins.setIoSchedulerHandler(null);
        RxJavaPlugins.setSingleSchedulerHandler(null);
        RxJavaPlugins.setNewThreadSchedulerHandler(null);
        io.reactivex.schedulers.Schedulers.computation().start();
        io.reactivex.schedulers.Schedulers.io().start();
        io.reactivex.schedulers.Schedulers.single().start();
        io.reactivex.schedulers.Schedulers.newThread().start();
    }

    static final class ReactorCoreSchedulerWrapper
    extends io.reactivex.Scheduler {
        final Scheduler scheduler;

        public static io.reactivex.Scheduler from(Scheduler scheduler) {
            return new ReactorCoreSchedulerWrapper(scheduler);
        }

        ReactorCoreSchedulerWrapper(Scheduler scheduler) {
            this.scheduler = Objects.requireNonNull(scheduler, "scheduler");
        }

        public io.reactivex.disposables.Disposable scheduleDirect(Runnable task) {
            Disposable s = this.scheduler.schedule(task);
            return Disposables.fromAction(() -> ((Disposable)s).dispose());
        }

        public io.reactivex.disposables.Disposable scheduleDirect(Runnable task, long delay, TimeUnit unit) {
            Disposable s = this.scheduler.schedule(task, delay, unit);
            return Disposables.fromAction(() -> ((Disposable)s).dispose());
        }

        public io.reactivex.disposables.Disposable schedulePeriodicallyDirect(Runnable task, long initialDelay, long period, TimeUnit unit) {
            Disposable s = this.scheduler.schedulePeriodically(task, initialDelay, period, unit);
            return Disposables.fromAction(() -> ((Disposable)s).dispose());
        }

        public Scheduler.Worker createWorker() {
            return new ReactorCoreSchedulerWorker(this.scheduler.createWorker());
        }

        static final class ReactorCoreSchedulerWorker
        extends Scheduler.Worker {
            final Scheduler.Worker w;
            volatile boolean disposed;

            ReactorCoreSchedulerWorker(Scheduler.Worker w) {
                this.w = w;
            }

            public io.reactivex.disposables.Disposable schedule(Runnable task) {
                Disposable s = this.w.schedule(task);
                return Disposables.fromAction(() -> ((Disposable)s).dispose());
            }

            public void dispose() {
                this.disposed = true;
                this.w.dispose();
            }

            public boolean isDisposed() {
                return this.disposed;
            }

            public io.reactivex.disposables.Disposable schedule(Runnable task, long delay, TimeUnit unit) {
                Disposable s = this.w.schedule(task, delay, unit);
                return Disposables.fromAction(() -> ((Disposable)s).dispose());
            }

            public io.reactivex.disposables.Disposable schedulePeriodically(Runnable task, long initialDelay, long period, TimeUnit unit) {
                Disposable s = this.w.schedulePeriodically(task, initialDelay, period, unit);
                return Disposables.fromAction(() -> ((Disposable)s).dispose());
            }
        }
    }
}

