/*
 * Decompiled with CFR 0.152.
 */
package reactor.adapter.rxjava;

import java.util.Objects;
import java.util.concurrent.TimeUnit;
import reactor.core.Cancellation;
import reactor.core.Exceptions;
import reactor.core.publisher.Operators;
import reactor.core.scheduler.TimedScheduler;
import rx.Scheduler;
import rx.Subscription;

public final class RxJava1Scheduler
implements TimedScheduler {
    final Scheduler scheduler;

    public RxJava1Scheduler(Scheduler scheduler) {
        this.scheduler = Objects.requireNonNull(scheduler, "scheduler");
    }

    public Cancellation schedule(Runnable task) {
        Scheduler.Worker w = this.scheduler.createWorker();
        Subscription s = w.schedule(() -> {
            try {
                try {
                    task.run();
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal((Throwable)ex);
                    Operators.onErrorDropped((Throwable)ex);
                }
            }
            finally {
                w.unsubscribe();
            }
        });
        return () -> ((Subscription)s).unsubscribe();
    }

    public Cancellation schedule(Runnable task, long delay, TimeUnit unit) {
        Scheduler.Worker w = this.scheduler.createWorker();
        Subscription s = w.schedule(() -> {
            try {
                try {
                    task.run();
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal((Throwable)ex);
                    Operators.onErrorDropped((Throwable)ex);
                }
            }
            finally {
                w.unsubscribe();
            }
        }, delay, unit);
        return () -> ((Subscription)s).unsubscribe();
    }

    public Cancellation schedulePeriodically(Runnable task, long initialDelay, long period, TimeUnit unit) {
        Scheduler.Worker w = this.scheduler.createWorker();
        Subscription s = w.schedulePeriodically(() -> {
            try {
                task.run();
            }
            catch (Throwable ex) {
                w.unsubscribe();
                Exceptions.throwIfFatal((Throwable)ex);
                Operators.onErrorDropped((Throwable)ex);
            }
        }, initialDelay, period, unit);
        return () -> ((Subscription)s).unsubscribe();
    }

    public TimedScheduler.TimedWorker createWorker() {
        return new RxSchedulerWorker(this.scheduler.createWorker());
    }

    static final class RxSchedulerWorker
    implements TimedScheduler.TimedWorker {
        final Scheduler.Worker w;

        public RxSchedulerWorker(Scheduler.Worker w) {
            this.w = w;
        }

        public Cancellation schedule(Runnable task) {
            Subscription s = this.w.schedule(task::run);
            return () -> ((Subscription)s).unsubscribe();
        }

        public void shutdown() {
            this.w.unsubscribe();
        }

        public Cancellation schedule(Runnable task, long delay, TimeUnit unit) {
            Subscription s = this.w.schedule(task::run, delay, unit);
            return () -> ((Subscription)s).unsubscribe();
        }

        public Cancellation schedulePeriodically(Runnable task, long initialDelay, long period, TimeUnit unit) {
            Subscription s = this.w.schedulePeriodically(task::run, initialDelay, period, unit);
            return () -> ((Subscription)s).unsubscribe();
        }
    }
}

