/*
 * Decompiled with CFR 0.152.
 */
package reactor.adapter.rxjava;

import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscription;
import reactor.core.Exceptions;
import reactor.core.Fuseable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Operators;
import rx.Completable;
import rx.CompletableSubscriber;
import rx.Observable;
import rx.Producer;
import rx.Single;
import rx.SingleSubscriber;
import rx.Subscriber;
import rx.internal.util.ScalarSynchronousObservable;

public abstract class RxJava1Adapter {
    public static Mono<Void> completableToMono(Completable completable) {
        return new CompletableAsMono(completable);
    }

    public static <T> Flux<T> observableToFlux(Observable<T> obs) {
        if (obs == Observable.empty()) {
            return Flux.empty();
        }
        if (obs instanceof ScalarSynchronousObservable) {
            return Flux.just((Object)((ScalarSynchronousObservable)obs).get());
        }
        return new ObservableAsFlux(obs);
    }

    public static <T> Observable<T> publisherToObservable(Publisher<T> publisher) {
        if (publisher instanceof Fuseable.ScalarCallable) {
            Fuseable.ScalarCallable scalarCallable = (Fuseable.ScalarCallable)publisher;
            Object v = scalarCallable.call();
            if (v == null) {
                return Observable.empty();
            }
            return Observable.just((Object)v);
        }
        return Observable.create(new PublisherAsObservable(publisher));
    }

    public static <T> Single<T> publisherToSingle(Publisher<T> publisher) {
        if (publisher instanceof Fuseable.ScalarCallable) {
            Fuseable.ScalarCallable scalarCallable = (Fuseable.ScalarCallable)publisher;
            Object v = scalarCallable.call();
            if (v == null) {
                return Single.error((Throwable)new NoSuchElementException("Can't convert an empty Publisher to rx.Single"));
            }
            return Single.just((Object)v);
        }
        return Single.create(new PublisherAsSingle<T>(publisher));
    }

    public static Completable publisherToCompletable(Publisher<?> source) {
        return Completable.create((Completable.OnSubscribe)new PublisherAsCompletable(source));
    }

    public static <T> Mono<T> singleToMono(Single<T> single) {
        return new SingleAsMono<T>(single);
    }

    RxJava1Adapter() {
    }

    private static class RxSubscriberToRS<T>
    extends Subscriber<T> {
        private final org.reactivestreams.Subscriber<? super T> s;

        public RxSubscriberToRS(org.reactivestreams.Subscriber<? super T> s) {
            this.s = s;
            this.request(0L);
        }

        void doRequest(long n) {
            this.request(n);
        }

        public void onStart() {
            this.s.onSubscribe(new Subscription(){

                public void request(long n) {
                    if (Operators.checkRequest((long)n, (org.reactivestreams.Subscriber)s)) {
                        this.doRequest(n);
                    }
                }

                public void cancel() {
                    this.unsubscribe();
                }
            });
        }

        public void onCompleted() {
            this.s.onComplete();
        }

        public void onError(Throwable e) {
            if (e == null) {
                throw Exceptions.argumentIsNullException();
            }
            this.s.onError(e);
        }

        public void onNext(T o) {
            if (o == null) {
                throw Exceptions.argumentIsNullException();
            }
            this.s.onNext(o);
        }
    }

    private static class SubscriberToRx<T>
    implements org.reactivestreams.Subscriber<T>,
    Producer,
    Subscription,
    rx.Subscription {
        private final Subscriber<? super T> subscriber;
        private volatile int terminated;
        private volatile Subscription subscription;
        private static final AtomicIntegerFieldUpdater<SubscriberToRx> TERMINATED = AtomicIntegerFieldUpdater.newUpdater(SubscriberToRx.class, "terminated");

        public SubscriberToRx(Subscriber<? super T> subscriber) {
            this.subscriber = subscriber;
            this.terminated = 0;
        }

        public void request(long n) {
            if (n == 0L || this.isUnsubscribed()) {
                return;
            }
            if (n <= 0L) {
                this.subscriber.onError((Throwable)Exceptions.nullOrNegativeRequestException((long)n));
                return;
            }
            Subscription subscription = this.subscription;
            if (subscription != null) {
                subscription.request(n);
            }
        }

        public boolean isUnsubscribed() {
            return this.terminated == 1;
        }

        public void unsubscribe() {
            Subscription subscription;
            if (TERMINATED.compareAndSet(this, 0, 1) && (subscription = this.subscription) != null) {
                this.subscription = null;
                subscription.cancel();
            }
        }

        public void cancel() {
            this.unsubscribe();
        }

        public void onSubscribe(Subscription s) {
            if (Operators.validate((Subscription)this.subscription, (Subscription)s)) {
                this.subscription = s;
                this.subscriber.add((rx.Subscription)this);
                this.subscriber.onStart();
                this.subscriber.setProducer((Producer)this);
            }
        }

        public void onNext(T o) {
            this.subscriber.onNext(o);
        }

        public void onError(Throwable t) {
            if (TERMINATED.compareAndSet(this, 0, 1)) {
                this.subscription = null;
                this.subscriber.onError(t);
            }
        }

        public void onComplete() {
            if (TERMINATED.compareAndSet(this, 0, 1)) {
                this.subscription = null;
                this.subscriber.onCompleted();
            }
        }
    }

    private static class PublisherAsObservable<T>
    implements Observable.OnSubscribe<T> {
        private final Publisher<T> pub;

        private PublisherAsObservable(Publisher<T> pub) {
            this.pub = pub;
        }

        public void call(Subscriber<? super T> subscriber) {
            try {
                this.pub.subscribe(new SubscriberToRx<T>(subscriber));
            }
            catch (Throwable t) {
                Exceptions.throwIfFatal((Throwable)t);
                subscriber.onError(t);
            }
        }
    }

    private static class ObservableAsFlux<T>
    extends Flux<T> {
        private final Observable<T> obs;

        private ObservableAsFlux(Observable<T> obs) {
            this.obs = obs;
        }

        public void subscribe(org.reactivestreams.Subscriber<? super T> s) {
            try {
                this.obs.subscribe(new RxSubscriberToRS<T>(s));
            }
            catch (Throwable t) {
                Operators.error(s, (Throwable)t);
            }
        }
    }

    private static class SingleAsMono<T>
    extends Mono<T> {
        final Single<? extends T> source;

        public SingleAsMono(Single<? extends T> source) {
            this.source = source;
        }

        public void subscribe(org.reactivestreams.Subscriber<? super T> s) {
            SingleAsMonoSubscriber<? super T> parent = new SingleAsMonoSubscriber<T>(s);
            s.onSubscribe(parent);
            this.source.subscribe(parent);
        }

        static final class SingleAsMonoSubscriber<T>
        extends SingleSubscriber<T>
        implements Subscription {
            final org.reactivestreams.Subscriber<? super T> actual;
            T value;
            volatile int state;
            static final AtomicIntegerFieldUpdater<SingleAsMonoSubscriber> STATE = AtomicIntegerFieldUpdater.newUpdater(SingleAsMonoSubscriber.class, "state");
            static final int NO_REQUEST_NO_VALUE = 0;
            static final int NO_REQUEST_HAS_VALUE = 1;
            static final int HAS_REQUEST_NO_VALUE = 2;
            static final int HAS_REQUEST_HAS_VALUE = 3;

            public SingleAsMonoSubscriber(org.reactivestreams.Subscriber<? super T> actual) {
                this.actual = actual;
            }

            public void onSuccess(T value) {
                int s;
                if (value == null) {
                    this.actual.onError((Throwable)new NullPointerException("The wrapped rx.Single produced a null value"));
                    return;
                }
                while ((s = this.state) != 3 && s != 1 && !this.isUnsubscribed()) {
                    if (s == 2) {
                        if (!STATE.compareAndSet(this, s, 3)) break;
                        this.actual.onNext(value);
                        if (this.isUnsubscribed()) break;
                        this.actual.onComplete();
                        break;
                    }
                    this.value = value;
                    if (!STATE.compareAndSet(this, 0, 1)) continue;
                    break;
                }
            }

            public void onError(Throwable error) {
                this.actual.onError(error);
            }

            public void request(long n) {
                if (Operators.validate((long)n)) {
                    int s;
                    while ((s = this.state) != 2 && s != 3 && !this.isUnsubscribed()) {
                        if (s == 1) {
                            if (!STATE.compareAndSet(this, s, 3)) break;
                            T v = this.value;
                            this.value = null;
                            this.actual.onNext(v);
                            if (this.isUnsubscribed()) break;
                            this.actual.onComplete();
                            break;
                        }
                        if (!STATE.compareAndSet(this, s, 2)) continue;
                        break;
                    }
                }
            }

            public void cancel() {
                this.unsubscribe();
            }
        }
    }

    private static class PublisherAsSingle<T>
    implements Single.OnSubscribe<T> {
        final Publisher<? extends T> source;

        public PublisherAsSingle(Publisher<? extends T> source) {
            this.source = source;
        }

        public void call(SingleSubscriber<? super T> t) {
            this.source.subscribe(new PublisherAsSingleSubscriber<T>(t));
        }

        static final class PublisherAsSingleSubscriber<T>
        implements org.reactivestreams.Subscriber<T>,
        rx.Subscription {
            final SingleSubscriber<? super T> actual;
            Subscription s;
            boolean done;
            boolean hasValue;
            T value;
            volatile boolean terminated;

            public PublisherAsSingleSubscriber(SingleSubscriber<? super T> actual) {
                this.actual = actual;
            }

            public void onSubscribe(Subscription s) {
                if (Operators.validate((Subscription)this.s, (Subscription)s)) {
                    this.s = s;
                    this.actual.add((rx.Subscription)this);
                    s.request(Long.MAX_VALUE);
                }
            }

            public void onNext(T t) {
                if (this.done) {
                    Operators.onNextDropped(t);
                    return;
                }
                if (this.hasValue) {
                    this.done = true;
                    this.value = null;
                    this.unsubscribe();
                    this.actual.onError((Throwable)new IndexOutOfBoundsException("The wrapped Publisher produced more than one value"));
                    return;
                }
                this.hasValue = true;
                this.value = t;
            }

            public void onError(Throwable t) {
                if (this.done) {
                    Operators.onErrorDropped((Throwable)t);
                    return;
                }
                this.done = true;
                this.actual.onError(t);
            }

            public void onComplete() {
                if (this.done) {
                    return;
                }
                this.done = true;
                if (this.hasValue) {
                    T v = this.value;
                    this.value = null;
                    this.actual.onSuccess(v);
                } else {
                    this.actual.onError((Throwable)new NoSuchElementException("The wrapped Publisher didn't produce any value"));
                }
            }

            public void unsubscribe() {
                if (this.terminated) {
                    return;
                }
                this.terminated = true;
                this.s.cancel();
            }

            public boolean isUnsubscribed() {
                return this.terminated;
            }
        }
    }

    private static class PublisherAsCompletable
    implements Completable.OnSubscribe {
        final Publisher<?> source;

        public PublisherAsCompletable(Publisher<?> source) {
            this.source = Objects.requireNonNull(source, "source");
        }

        public void call(CompletableSubscriber t) {
            this.source.subscribe((org.reactivestreams.Subscriber)new PublisherCompletableSubscriber(t));
        }

        static final class PublisherCompletableSubscriber
        implements org.reactivestreams.Subscriber<Object>,
        rx.Subscription {
            final CompletableSubscriber actual;
            Subscription s;
            volatile boolean unsubscribed;

            public PublisherCompletableSubscriber(CompletableSubscriber actual) {
                this.actual = actual;
            }

            public void onSubscribe(Subscription s) {
                if (Operators.validate((Subscription)this.s, (Subscription)s)) {
                    this.s = s;
                    this.actual.onSubscribe((rx.Subscription)this);
                    s.request(Long.MAX_VALUE);
                }
            }

            public void onNext(Object t) {
            }

            public void onError(Throwable t) {
                this.actual.onError(t);
            }

            public void onComplete() {
                this.actual.onCompleted();
            }

            public boolean isUnsubscribed() {
                return this.unsubscribed;
            }

            public void unsubscribe() {
                if (this.unsubscribed) {
                    return;
                }
                this.unsubscribed = true;
                this.s.cancel();
            }
        }
    }

    private static class CompletableAsMono
    extends Mono<Void> {
        final Completable source;

        public CompletableAsMono(Completable source) {
            this.source = Objects.requireNonNull(source, "source");
        }

        public void subscribe(org.reactivestreams.Subscriber<? super Void> s) {
            this.source.subscribe((CompletableSubscriber)new CompletableMonoSubscriber(s));
        }

        static final class CompletableMonoSubscriber
        implements CompletableSubscriber,
        Subscription {
            final org.reactivestreams.Subscriber<? super Void> actual;
            rx.Subscription d;

            public CompletableMonoSubscriber(org.reactivestreams.Subscriber<? super Void> actual) {
                this.actual = actual;
            }

            public void onSubscribe(rx.Subscription d) {
                Objects.requireNonNull(d, "rx.Subscription cannot be null!");
                if (this.d != null) {
                    d.unsubscribe();
                    return;
                }
                this.d = d;
                this.actual.onSubscribe((Subscription)this);
            }

            public void onError(Throwable e) {
                this.actual.onError(e);
            }

            public void onCompleted() {
                this.actual.onComplete();
            }

            public void request(long n) {
            }

            public void cancel() {
                this.d.unsubscribe();
            }
        }
    }
}

