/*
 * Decompiled with CFR 0.152.
 */
package io.polygenesis.models.apiimpl;

import io.polygenesis.commons.assertion.Assertion;
import io.polygenesis.commons.valueobjects.ObjectName;
import io.polygenesis.core.Generatable;
import io.polygenesis.core.Metamodel;
import io.polygenesis.models.api.Service;
import io.polygenesis.models.apiimpl.DomainObjectConverter;
import io.polygenesis.models.apiimpl.ServiceDependency;
import io.polygenesis.models.apiimpl.ServiceMethodImplementation;
import io.polygenesis.models.domain.DomainObject;
import java.util.Objects;
import java.util.Set;

public class ServiceImplementation
implements Generatable,
Metamodel {
    private Service service;
    private Set<ServiceDependency> dependencies;
    private Set<ServiceMethodImplementation> serviceMethodImplementations;
    private Set<DomainObjectConverter> domainObjectConverters;
    private DomainObject domainObject;
    private DomainObject parentAggregateRoot;

    public ServiceImplementation(Service service, Set<ServiceDependency> dependencies, Set<ServiceMethodImplementation> serviceMethodImplementations, Set<DomainObjectConverter> domainObjectConverters, DomainObject domainObject, DomainObject parentAggregateRoot) {
        this.setService(service);
        this.setDependencies(dependencies);
        this.setServiceMethodImplementations(serviceMethodImplementations);
        this.setDomainObjectConverters(domainObjectConverters);
        if (domainObject != null) {
            this.setDomainObject(domainObject);
        }
        if (parentAggregateRoot != null) {
            this.setParentAggregateRoot(parentAggregateRoot);
        }
    }

    public ObjectName getObjectName() {
        throw new UnsupportedOperationException();
    }

    public DomainObjectConverter domainObjectConverter() {
        return this.domainObjectConverters.stream().findFirst().orElse(null);
    }

    public Service getService() {
        return this.service;
    }

    public Set<ServiceDependency> getDependencies() {
        return this.dependencies;
    }

    public Set<ServiceMethodImplementation> getServiceMethodImplementations() {
        return this.serviceMethodImplementations;
    }

    public Set<DomainObjectConverter> getDomainObjectConverters() {
        return this.domainObjectConverters;
    }

    public DomainObject getDomainObject() {
        return this.domainObject;
    }

    public DomainObject getParentAggregateRoot() {
        return this.parentAggregateRoot;
    }

    private void setService(Service service) {
        Assertion.isNotNull((Object)service, (String)"service is required");
        this.service = service;
    }

    private void setDependencies(Set<ServiceDependency> dependencies) {
        Assertion.isNotNull(dependencies, (String)"dependencies is required");
        this.dependencies = dependencies;
    }

    private void setServiceMethodImplementations(Set<ServiceMethodImplementation> serviceMethodImplementations) {
        Assertion.isNotNull(serviceMethodImplementations, (String)"serviceMethodImplementations is required");
        this.serviceMethodImplementations = serviceMethodImplementations;
    }

    private void setDomainObjectConverters(Set<DomainObjectConverter> domainObjectConverters) {
        Assertion.isNotNull(domainObjectConverters, (String)"domainObjectConverters is required");
        this.domainObjectConverters = domainObjectConverters;
    }

    private void setDomainObject(DomainObject domainObject) {
        Assertion.isNotNull((Object)domainObject, (String)"domainObject is required");
        this.domainObject = domainObject;
    }

    private void setParentAggregateRoot(DomainObject parentAggregateRoot) {
        Assertion.isNotNull((Object)parentAggregateRoot, (String)"parentAggregateRoot is required");
        this.parentAggregateRoot = parentAggregateRoot;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceImplementation that = (ServiceImplementation)o;
        return Objects.equals(this.service, that.service) && Objects.equals(this.dependencies, that.dependencies) && Objects.equals(this.serviceMethodImplementations, that.serviceMethodImplementations) && Objects.equals(this.domainObjectConverters, that.domainObjectConverters) && Objects.equals(this.domainObject, that.domainObject) && Objects.equals(this.parentAggregateRoot, that.parentAggregateRoot);
    }

    public int hashCode() {
        return Objects.hash(this.service, this.dependencies, this.serviceMethodImplementations, this.domainObjectConverters, this.domainObject, this.parentAggregateRoot);
    }
}

