/*
 * Decompiled with CFR 0.152.
 */
package io.pivotal.spring.cloud.service.eureka;

import io.pivotal.spring.cloud.service.eureka.SanitizingEurekaInstanceConfigBean;
import io.pivotal.spring.cloud.service.eureka.SurgicalRoutingRequestTransformer;
import io.pivotal.spring.cloud.service.eureka.VirtualHostNamesBean;
import java.net.URI;
import java.util.Map;
import java.util.logging.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.cloud.commons.util.InetUtils;
import org.springframework.cloud.commons.util.InetUtilsProperties;
import org.springframework.cloud.netflix.eureka.EurekaInstanceConfigBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnClass(value={EurekaInstanceConfigBean.class})
@ConditionalOnExpression(value="'${vcap.application.uris[0]:}'!='' || '${cf.instance.ip:}'!=''")
public class EurekaInstanceAutoConfiguration {
    private static Logger LOGGER = Logger.getLogger(EurekaInstanceAutoConfiguration.class.getName());
    private static final String UNKNOWN_ZONE = "unknown";
    private static final String INDETERMINATE_EUREKA_ZONE_MESSAGE = "Eureka zone could not be determined from %s=\"%s\". Using \"%s\".";
    private static final String DEFAULT_ZONE_PROPERTY = "eureka.client.serviceUrl.defaultZone";
    private static final String ROUTE_REGISTRATION_METHOD = "route";
    private static final String DIRECT_REGISTRATION_METHOD = "direct";
    private static final String INSTANCE_ID = "instanceId";
    private static final String ZONE = "zone";
    @Value(value="${vcap.application.uris[0]:}")
    private String hostname;
    @Value(value="${spring.application.name:unknown}")
    private String appname = "unknown";
    @Value(value="${vcap.application.application_id:}")
    private String cfAppGuid;
    @Value(value="${cf.instance.index:}")
    private String cfInstanceIndex;
    @Value(value="${cf.instance.internal.ip:}")
    private String ip;
    @Value(value="${port:-1}")
    private int port;
    @Value(value="${vcap.application.instance_id:${random.value}}")
    private String instanceId;
    @Value(value="${spring.cloud.services.registrationMethod:route}")
    private String registrationMethod;
    @Value(value="${eureka.client.serviceUrl.defaultZone:}")
    private String zoneUri;

    @Bean
    public VirtualHostNamesBean getVirtualHostNames() {
        return new VirtualHostNamesBean();
    }

    @Bean
    public EurekaInstanceConfigBean eurekaInstanceConfigBean() {
        if (!StringUtils.isEmpty((Object)this.registrationMethod)) {
            LOGGER.info("Eureka registration method: " + this.registrationMethod);
            if (ROUTE_REGISTRATION_METHOD.equals(this.registrationMethod)) {
                return this.getRouteRegistration();
            }
            if (DIRECT_REGISTRATION_METHOD.equals(this.registrationMethod)) {
                return this.getDirectRegistration();
            }
        }
        return this.getDefaultRegistration();
    }

    @Bean
    public SurgicalRoutingRequestTransformer surgicalRoutingLoadBalancerRequestTransformer() {
        return new SurgicalRoutingRequestTransformer();
    }

    private SanitizingEurekaInstanceConfigBean getRouteRegistration() {
        SanitizingEurekaInstanceConfigBean eurekaInstanceConfigBean = this.getDefaults();
        eurekaInstanceConfigBean.setSecurePortEnabled(true);
        eurekaInstanceConfigBean.setInstanceId(this.hostname + ":" + this.instanceId);
        return eurekaInstanceConfigBean;
    }

    private SanitizingEurekaInstanceConfigBean getDirectRegistration() {
        SanitizingEurekaInstanceConfigBean eurekaInstanceConfigBean = this.getDefaults();
        eurekaInstanceConfigBean.setPreferIpAddress(true);
        eurekaInstanceConfigBean.setNonSecurePort(this.port);
        eurekaInstanceConfigBean.setInstanceId(this.ip + ":" + this.instanceId);
        return eurekaInstanceConfigBean;
    }

    private SanitizingEurekaInstanceConfigBean getDefaults() {
        InetUtilsProperties inetUtilsProperties = new InetUtilsProperties();
        inetUtilsProperties.setDefaultHostname(this.hostname);
        inetUtilsProperties.setDefaultIpAddress(this.ip);
        SanitizingEurekaInstanceConfigBean eurekaInstanceConfigBean = new SanitizingEurekaInstanceConfigBean(new InetUtils(inetUtilsProperties));
        eurekaInstanceConfigBean.setHostname(this.hostname);
        eurekaInstanceConfigBean.setIpAddress(this.ip);
        Map metadataMap = eurekaInstanceConfigBean.getMetadataMap();
        metadataMap.put("cfAppGuid", this.cfAppGuid);
        metadataMap.put("cfInstanceIndex", this.cfInstanceIndex);
        metadataMap.put(INSTANCE_ID, this.instanceId);
        metadataMap.put(ZONE, EurekaInstanceAutoConfiguration.zoneFromUri(this.zoneUri));
        return eurekaInstanceConfigBean;
    }

    private static String zoneFromUri(String defaultZoneUri) {
        String hostname = null;
        try {
            hostname = new URI(defaultZoneUri).getHost();
        }
        catch (Exception e) {
            LOGGER.warning(String.format("Eureka zone could not be determined from %s=\"%s\". Using \"%s\". %s", DEFAULT_ZONE_PROPERTY, defaultZoneUri, UNKNOWN_ZONE, e));
            return UNKNOWN_ZONE;
        }
        if (hostname == null || !hostname.contains(".")) {
            LOGGER.warning(String.format(INDETERMINATE_EUREKA_ZONE_MESSAGE, DEFAULT_ZONE_PROPERTY, defaultZoneUri, UNKNOWN_ZONE));
            return UNKNOWN_ZONE;
        }
        return hostname.substring(hostname.indexOf(".") + 1);
    }

    private SanitizingEurekaInstanceConfigBean getDefaultRegistration() {
        LOGGER.info("Eureka registration method not provided, defaulting to route");
        return this.getRouteRegistration();
    }

    void setHostname(String hostname) {
        this.hostname = hostname;
    }

    void setCfAppGuid(String cfAppGuid) {
        this.cfAppGuid = cfAppGuid;
    }

    void setCfInstanceIndex(String cfInstanceIndex) {
        this.cfInstanceIndex = cfInstanceIndex;
    }

    void setIp(String ip) {
        this.ip = ip;
    }

    void setPort(int port) {
        this.port = port;
    }

    void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    void setRegistrationMethod(String registrationMethod) {
        this.registrationMethod = registrationMethod;
    }

    void setZoneUri(String zoneUri) {
        this.zoneUri = zoneUri;
    }
}

