/*
 * Decompiled with CFR 0.152.
 */
package io.pivotal.spring.cloud.service.config;

import io.pivotal.spring.cloud.config.java.ServiceInfoPropertySourceAdapter;
import io.pivotal.spring.cloud.service.common.ConfigServerServiceInfo;
import java.util.LinkedHashMap;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;

public class ConfigServerServiceConnector
extends ServiceInfoPropertySourceAdapter<ConfigServerServiceInfo> {
    private static final String PROPERTY_SOURCE_NAME = "springCloudServicesConfigServer";
    public static final String SPRING_CLOUD_CONFIG_URI = "spring.cloud.config.uri";
    public static final String SPRING_CLOUD_CONFIG_OAUTH2_CLIENT_CLIENT_ID = "spring.cloud.config.client.oauth2.clientId";
    public static final String SPRING_CLOUD_CONFIG_OAUTH2_CLIENT_CLIENT_SECRET = "spring.cloud.config.client.oauth2.clientSecret";
    public static final String SPRING_CLOUD_CONFIG_OAUTH2_CLIENT_ACCESS_TOKEN_URI = "spring.cloud.config.client.oauth2.accessTokenUri";

    @Override
    protected PropertySource<?> toPropertySource(ConfigServerServiceInfo serviceInfo) {
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        properties.put(SPRING_CLOUD_CONFIG_URI, serviceInfo.getUri());
        properties.put(SPRING_CLOUD_CONFIG_OAUTH2_CLIENT_CLIENT_ID, serviceInfo.getClientId());
        properties.put(SPRING_CLOUD_CONFIG_OAUTH2_CLIENT_CLIENT_SECRET, serviceInfo.getClientSecret());
        properties.put(SPRING_CLOUD_CONFIG_OAUTH2_CLIENT_ACCESS_TOKEN_URI, serviceInfo.getAccessTokenUri());
        return new MapPropertySource(PROPERTY_SOURCE_NAME, properties);
    }
}

