/*
 * Decompiled with CFR 0.152.
 */
package io.pivotal.spring.cloud.config.client;

import io.pivotal.spring.cloud.config.client.ConfigClientOAuth2Properties;
import io.pivotal.spring.cloud.config.client.OAuth2AuthorizedClientHttpRequestInterceptor;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.config.client.ConfigClientAutoConfiguration;
import org.springframework.cloud.config.client.ConfigClientProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@Configuration
@ConditionalOnBean(value={ConfigClientProperties.class})
@ConditionalOnProperty(prefix="spring.cloud.config", name={"token", "client.oauth2.clientId", "client.oauth2.clientSecret", "client.oauth2.accessTokenUri"})
@AutoConfigureAfter(value={ConfigClientAutoConfiguration.class})
@EnableConfigurationProperties(value={ConfigClientOAuth2Properties.class})
@EnableScheduling
public class VaultTokenRenewalAutoConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(VaultTokenRenewalAutoConfiguration.class);

    @Bean
    public VaultTokenRefresher vaultTokenRefresher(ConfigClientProperties configClientProperties, ConfigClientOAuth2Properties configClientOAuth2Properties, @Qualifier(value="vaultTokenRenewal") RestTemplate restTemplate, @Value(value="${spring.cloud.config.token}") String vaultToken, @Value(value="${vault.token.ttl:300000}") long renewTTL) {
        ClientRegistration clientRegistration = ClientRegistration.withRegistrationId((String)"config-client").authorizationGrantType(AuthorizationGrantType.CLIENT_CREDENTIALS).clientId(configClientOAuth2Properties.getClientId()).clientSecret(configClientOAuth2Properties.getClientSecret()).tokenUri(configClientOAuth2Properties.getAccessTokenUri()).build();
        restTemplate.getInterceptors().add(new OAuth2AuthorizedClientHttpRequestInterceptor(clientRegistration));
        String obscuredToken = vaultToken.substring(0, 4) + "[*]" + vaultToken.substring(vaultToken.length() - 4);
        String refreshUri = configClientProperties.getUri()[0] + "/vault/v1/auth/token/renew-self";
        long renewTTLInMS = renewTTL / 1000L;
        HttpEntity<Map<String, Long>> request = this.buildTokenRenewRequest(vaultToken, renewTTLInMS);
        return new VaultTokenRefresher(restTemplate, obscuredToken, renewTTL, refreshUri, request);
    }

    @Bean(value={"vaultTokenRenewal"})
    public RestTemplate restTemplate() {
        return new RestTemplate();
    }

    private HttpEntity<Map<String, Long>> buildTokenRenewRequest(String vaultToken, long renewTTL) {
        HashMap<String, Long> requestBody = new HashMap<String, Long>();
        requestBody.put("increment", renewTTL);
        HttpHeaders headers = new HttpHeaders();
        headers.set("X-Vault-Token", vaultToken);
        headers.setContentType(MediaType.APPLICATION_JSON);
        return new HttpEntity(requestBody, (MultiValueMap)headers);
    }

    static class VaultTokenRefresher {
        private final String obscuredToken;
        private final long renewTTL;
        private final String refreshUri;
        private final HttpEntity<Map<String, Long>> request;
        private final RestTemplate restTemplate;

        VaultTokenRefresher(RestTemplate restTemplate, String obscuredToken, long renewTTL, String refreshUri, HttpEntity<Map<String, Long>> request) {
            this.restTemplate = restTemplate;
            this.obscuredToken = obscuredToken;
            this.renewTTL = renewTTL;
            this.refreshUri = refreshUri;
            this.request = request;
        }

        @Scheduled(fixedRateString="${vault.token.renew.rate:60000}")
        public void refreshVaultToken() {
            try {
                LOGGER.debug("Renewing Vault token " + this.obscuredToken + " for " + this.renewTTL + " milliseconds.");
                this.restTemplate.postForObject(this.refreshUri, this.request, String.class, new Object[0]);
            }
            catch (RestClientException e) {
                LOGGER.error("Unable to renew Vault token " + this.obscuredToken + ". Is the token invalid or expired?");
            }
        }
    }
}

