/*
 * Decompiled with CFR 0.152.
 */
package io.pivotal.spring.cloud.config.client;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.logging.Log;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.util.StringUtils;

public class PropertyMaskingEnvironmentPostProcessor
implements EnvironmentPostProcessor {
    static final String SANITIZE_ENV_KEY = "management.endpoint.env.keys-to-sanitize";
    private static final String VAULT_PROPERTY_PATTERN = "configserver:vault:";
    private static final String CREDHUB_PROPERTY_PATTERN = "configserver:credhub-";
    private final Log log;

    public PropertyMaskingEnvironmentPostProcessor(Log log) {
        this.log = log;
    }

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        String[] defaultKeys = new String[]{"password", "secret", "key", "token", ".*credentials.*", "vcap_services"};
        Set<String> propertiesToSanitize = Stream.of(defaultKeys).collect(Collectors.toSet());
        MutablePropertySources propertySources = environment.getPropertySources();
        HashSet<PropertySource> configserverPropertySources = new HashSet<PropertySource>();
        for (PropertySource propertySource : propertySources) {
            if (!propertySource.getName().startsWith("configserver:")) continue;
            configserverPropertySources.add(propertySource);
        }
        Stream vaultKeyNameStream = configserverPropertySources.stream().filter(ps -> ps instanceof EnumerablePropertySource).filter(ps -> ps.getName().startsWith(VAULT_PROPERTY_PATTERN) || ps.getName().startsWith(CREDHUB_PROPERTY_PATTERN)).map(ps -> ((EnumerablePropertySource)ps).getPropertyNames()).flatMap(Arrays::stream);
        propertiesToSanitize.addAll(vaultKeyNameStream.collect(Collectors.toSet()));
        PropertiesPropertySource envKeysToSanitize = new PropertiesPropertySource(SANITIZE_ENV_KEY, this.mergeClientProperties(propertySources, propertiesToSanitize));
        environment.getPropertySources().addLast((PropertySource)envKeysToSanitize);
    }

    private Properties mergeClientProperties(MutablePropertySources propertySources, Set<String> propertiesToSanitize) {
        Properties props = new Properties();
        if (propertySources.contains(SANITIZE_ENV_KEY)) {
            String clientProperties = Objects.requireNonNull(propertySources.get(SANITIZE_ENV_KEY)).toString();
            propertiesToSanitize.addAll(Stream.of(clientProperties.split(",")).collect(Collectors.toSet()));
        }
        props.setProperty(SANITIZE_ENV_KEY, StringUtils.arrayToCommaDelimitedString((Object[])propertiesToSanitize.toArray()));
        return props;
    }
}

