/*
 * Decompiled with CFR 0.152.
 */
package io.pivotal.spring.cloud.config.client;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.cloud.config.client.ConfigServicePropertySourceLocator;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
@ConditionalOnClass(value={ConfigServicePropertySourceLocator.class})
public class PropertyMaskingContextInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext> {
    static final String SANITIZE_ENV_KEY = "management.endpoint.env.keys-to-sanitize";
    private static final String BOOTSTRAP_PROPERTY_SOURCE_NAME = "bootstrapProperties";
    private static final String CONFIG_SERVICE_PROPERTY_SOURCE_NAME = "configService";
    private static final String VAULT_PROPERTY_PATTERN = "vault:";
    private static final String CREDHUB_PROPERTY_PATTERN = "credhub-";

    public void initialize(ConfigurableApplicationContext applicationContext) {
        ConfigurableEnvironment environment = applicationContext.getEnvironment();
        MutablePropertySources propertySources = environment.getPropertySources();
        String[] defaultKeys = new String[]{"password", "secret", "key", "token", ".*credentials.*", "vcap_services"};
        Set<String> propertiesToSanitize = Stream.of(defaultKeys).collect(Collectors.toSet());
        PropertySource bootstrapProperties = propertySources.get(BOOTSTRAP_PROPERTY_SOURCE_NAME);
        HashSet bootstrapNestedPropertySources = new HashSet();
        HashSet configServiceNestedPropertySources = new HashSet();
        if (bootstrapProperties != null && bootstrapProperties instanceof CompositePropertySource) {
            bootstrapNestedPropertySources.addAll(((CompositePropertySource)bootstrapProperties).getPropertySources());
        }
        for (PropertySource nestedProperty : bootstrapNestedPropertySources) {
            if (!nestedProperty.getName().equals(CONFIG_SERVICE_PROPERTY_SOURCE_NAME)) continue;
            configServiceNestedPropertySources.addAll(((CompositePropertySource)nestedProperty).getPropertySources());
        }
        Stream vaultKeyNameStream = configServiceNestedPropertySources.stream().filter(ps -> ps instanceof EnumerablePropertySource).filter(ps -> ps.getName().startsWith(VAULT_PROPERTY_PATTERN) || ps.getName().startsWith(CREDHUB_PROPERTY_PATTERN)).map(ps -> ((EnumerablePropertySource)ps).getPropertyNames()).flatMap(Arrays::stream);
        propertiesToSanitize.addAll(vaultKeyNameStream.collect(Collectors.toSet()));
        PropertiesPropertySource envKeysToSanitize = new PropertiesPropertySource(SANITIZE_ENV_KEY, this.mergeClientProperties(propertySources, propertiesToSanitize));
        environment.getPropertySources().addFirst((PropertySource)envKeysToSanitize);
        applicationContext.setEnvironment(environment);
    }

    private Properties mergeClientProperties(MutablePropertySources propertySources, Set<String> propertiesToSanitize) {
        Properties props = new Properties();
        if (propertySources.contains(SANITIZE_ENV_KEY)) {
            String clientProperties = Objects.requireNonNull(propertySources.get(SANITIZE_ENV_KEY)).toString();
            propertiesToSanitize.addAll(Stream.of(clientProperties.split(",")).collect(Collectors.toSet()));
        }
        props.setProperty(SANITIZE_ENV_KEY, StringUtils.arrayToCommaDelimitedString((Object[])propertiesToSanitize.toArray()));
        return props;
    }
}

