/*
 * Decompiled with CFR 0.152.
 */
package io.pivotal.spring.cloud.config.client;

import io.pivotal.spring.cloud.config.client.ConfigClientOAuth2Properties;
import io.pivotal.spring.cloud.config.client.OAuth2AuthorizedClientHttpRequestInterceptor;
import javax.annotation.PostConstruct;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.config.client.ConfigServicePropertySourceLocator;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.util.Assert;
import org.springframework.web.client.RestTemplate;

@Configuration
@ConditionalOnClass(value={ConfigServicePropertySourceLocator.class})
@ConditionalOnProperty(prefix="spring.cloud.config.client.oauth2", name={"client-id", "client-secret", "access-token-uri"})
@EnableConfigurationProperties(value={ConfigClientOAuth2Properties.class})
public class ConfigClientOAuth2BootstrapConfiguration {
    private final ConfigServicePropertySourceLocator locator;
    private final ConfigClientOAuth2Properties configClientOAuth2Properties;

    public ConfigClientOAuth2BootstrapConfiguration(ConfigServicePropertySourceLocator locator, ConfigClientOAuth2Properties configClientOAuth2Properties) {
        Assert.notNull((Object)locator, (String)"Error injecting ConfigServicePropertySourceLocator, this can occurusing self signed certificates in Cloud Foundry without setting the TRUST_CERTS environment variable");
        this.locator = locator;
        this.configClientOAuth2Properties = configClientOAuth2Properties;
    }

    @PostConstruct
    public void init() {
        RestTemplate restTemplate = new RestTemplate();
        ClientRegistration clientRegistration = ClientRegistration.withRegistrationId((String)"config-client").clientId(this.configClientOAuth2Properties.getClientId()).clientSecret(this.configClientOAuth2Properties.getClientSecret()).tokenUri(this.configClientOAuth2Properties.getAccessTokenUri()).authorizationGrantType(AuthorizationGrantType.CLIENT_CREDENTIALS).build();
        restTemplate.getInterceptors().add(new OAuth2AuthorizedClientHttpRequestInterceptor(clientRegistration));
        this.locator.setRestTemplate(restTemplate);
    }
}

