/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.wan.serial;

import java.util.Set;
import org.apache.geode.cache.asyncqueue.AsyncEventListener;
import org.apache.geode.cache.wan.GatewayEventFilter;
import org.apache.geode.cache.wan.GatewaySender;
import org.apache.geode.distributed.DistributedLockService;
import org.apache.geode.distributed.internal.DistributionAdvisee;
import org.apache.geode.distributed.internal.DistributionAdvisor;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.ResourceEvent;
import org.apache.geode.i18n.StringId;
import org.apache.geode.internal.cache.EntryEventImpl;
import org.apache.geode.internal.cache.EventID;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.RegionQueue;
import org.apache.geode.internal.cache.UpdateAttributesProcessor;
import org.apache.geode.internal.cache.ha.ThreadIdentifier;
import org.apache.geode.internal.cache.wan.AbstractRemoteGatewaySender;
import org.apache.geode.internal.cache.wan.GatewaySenderAdvisor;
import org.apache.geode.internal.cache.wan.GatewaySenderAttributes;
import org.apache.geode.internal.cache.wan.GatewaySenderConfigurationException;
import org.apache.geode.internal.cache.wan.serial.RemoteConcurrentSerialGatewaySenderEventProcessor;
import org.apache.geode.internal.cache.wan.serial.RemoteSerialGatewaySenderEventProcessor;
import org.apache.geode.internal.cache.wan.serial.SerialGatewaySenderQueue;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public class SerialGatewaySenderImpl
extends AbstractRemoteGatewaySender {
    private static final Logger logger = LogService.getLogger();

    public SerialGatewaySenderImpl(InternalCache cache, GatewaySenderAttributes attrs) {
        super(cache, attrs);
    }

    public void start() {
        if (logger.isDebugEnabled()) {
            logger.debug("Starting gatewaySender : {}", (Object)this);
        }
        this.getLifeCycleLock().writeLock().lock();
        try {
            String locators;
            if (this.isRunning()) {
                logger.warn((Message)LocalizedMessage.create((StringId)LocalizedStrings.GatewaySender_SENDER_0_IS_ALREADY_RUNNING, (Object)this.getId()));
                return;
            }
            if (this.remoteDSId != -1 && (locators = this.cache.getInternalDistributedSystem().getConfig().getLocators()).length() == 0) {
                throw new GatewaySenderConfigurationException(LocalizedStrings.AbstractGatewaySender_LOCATOR_SHOULD_BE_CONFIGURED_BEFORE_STARTING_GATEWAY_SENDER.toLocalizedString());
            }
            this.getSenderAdvisor().initDLockService();
            if (!this.isPrimary()) {
                if (this.getSenderAdvisor().volunteerForPrimary()) {
                    this.getSenderAdvisor().makePrimary();
                } else {
                    this.getSenderAdvisor().makeSecondary();
                }
            }
            this.eventProcessor = this.getDispatcherThreads() > 1 ? new RemoteConcurrentSerialGatewaySenderEventProcessor(this) : new RemoteSerialGatewaySenderEventProcessor(this, this.getId());
            this.eventProcessor.start();
            this.waitForRunningStatus();
            this.startTime = System.currentTimeMillis();
            if (!this.isAsyncEventQueue()) {
                this.getCache().getPdxRegistry().gatewaySenderStarted((GatewaySender)this);
            }
            new UpdateAttributesProcessor((DistributionAdvisee)this).distribute(false);
            InternalDistributedSystem system = this.cache.getInternalDistributedSystem();
            system.handleResourceEvent(ResourceEvent.GATEWAYSENDER_START, (Object)this);
            logger.info((Message)LocalizedMessage.create((StringId)LocalizedStrings.SerialGatewaySenderImpl_STARTED__0, (Object)((Object)this)));
            this.enqueueTempEvents();
        }
        finally {
            this.getLifeCycleLock().writeLock().unlock();
        }
    }

    public void stop() {
        Set queues;
        if (logger.isDebugEnabled()) {
            logger.debug("Stopping Gateway Sender : {}", (Object)this);
        }
        this.getLifeCycleLock().writeLock().lock();
        try {
            this.stopProcessing();
            this.stompProxyDead();
            for (Object listener : this.listeners) {
                listener.close();
            }
            logger.info((Message)LocalizedMessage.create((StringId)LocalizedStrings.GatewayImpl_STOPPED__0, (Object)((Object)this)));
            this.clearTempEventsAfterSenderStopped();
        }
        finally {
            this.getLifeCycleLock().writeLock().unlock();
        }
        if (this.isPrimary()) {
            try {
                DistributedLockService.destroy((String)this.getSenderAdvisor().getDLockServiceName());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if ((queues = this.getQueues()) != null && !queues.isEmpty()) {
            for (RegionQueue q : queues) {
                ((SerialGatewaySenderQueue)q).cleanUp();
            }
        }
        this.setIsPrimary(false);
        new UpdateAttributesProcessor((DistributionAdvisee)this).distribute(false);
        Thread lockObtainingThread = this.getSenderAdvisor().getLockObtainingThread();
        if (lockObtainingThread != null && lockObtainingThread.isAlive()) {
            try {
                lockObtainingThread.join(3000L);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
            if (lockObtainingThread.isAlive()) {
                logger.info((Message)LocalizedMessage.create((StringId)LocalizedStrings.GatewaySender_COULD_NOT_STOP_LOCK_OBTAINING_THREAD_DURING_GATEWAY_SENDER_STOP));
            }
        }
        InternalDistributedSystem system = (InternalDistributedSystem)this.cache.getDistributedSystem();
        system.handleResourceEvent(ResourceEvent.GATEWAYSENDER_STOP, (Object)this);
        this.eventProcessor = null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SerialGatewaySender{");
        sb.append("id=").append(this.getId());
        sb.append(",remoteDsId=").append(this.getRemoteDSId());
        sb.append(",isRunning =").append(this.isRunning());
        sb.append(",isPrimary =").append(this.isPrimary());
        sb.append("}");
        return sb.toString();
    }

    public void fillInProfile(DistributionAdvisor.Profile profile) {
        assert (profile instanceof GatewaySenderAdvisor.GatewaySenderProfile);
        GatewaySenderAdvisor.GatewaySenderProfile pf = (GatewaySenderAdvisor.GatewaySenderProfile)profile;
        pf.Id = this.getId();
        pf.startTime = this.getStartTime();
        pf.remoteDSId = this.getRemoteDSId();
        pf.isRunning = this.isRunning();
        pf.isPrimary = this.isPrimary();
        pf.isParallel = false;
        pf.isBatchConflationEnabled = this.isBatchConflationEnabled();
        pf.isPersistenceEnabled = this.isPersistenceEnabled();
        pf.alertThreshold = this.getAlertThreshold();
        pf.manualStart = this.isManualStart();
        for (GatewayEventFilter filter : this.getGatewayEventFilters()) {
            pf.eventFiltersClassNames.add(filter.getClass().getName());
        }
        for (GatewayEventFilter filter : this.getGatewayTransportFilters()) {
            pf.transFiltersClassNames.add(filter.getClass().getName());
        }
        for (AsyncEventListener listener : this.getAsyncEventListeners()) {
            pf.senderEventListenerClassNames.add(listener.getClass().getName());
        }
        pf.isDiskSynchronous = this.isDiskSynchronous();
        pf.dispatcherThreads = this.getDispatcherThreads();
        pf.orderPolicy = this.getOrderPolicy();
        pf.serverLocation = this.getServerLocation();
    }

    protected void setModifiedEventId(EntryEventImpl clonedEvent) {
        EventID originalEventId = clonedEvent.getEventId();
        long originalThreadId = originalEventId.getThreadID();
        long newThreadId = originalThreadId;
        if (!ThreadIdentifier.isWanTypeThreadID((long)newThreadId)) {
            newThreadId = ThreadIdentifier.createFakeThreadIDForParallelGSPrimaryBucket((int)0, (long)originalThreadId, (int)this.getEventIdIndex());
        }
        EventID newEventId = new EventID(originalEventId.getMembershipID(), newThreadId, originalEventId.getSequenceID());
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Generated event id for event with key={}, original event id={}, originalThreadId={}, new event id={}, newThreadId={}", (Object)this, clonedEvent.getKey(), (Object)originalEventId, (Object)originalThreadId, (Object)newEventId, (Object)newThreadId);
        }
        clonedEvent.setEventId(newEventId);
    }
}

