/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.configuration.domain;

import java.util.Properties;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.Declarable;
import org.apache.geode.cache.configuration.ClassNameType;
import org.apache.geode.cache.configuration.DeclarableType;
import org.apache.geode.cache.configuration.ObjectType;
import org.apache.geode.cache.configuration.ParameterType;
import org.apache.geode.internal.ClassPathLoader;
import org.apache.geode.management.internal.cli.domain.ClassName;

public abstract class DeclarableTypeInstantiator {
    public static <T extends Declarable> T newInstance(DeclarableType declarableType, Cache cache) {
        try {
            Class<?> loadedClass = ClassPathLoader.getLatest().forName(declarableType.getClassName());
            Declarable declarable = (Declarable)loadedClass.newInstance();
            Properties initProperties = new Properties();
            for (ParameterType parameter : declarableType.getParameters()) {
                initProperties.put(parameter.getName(), DeclarableTypeInstantiator.newInstance((ObjectType)parameter, cache));
            }
            declarable.initialize(cache, initProperties);
            return (T)declarable;
        }
        catch (Exception e) {
            throw new RuntimeException("Error instantiating class: <" + declarableType.getClassName() + ">", e);
        }
    }

    public static <T> T newInstance(ObjectType objectType, Cache cache) {
        if (objectType.getString() != null) {
            return (T)objectType.getString();
        }
        if (objectType.getDeclarable() != null) {
            return DeclarableTypeInstantiator.newInstance(objectType.getDeclarable(), cache);
        }
        return null;
    }

    public static <V> V newInstance(ClassName<?> type, Cache cache) {
        try {
            Class<?> loadedClass = ClassPathLoader.getLatest().forName(type.getClassName());
            Object object = loadedClass.newInstance();
            if (object instanceof Declarable) {
                Declarable declarable = (Declarable)object;
                declarable.initialize(cache, type.getInitProperties());
                declarable.init(type.getInitProperties());
            }
            return (V)object;
        }
        catch (Exception e) {
            throw new RuntimeException("Error instantiating class: <" + type.getClassName() + ">", e);
        }
    }

    public static <V> V newInstance(ClassNameType className) {
        try {
            Class<?> loadedClass = ClassPathLoader.getLatest().forName(className.getClassName());
            return (V)loadedClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Error instantiating class: <" + className.getClassName() + ">", e);
        }
    }
}

