/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.util;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.internal.logging.log4j.LogLevel;
import org.apache.logging.log4j.Level;

public class LogLevelExtractor {
    private static final Pattern LOG_PATTERN = Pattern.compile("^\\[(\\S*)\\s+([\\d\\/]+)\\s+([\\d:\\.]+)\\s+(\\S+)");
    @Immutable
    private static final DateTimeFormatter LOG_TIMESTAMP_FORMATTER = DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm:ss.SSS zzz");
    private static final String SPACE = " ";

    public static Result extract(String logLine) {
        Matcher m = LOG_PATTERN.matcher(logLine);
        if (!m.find()) {
            return null;
        }
        String logLevel = m.group(1);
        String logTimestamp = m.group(2) + SPACE + m.group(3) + SPACE + m.group(4);
        LocalDateTime timestamp = LocalDateTime.parse(logTimestamp, LOG_TIMESTAMP_FORMATTER);
        return new Result(logLevel, timestamp);
    }

    public static class Result {
        private Level logLevel;
        private LocalDateTime logTimestamp;

        public Result(String logLevel, LocalDateTime logTimestamp) {
            this.logLevel = LogLevel.resolveLevel(logLevel);
            this.logTimestamp = logTimestamp;
        }

        public Level getLogLevel() {
            return this.logLevel;
        }

        public LocalDateTime getLogTimestamp() {
            return this.logTimestamp;
        }
    }
}

