/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.management.internal.cli.util.LogFilter;
import org.apache.geode.management.internal.configuration.utils.ZipUtils;
import org.apache.logging.log4j.Logger;

public class LogExporter {
    private static final Logger LOGGER = LogService.getLogger();
    private final LogFilter logFilter;
    private final File baseLogFile;
    private final File baseStatsFile;

    public LogExporter(LogFilter logFilter, File baseLogFile, File baseStatsFile) {
        assert (logFilter != null);
        this.logFilter = logFilter;
        this.baseLogFile = baseLogFile;
        this.baseStatsFile = baseStatsFile;
    }

    public Path export() throws IOException {
        Path tempDirectory = Files.createTempDirectory("exportLogs", new FileAttribute[0]);
        if (this.baseLogFile != null) {
            for (Path logFile : this.findLogFiles(this.baseLogFile.toPath().getParent())) {
                Path filteredLogFile = tempDirectory.resolve(logFile.getFileName());
                this.writeFilteredLogFile(logFile, filteredLogFile);
            }
        }
        if (this.baseStatsFile != null) {
            for (Path statFile : this.findStatFiles(this.baseStatsFile.toPath().getParent())) {
                Files.copy(statFile, tempDirectory.resolve(statFile.getFileName()), new CopyOption[0]);
            }
        }
        Path zipFile = null;
        if (tempDirectory.toFile().listFiles().length > 0) {
            zipFile = Files.createTempFile("logExport", ".zip", new FileAttribute[0]);
            ZipUtils.zipDirectory(tempDirectory, zipFile);
            LOGGER.info("Zipped files to: " + zipFile);
        }
        FileUtils.deleteDirectory((File)tempDirectory.toFile());
        return zipFile;
    }

    protected void writeFilteredLogFile(Path originalLogFile, Path filteredLogFile) throws IOException {
        this.logFilter.startNewFile();
        try (BufferedReader reader = new BufferedReader(new FileReader(originalLogFile.toFile()));
             BufferedWriter writer = new BufferedWriter(new FileWriter(filteredLogFile.toFile()));){
            String line;
            while ((line = reader.readLine()) != null) {
                LogFilter.LineFilterResult result = this.logFilter.acceptsLine(line);
                if (result == LogFilter.LineFilterResult.REMAINDER_OF_FILE_REJECTED) {
                    break;
                }
                if (result != LogFilter.LineFilterResult.LINE_ACCEPTED) continue;
                this.writeLine(line, writer);
            }
        }
    }

    private void writeLine(String line, BufferedWriter writer) {
        try {
            writer.write(line);
            writer.newLine();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to write to log file", e);
        }
    }

    public long estimateFilteredSize() throws IOException {
        long filteredSize = 0L;
        if (this.baseLogFile != null) {
            for (Path logFile : this.findLogFiles(this.baseLogFile.toPath().getParent())) {
                filteredSize += this.filterAndSize(logFile);
            }
        }
        if (this.baseStatsFile != null) {
            for (Path statFile : this.findStatFiles(this.baseStatsFile.toPath().getParent())) {
                filteredSize += statFile.toFile().length();
            }
        }
        return filteredSize;
    }

    private long filterAndSize(Path originalLogFile) throws IOException {
        long size = 0L;
        this.logFilter.startNewFile();
        try (BufferedReader reader = new BufferedReader(new FileReader(originalLogFile.toFile()));){
            String line;
            while ((line = reader.readLine()) != null) {
                LogFilter.LineFilterResult result = this.logFilter.acceptsLine(line);
                if (result == LogFilter.LineFilterResult.REMAINDER_OF_FILE_REJECTED) {
                    break;
                }
                if (result != LogFilter.LineFilterResult.LINE_ACCEPTED) continue;
                size += (long)(line.length() + System.lineSeparator().length());
            }
        }
        return size;
    }

    List<Path> findLogFiles(Path workingDir) throws IOException {
        Predicate<Path> logFileSelector = file -> file.toString().toLowerCase().endsWith(".log");
        return this.findFiles(workingDir, logFileSelector);
    }

    List<Path> findStatFiles(Path workingDir) throws IOException {
        Predicate<Path> statFileSelector = file -> file.toString().toLowerCase().endsWith(".gfs");
        return this.findFiles(workingDir, statFileSelector);
    }

    private List<Path> findFiles(Path workingDir, Predicate<Path> fileSelector) throws IOException {
        if (!workingDir.toFile().isDirectory()) {
            return Collections.emptyList();
        }
        Stream<Path> selectedFiles = Files.list(workingDir).filter(fileSelector).filter(this.logFilter::acceptsFile);
        return selectedFiles.collect(Collectors.toList());
    }
}

