/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.geode.management.internal.cli.json.GfJsonException;
import org.apache.geode.management.internal.cli.json.GfJsonObject;

public class JsonUtil {
    public static <T> T jsonToObject(String jsonString, Class<T> klass) {
        T objectFromJson = null;
        try {
            GfJsonObject jsonObject = new GfJsonObject(jsonString);
            objectFromJson = klass.newInstance();
            Method[] declaredMethods = klass.getMethods();
            HashMap<String, Method> methodsMap = new HashMap<String, Method>();
            for (Method method : declaredMethods) {
                methodsMap.put(method.getName(), method);
            }
            int noOfFields = jsonObject.size();
            Iterator<String> keys = jsonObject.keys();
            while (keys.hasNext()) {
                Class<?>[] parameterTypes;
                Method method;
                String key = keys.next();
                method = (Method)methodsMap.get("set" + JsonUtil.capitalize(key));
                if (method == null || (parameterTypes = method.getParameterTypes()).length != 1) continue;
                Class<?> parameterType = parameterTypes[0];
                Object value = jsonObject.get(key);
                value = JsonUtil.isPrimitiveOrWrapper(parameterType) ? ConvertUtils.convert((Object)JsonUtil.getPrimitiveOrWrapperValue(parameterType, value), parameterType) : (JsonUtil.isArray(parameterType) ? JsonUtil.toArray(value, parameterType) : (JsonUtil.isList(parameterType) ? JsonUtil.toList(value, parameterType) : (JsonUtil.isMap(parameterType) ? JsonUtil.toMap(value, parameterType) : (JsonUtil.isSet(parameterType) ? JsonUtil.toSet(value, parameterType) : JsonUtil.jsonToObject(value.toString(), parameterType)))));
                method.invoke(objectFromJson, value);
                --noOfFields;
            }
            if (noOfFields != 0) {
                throw new IllegalArgumentException("Not enough setter methods for fields in given JSON String : " + jsonString + " in class : " + klass);
            }
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Couldn't convert JSON to Object of type " + klass, e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Couldn't convert JSON to Object of type " + klass, e);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Couldn't convert JSON to Object of type " + klass, e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException("Couldn't convert JSON to Object of type " + klass, e);
        }
        catch (GfJsonException e) {
            throw new IllegalArgumentException(e);
        }
        return objectFromJson;
    }

    private static void throwUnsupportedType(String containerType, JsonNodeType valueType) throws GfJsonException {
        throw new GfJsonException(String.format("Only primitive types are supported in %s type for input commands but found %s", containerType, valueType.toString()));
    }

    private static Object toArray(Object value, Class<?> parameterType) throws GfJsonException {
        Class<?> arrayComponentType = parameterType.getComponentType();
        if (JsonUtil.isPrimitiveOrWrapper(arrayComponentType)) {
            if (value instanceof ArrayNode) {
                try {
                    ArrayNode jsonArray = (ArrayNode)value;
                    Object jArray = Array.newInstance(arrayComponentType, jsonArray.size());
                    block14: for (int i = 0; i < jsonArray.size(); ++i) {
                        JsonNode elem = jsonArray.get(i);
                        switch (elem.getNodeType()) {
                            case ARRAY: {
                                JsonUtil.throwUnsupportedType("array", elem.getNodeType());
                            }
                            case BINARY: {
                                JsonUtil.throwUnsupportedType("array", elem.getNodeType());
                            }
                            case BOOLEAN: {
                                Array.set(jArray, i, jsonArray.get(i).booleanValue());
                            }
                            case MISSING: {
                                JsonUtil.throwUnsupportedType("array", elem.getNodeType());
                            }
                            case NULL: {
                                JsonUtil.throwUnsupportedType("array", elem.getNodeType());
                            }
                            case NUMBER: {
                                if (elem.isIntegralNumber()) {
                                    Array.set(jArray, i, elem.longValue());
                                    continue block14;
                                }
                                Array.set(jArray, i, elem.doubleValue());
                                continue block14;
                            }
                            case OBJECT: {
                                JsonUtil.throwUnsupportedType("array", elem.getNodeType());
                            }
                            case POJO: {
                                JsonUtil.throwUnsupportedType("array", elem.getNodeType());
                            }
                            case STRING: {
                                if (elem.textValue() != null) {
                                    Array.set(jArray, i, elem.textValue());
                                    continue block14;
                                }
                                Array.set(jArray, i, elem.toString());
                            }
                        }
                    }
                    return jArray;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw new GfJsonException(e);
                }
                catch (IllegalArgumentException e) {
                    throw new GfJsonException(e);
                }
            }
            throw new GfJsonException("Expected JSONArray for array type");
        }
        throw new GfJsonException("Array contains non-primitive element. Non-primitive elements are not supported in json array");
    }

    private static Object toSet(Object value, Class<?> parameterType) throws GfJsonException {
        try {
            ArrayNode array = (ArrayNode)value;
            HashSet<Object> set = new HashSet<Object>();
            block13: for (int i = 0; i < array.size(); ++i) {
                JsonNode elem = array.get(i);
                switch (elem.getNodeType()) {
                    case ARRAY: {
                        JsonUtil.throwUnsupportedType("list", elem.getNodeType());
                    }
                    case BINARY: {
                        JsonUtil.throwUnsupportedType("list", elem.getNodeType());
                    }
                    case BOOLEAN: {
                        set.add(elem.booleanValue());
                    }
                    case MISSING: {
                        JsonUtil.throwUnsupportedType("list", elem.getNodeType());
                    }
                    case NULL: {
                        JsonUtil.throwUnsupportedType("list", elem.getNodeType());
                    }
                    case NUMBER: {
                        if (elem.isIntegralNumber()) {
                            set.add(elem.longValue());
                            continue block13;
                        }
                        set.add(elem.doubleValue());
                        continue block13;
                    }
                    case OBJECT: {
                        JsonUtil.throwUnsupportedType("list", elem.getNodeType());
                    }
                    case POJO: {
                        JsonUtil.throwUnsupportedType("list", elem.getNodeType());
                    }
                    case STRING: {
                        if (elem.textValue() != null) {
                            set.add(elem.textValue());
                            continue block13;
                        }
                        set.add(elem.toString());
                    }
                }
            }
            return set;
        }
        catch (Exception e) {
            throw new GfJsonException(e);
        }
    }

    private static Object toMap(Object value, Class<?> parameterType) throws GfJsonException {
        try {
            if (value instanceof ObjectNode) {
                ObjectNode obj = (ObjectNode)value;
                Iterator iterator = obj.fieldNames();
                HashMap<String, Object> map = new HashMap<String, Object>();
                while (iterator.hasNext()) {
                    String key = (String)iterator.next();
                    JsonNode elem = obj.get(key);
                    switch (elem.getNodeType()) {
                        case ARRAY: {
                            JsonUtil.throwUnsupportedType("map", elem.getNodeType());
                        }
                        case BINARY: {
                            JsonUtil.throwUnsupportedType("map", elem.getNodeType());
                        }
                        case BOOLEAN: {
                            map.put(key, elem.booleanValue());
                        }
                        case MISSING: {
                            JsonUtil.throwUnsupportedType("map", elem.getNodeType());
                        }
                        case NULL: {
                            JsonUtil.throwUnsupportedType("map", elem.getNodeType());
                        }
                        case NUMBER: {
                            if (elem.isIntegralNumber()) {
                                map.put(key, elem.longValue());
                                break;
                            }
                            map.put(key, elem.doubleValue());
                            break;
                        }
                        case OBJECT: {
                            JsonUtil.throwUnsupportedType("map", elem.getNodeType());
                        }
                        case POJO: {
                            JsonUtil.throwUnsupportedType("map", elem.getNodeType());
                        }
                        case STRING: {
                            if (elem.textValue() != null) {
                                map.put(key, elem.textValue());
                                break;
                            }
                            map.put(key, elem.toString());
                        }
                    }
                }
                return map;
            }
            throw new GfJsonException("Expected JSONObject for Map. Retrieved type is " + value.getClass());
        }
        catch (Exception e) {
            throw new GfJsonException(e);
        }
    }

    private static Object toList(Object value, Class<?> parameterType) throws GfJsonException {
        try {
            ArrayNode array = (ArrayNode)value;
            ArrayList<Object> list = new ArrayList<Object>();
            block13: for (int i = 0; i < array.size(); ++i) {
                JsonNode elem = array.get(i);
                switch (elem.getNodeType()) {
                    case ARRAY: {
                        JsonUtil.throwUnsupportedType("list", elem.getNodeType());
                    }
                    case BINARY: {
                        JsonUtil.throwUnsupportedType("list", elem.getNodeType());
                    }
                    case BOOLEAN: {
                        list.add(elem.booleanValue());
                    }
                    case MISSING: {
                        JsonUtil.throwUnsupportedType("list", elem.getNodeType());
                    }
                    case NULL: {
                        JsonUtil.throwUnsupportedType("list", elem.getNodeType());
                    }
                    case NUMBER: {
                        if (elem.isIntegralNumber()) {
                            list.add(elem.longValue());
                            continue block13;
                        }
                        list.add(elem.doubleValue());
                        continue block13;
                    }
                    case OBJECT: {
                        JsonUtil.throwUnsupportedType("list", elem.getNodeType());
                    }
                    case POJO: {
                        JsonUtil.throwUnsupportedType("list", elem.getNodeType());
                    }
                    case STRING: {
                        if (elem.textValue() != null) {
                            list.add(elem.textValue());
                            continue block13;
                        }
                        list.add(elem.toString());
                    }
                }
            }
            return list;
        }
        catch (Exception e) {
            throw new GfJsonException(e);
        }
    }

    public static String capitalize(String str) {
        String capitalized = str;
        if (str == null || str.isEmpty()) {
            return capitalized;
        }
        capitalized = String.valueOf(str.charAt(0)).toUpperCase() + str.substring(1);
        return capitalized;
    }

    private static boolean isArray(Class<?> parameterType) {
        return parameterType.isArray();
    }

    public static boolean isList(Class<?> klass) {
        return klass.isAssignableFrom(List.class);
    }

    public static boolean isSet(Class<?> klass) {
        return klass.isAssignableFrom(Set.class);
    }

    public static boolean isMap(Class<?> klass) {
        return klass.isAssignableFrom(Map.class);
    }

    public static boolean isPrimitiveOrWrapper(Class<?> klass) {
        return klass.isAssignableFrom(Byte.class) || klass.isAssignableFrom(Byte.TYPE) || klass.isAssignableFrom(Short.class) || klass.isAssignableFrom(Short.TYPE) || klass.isAssignableFrom(Integer.class) || klass.isAssignableFrom(Integer.TYPE) || klass.isAssignableFrom(Long.class) || klass.isAssignableFrom(Long.TYPE) || klass.isAssignableFrom(Float.class) || klass.isAssignableFrom(Float.TYPE) || klass.isAssignableFrom(Double.class) || klass.isAssignableFrom(Double.TYPE) || klass.isAssignableFrom(Boolean.class) || klass.isAssignableFrom(Boolean.TYPE) || klass.isAssignableFrom(Character.class) || klass.isAssignableFrom(Character.TYPE) || klass.isAssignableFrom(String.class);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object getPrimitiveOrWrapperValue(Class<?> klass, Object value) throws IllegalArgumentException {
        if (klass.isAssignableFrom(Byte.class) || klass.isAssignableFrom(Byte.TYPE)) {
            return value;
        }
        if (klass.isAssignableFrom(Short.class) || klass.isAssignableFrom(Short.TYPE)) {
            return value;
        }
        if (klass.isAssignableFrom(Integer.class) || klass.isAssignableFrom(Integer.TYPE)) {
            return value;
        }
        if (klass.isAssignableFrom(Long.class) || klass.isAssignableFrom(Long.TYPE)) {
            return value;
        }
        if (klass.isAssignableFrom(Float.class) || klass.isAssignableFrom(Float.TYPE)) {
            return value;
        }
        if (klass.isAssignableFrom(Double.class) || klass.isAssignableFrom(Double.TYPE)) {
            return value;
        }
        if (klass.isAssignableFrom(Boolean.class) || klass.isAssignableFrom(Boolean.TYPE)) {
            return value;
        }
        if (klass.isAssignableFrom(String.class)) {
            return String.valueOf(value);
        }
        if (klass.isAssignableFrom(Character.class)) {
            if (value instanceof String) {
                String str = (String)value;
                if (str.length() == 1) {
                    return new Character(str.charAt(0));
                }
                if (str.length() <= 1 && str.length() != 0) return value;
                throw new IllegalArgumentException("Expected Character value but found String with length " + str.length());
            }
            if (!(value instanceof Character)) throw new IllegalArgumentException("Expected Character value but found " + value.getClass());
            return value;
        }
        if (!klass.isAssignableFrom(Character.TYPE)) return null;
        if (value instanceof String) {
            String str = (String)value;
            if (str.length() == 1) {
                return Character.valueOf(str.charAt(0));
            }
            if (str.length() <= 1 && str.length() != 0) return value;
            throw new IllegalArgumentException("Expected Character value but found String with length " + str.length());
        }
        if (!(value instanceof Character)) throw new IllegalArgumentException("Expected Character value but found " + value.getClass());
        return Character.valueOf(((Character)value).charValue());
    }
}

