/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.shell;

import java.io.IOException;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.Query;
import javax.management.QueryExp;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.lang.StringUtils;
import org.apache.geode.management.DistributedSystemMXBean;
import org.apache.geode.management.MemberMXBean;
import org.apache.geode.management.internal.cli.shell.Gfsh;

public class MXBeanProvider {
    public static DistributedSystemMXBean getDistributedSystemMXBean() throws IOException, MalformedObjectNameException {
        Assert.assertState(Gfsh.isCurrentInstanceConnectedAndReady(), "Gfsh must be connected in order to get proxy to a GemFire DistributedSystemMXBean.", new Object[0]);
        return Gfsh.getCurrentInstance().getOperationInvoker().getDistributedSystemMXBean();
    }

    public static MemberMXBean getMemberMXBean(String member) throws IOException {
        return MXBeanProvider.getMemberMXBean(null, member);
    }

    public static MemberMXBean getMemberMXBean(String serviceName, String member) throws IOException {
        Assert.assertState(Gfsh.isCurrentInstanceConnectedAndReady(), "Gfsh must be connected in order to get proxy to a GemFire Member MBean.", new Object[0]);
        MemberMXBean memberBean = null;
        try {
            String objectNamePattern = "GemFire:";
            objectNamePattern = objectNamePattern + (StringUtils.isBlank((CharSequence)serviceName) ? "" : "service=" + serviceName + ",");
            objectNamePattern = objectNamePattern + "type=Member,*";
            ObjectName objectName = ObjectName.getInstance(objectNamePattern);
            QueryExp query = Query.or(Query.eq(Query.attr("Name"), Query.value(member)), Query.eq(Query.attr("Id"), Query.value(member)));
            Set<ObjectName> memberObjectNames = Gfsh.getCurrentInstance().getOperationInvoker().queryNames(objectName, query);
            if (!memberObjectNames.isEmpty()) {
                memberBean = Gfsh.getCurrentInstance().getOperationInvoker().getMBeanProxy(memberObjectNames.iterator().next(), MemberMXBean.class);
            }
        }
        catch (MalformedObjectNameException e) {
            Gfsh.getCurrentInstance().logSevere(e.getMessage(), e);
        }
        return memberBean;
    }
}

